/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.logging2;

import gg.essential.lib.jitsi.utils.logging2.ContextLogRecord;
import gg.essential.lib.jitsi.utils.logging2.LogContext;
import gg.essential.lib.jitsi.utils.logging2.Logger;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;

public class LoggerImpl
implements Logger {
    private final java.util.logging.Logger loggerDelegate;
    private final Level minLogLevel;
    private final LogContext logContext;
    static Function<String, java.util.logging.Logger> loggerFactory = java.util.logging.Logger::getLogger;

    public LoggerImpl(String name2) {
        this(name2, Level.ALL);
    }

    public LoggerImpl(String name2, Level minLogLevel) {
        this(name2, minLogLevel, new LogContext());
    }

    public LoggerImpl(String name2, LogContext logContext) {
        this(name2, Level.ALL, logContext);
    }

    public LoggerImpl(String name2, Level minLogLevel, LogContext logContext) {
        this.loggerDelegate = loggerFactory.apply(name2);
        this.minLogLevel = minLogLevel;
        this.logContext = logContext;
    }

    @Override
    public Logger createChildLogger(String name2, Map<String, String> context) {
        return new LoggerImpl(name2, this.minLogLevel, this.logContext.createSubContext(context));
    }

    @Override
    public Logger createChildLogger(String name2) {
        return new LoggerImpl(name2, this.minLogLevel, this.logContext.createSubContext(Collections.emptyMap()));
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.loggerDelegate.setUseParentHandlers(false);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        this.loggerDelegate.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        this.loggerDelegate.removeHandler(handler);
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this.minLogLevel.intValue() && this.loggerDelegate.isLoggable(level);
    }

    private void log(Level level, Object msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        ContextLogRecord lr = new ContextLogRecord(level, msg.toString(), this.logContext.formattedContext);
        lr.setThrown(thrown);
        lr.setLoggerName(this.loggerDelegate.getName());
        this.loggerDelegate.log(lr);
    }

    private void log(Level level, Object msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        ContextLogRecord lr = new ContextLogRecord(level, msg.toString(), this.logContext.formattedContext);
        lr.setLoggerName(this.loggerDelegate.getName());
        this.loggerDelegate.log(lr);
    }

    private void log(Level level, Supplier<String> msgSupplier) {
        if (!this.isLoggable(level)) {
            return;
        }
        ContextLogRecord lr = new ContextLogRecord(level, msgSupplier.get(), this.logContext.formattedContext);
        lr.setLoggerName(this.loggerDelegate.getName());
        this.loggerDelegate.log(lr);
    }

    @Override
    public void setLevel(Level level) {
        Handler[] handlers;
        for (Handler handler : handlers = this.loggerDelegate.getHandlers()) {
            handler.setLevel(level);
        }
        this.loggerDelegate.setLevel(level);
    }

    @Override
    public Level getLevel() {
        Level level = this.loggerDelegate.getLevel();
        return level != null ? level : Level.INFO;
    }

    @Override
    public void setLevelAll() {
        this.setLevel(Level.ALL);
    }

    @Override
    public void setLevelDebug() {
        this.setLevel(Level.FINE);
    }

    @Override
    public void setLevelError() {
        this.setLevel(Level.SEVERE);
    }

    @Override
    public void setLevelInfo() {
        this.setLevel(Level.INFO);
    }

    @Override
    public void setLevelOff() {
        this.setLevel(Level.OFF);
    }

    @Override
    public void setLevelTrace() {
        this.setLevel(Level.FINER);
    }

    @Override
    public void setLevelWarn() {
        this.setLevel(Level.WARNING);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLoggable(Level.FINER);
    }

    @Override
    public void trace(Object msg) {
        this.log(Level.FINER, msg);
    }

    @Override
    public void trace(Supplier<String> msgSupplier) {
        this.log(Level.FINER, msgSupplier);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(Level.FINE);
    }

    @Override
    public void debug(Object msg) {
        this.log(Level.FINE, msg);
    }

    @Override
    public void debug(Supplier<String> msgSupplier) {
        this.log(Level.FINE, msgSupplier);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(Level.INFO);
    }

    @Override
    public void info(Object msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public void info(Supplier<String> msgSupplier) {
        this.log(Level.INFO, msgSupplier);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(Object msg) {
        this.log(Level.WARNING, msg);
    }

    @Override
    public void warn(Supplier<String> msgSupplier) {
        this.log(Level.WARNING, msgSupplier);
    }

    @Override
    public void warn(Object msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    @Override
    public void error(Object msg) {
        this.log(Level.SEVERE, msg);
    }

    @Override
    public void error(Supplier<String> msgSupplier) {
        this.log(Level.SEVERE, msgSupplier);
    }

    @Override
    public void error(Object msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    @Override
    public void addContext(Map<String, String> addedContext) {
        this.logContext.addContext(addedContext);
    }

    @Override
    public void addContext(String key, String value2) {
        this.logContext.addContext(key, value2);
    }
}

