/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.queue;

import gg.essential.lib.jitsi.utils.logging.Logger;
import gg.essential.lib.jitsi.utils.queue.AsyncQueueHandler;
import gg.essential.lib.jitsi.utils.queue.ErrorHandler;
import gg.essential.lib.jitsi.utils.queue.QueueStatisticsObserver;
import gg.essential.lib.jsonsimple.JSONObject;
import java.time.Clock;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;

public class PacketQueue<T> {
    private static final Logger logger = Logger.getLogger(PacketQueue.class);
    private static boolean enableStatisticsDefault = false;
    @NotNull
    private final BlockingQueue<T> queue;
    protected final Observer<T> observer;
    @NotNull
    private final AsyncQueueHandler<T> asyncQueueHandler;
    @NotNull
    private final String id;
    private volatile boolean closed = false;
    private final int capacity;
    @NotNull
    private ErrorHandler errorHandler = new ErrorHandler(){};

    public static void setEnableStatisticsDefault(boolean enable2) {
        enableStatisticsDefault = enable2;
    }

    public static boolean getEnableStatisticsDefault() {
        return enableStatisticsDefault;
    }

    protected Observer<T> createObserver(Clock clock) {
        return new QueueStatisticsObserver(this, clock);
    }

    public PacketQueue(int capacity, Boolean enableStatistics, @NotNull String id2, @NotNull PacketHandler<T> packetHandler, ExecutorService executor, Clock clock) {
        this.id = id2;
        this.capacity = capacity;
        this.queue = new LinkedBlockingQueue<T>(capacity);
        this.asyncQueueHandler = new AsyncQueueHandler<T>(this.queue, new HandlerAdapter(packetHandler), id2, executor, packetHandler.maxSequentiallyProcessedPackets());
        if (enableStatistics == null) {
            enableStatistics = enableStatisticsDefault;
        }
        this.observer = enableStatistics != false ? this.createObserver(clock) : null;
        logger.debug("Initialized a PacketQueue instance with ID " + id2);
    }

    public PacketQueue(int capacity, Boolean enableStatistics, @NotNull String id2, @NotNull PacketHandler<T> packetHandler, ExecutorService executor) {
        this(capacity, enableStatistics, id2, packetHandler, executor, Clock.systemUTC());
    }

    public void add(T pkt) {
        if (this.closed) {
            return;
        }
        while (!this.queue.offer(pkt)) {
            Object p = this.queue.poll();
            if (p == null) continue;
            if (this.observer != null) {
                this.observer.dropped(p);
            }
            this.errorHandler.packetDropped();
            this.releasePacket(p);
        }
        if (this.observer != null) {
            this.observer.added(pkt);
        }
        this.asyncQueueHandler.handleQueueItemsUntilEmpty();
    }

    public void close() {
        if (!this.closed) {
            Object item;
            this.closed = true;
            this.asyncQueueHandler.cancel();
            while ((item = this.queue.poll()) != null) {
                this.releasePacket(item);
            }
        }
    }

    protected void releasePacket(T pkt) {
    }

    public int size() {
        return this.queue.size();
    }

    public int capacity() {
        return this.capacity;
    }

    public String id() {
        return this.id;
    }

    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put("id", this.id);
        debugState.put("capacity", this.capacity);
        debugState.put("closed", this.closed);
        debugState.put("statistics", this.observer == null ? null : this.observer.getStats());
        return debugState;
    }

    public void setErrorHandler(@NotNull ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private final class HandlerAdapter
    implements AsyncQueueHandler.Handler<T> {
        private final PacketHandler<T> handler;

        HandlerAdapter(PacketHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void handleItem(T item) {
            if (PacketQueue.this.observer != null) {
                PacketQueue.this.observer.removed(item);
            }
            try {
                this.handler.handlePacket(item);
            }
            catch (Throwable t) {
                PacketQueue.this.errorHandler.packetHandlingFailed(t);
            }
        }
    }

    public static interface Observer<T> {
        public void added(T var1);

        public void removed(T var1);

        public void dropped(T var1);

        public Map<?, ?> getStats();
    }

    public static interface PacketHandler<T> {
        public boolean handlePacket(T var1);

        default public long maxSequentiallyProcessedPackets() {
            return -1L;
        }
    }
}

