/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgg/essential/lib/jitsi/utils/stats/Buckets;", "", "thresholdsNoMax", "", "([J)V", "snapshot", "Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "getSnapshot", "()Lorg/jitsi/utils/stats/Buckets$Snapshot;", "thresholdCounts", "", "Ljava/util/concurrent/atomic/LongAdder;", "[Ljava/util/concurrent/atomic/LongAdder;", "thresholds", "addValue", "", "value", "", "findBucket", "Snapshot", "jitsi-utils"})
public final class Buckets {
    @NotNull
    private final long[] thresholds;
    @NotNull
    private final LongAdder[] thresholdCounts;

    public Buckets(@NotNull long[] thresholdsNoMax) {
        Intrinsics.checkNotNullParameter((Object)thresholdsNoMax, (String)"thresholdsNoMax");
        LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(2);
        longSpreadBuilder.addSpread((Object)thresholdsNoMax);
        longSpreadBuilder.add(Long.MAX_VALUE);
        this.thresholds = longSpreadBuilder.toArray();
        int n = 0;
        int n2 = this.thresholds.length + 1;
        LongAdder[] longAdderArray = new LongAdder[n2];
        Buckets buckets = this;
        while (n < n2) {
            int n3 = n++;
            longAdderArray[n3] = new LongAdder();
        }
        buckets.thresholdCounts = longAdderArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Snapshot getSnapshot() {
        void $this$mapTo$iv$iv;
        int n = 0;
        int n2 = this.thresholds.length;
        Pair[] pairArray = new Pair[n2];
        while (n < n2) {
            int n3 = n++;
            pairArray[n3] = new Pair((Object)this.thresholds[n3], (Object)this.thresholdCounts[n3].sum());
        }
        Pair[] bucketCounts = pairArray;
        long p99 = 0L;
        p99 = Long.MAX_VALUE;
        long p999 = 0L;
        p999 = Long.MAX_VALUE;
        long sum = 0L;
        Pair[] $this$map$iv = bucketCounts;
        boolean $i$f$map = false;
        Pair[] pairArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var12_16 = $this$mapTo$iv$iv;
        int n4 = ((void)var12_16).length;
        for (int j = 0; j < n4; ++j) {
            void it;
            void item$iv$iv;
            void var16_21 = item$iv$iv = var12_16[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = ((Number)it.getSecond()).longValue();
            collection.add(l);
        }
        long totalCount = CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
        Pair[] $this$forEach$iv = bucketCounts;
        boolean $i$f$forEach = false;
        pairArray2 = $this$forEach$iv;
        int n5 = pairArray2.length;
        for (int j = 0; j < n5; ++j) {
            Pair element$iv;
            Pair it = element$iv = pairArray2[j];
            boolean bl = false;
            sum += ((Number)it.getSecond()).longValue();
            if (((Number)it.getFirst()).longValue() < p99 && (double)sum > 0.99 * (double)totalCount) {
                p99 = ((Number)it.getFirst()).longValue();
            }
            if (((Number)it.getFirst()).longValue() >= p999 || !((double)sum > 0.999 * (double)totalCount)) continue;
            p999 = ((Number)it.getFirst()).longValue();
        }
        if (totalCount < 100L || p99 == Long.MAX_VALUE) {
            p99 = -1L;
        }
        if (totalCount < 1000L || p999 == Long.MAX_VALUE) {
            p999 = -1L;
        }
        return new Snapshot(bucketCounts, p99, p999);
    }

    private final LongAdder findBucket(long value2) {
        int n = 0;
        int n2 = this.thresholds.length + -1;
        if (n <= n2) {
            do {
                int i2;
                if (value2 > this.thresholds[i2 = n++]) continue;
                return this.thresholdCounts[i2];
            } while (n <= n2);
        }
        return (LongAdder)ArraysKt.last((Object[])this.thresholdCounts);
    }

    public final void addValue(long value2) {
        this.findBucket(value2).increment();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J>\u0010\u0012\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R%\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001b"}, d2={"Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "", "buckets", "", "Lkotlin/Pair;", "", "p99bound", "p999bound", "([Lkotlin/Pair;JJ)V", "getBuckets", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "getP999bound", "()J", "getP99bound", "component1", "component2", "component3", "copy", "([Lkotlin/Pair;JJ)Lorg/jitsi/utils/stats/Buckets$Snapshot;", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-utils"})
    public static final class Snapshot {
        @NotNull
        private final Pair<Long, Long>[] buckets;
        private final long p99bound;
        private final long p999bound;

        public Snapshot(@NotNull Pair<Long, Long>[] buckets, long p99bound, long p999bound) {
            Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
            this.buckets = buckets;
            this.p99bound = p99bound;
            this.p999bound = p999bound;
        }

        @NotNull
        public final Pair<Long, Long>[] getBuckets() {
            return this.buckets;
        }

        public final long getP99bound() {
            return this.p99bound;
        }

        public final long getP999bound() {
            return this.p999bound;
        }

        public boolean equals(@Nullable Object other) {
            Object[] objectArray;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (objectArray = other) == null ? null : objectArray.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jitsi.utils.stats.Buckets.Snapshot");
            }
            Snapshot cfr_ignored_0 = (Snapshot)other;
            objectArray = this.buckets;
            Object[] objectArray2 = ((Snapshot)other).buckets;
            boolean bl = false;
            return Arrays.equals(objectArray, objectArray2);
        }

        public int hashCode() {
            Object[] objectArray = this.buckets;
            boolean bl = false;
            return Arrays.hashCode(objectArray);
        }

        @NotNull
        public final Pair<Long, Long>[] component1() {
            return this.buckets;
        }

        public final long component2() {
            return this.p99bound;
        }

        public final long component3() {
            return this.p999bound;
        }

        @NotNull
        public final Snapshot copy(@NotNull Pair<Long, Long>[] buckets, long p99bound, long p999bound) {
            Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
            return new Snapshot(buckets, p99bound, p999bound);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, Pair[] pairArray, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                pairArray = snapshot.buckets;
            }
            if ((n & 2) != 0) {
                l = snapshot.p99bound;
            }
            if ((n & 4) != 0) {
                l2 = snapshot.p999bound;
            }
            return snapshot.copy(pairArray, l, l2);
        }

        @NotNull
        public String toString() {
            return "Snapshot(buckets=" + Arrays.toString(this.buckets) + ", p99bound=" + this.p99bound + ", p999bound=" + this.p999bound + ')';
        }
    }
}

