/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jsonsimple;

import gg.essential.lib.jsonsimple.JSONArray;
import gg.essential.lib.jsonsimple.JSONAware;
import gg.essential.lib.jsonsimple.JSONObject;
import gg.essential.lib.jsonsimple.JSONStreamAware;
import gg.essential.lib.jsonsimple.parser.JSONParser;
import gg.essential.lib.jsonsimple.parser.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class JSONValue {
    public static Object parse(Reader in) {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s) {
        StringReader in = new StringReader(s);
        return JSONValue.parse(in);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in);
    }

    public static Object parseWithException(String s) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s);
    }

    public static void writeJSONString(Object value2, Writer out) throws IOException {
        if (value2 == null) {
            out.write("null");
            return;
        }
        if (value2 instanceof String) {
            out.write(34);
            out.write(JSONValue.escape((String)value2));
            out.write(34);
            return;
        }
        if (value2 instanceof Double) {
            if (((Double)value2).isInfinite() || ((Double)value2).isNaN()) {
                out.write("null");
            } else {
                out.write(value2.toString());
            }
            return;
        }
        if (value2 instanceof Float) {
            if (((Float)value2).isInfinite() || ((Float)value2).isNaN()) {
                out.write("null");
            } else {
                out.write(value2.toString());
            }
            return;
        }
        if (value2 instanceof Number) {
            out.write(value2.toString());
            return;
        }
        if (value2 instanceof Boolean) {
            out.write(value2.toString());
            return;
        }
        if (value2 instanceof JSONStreamAware) {
            ((JSONStreamAware)value2).writeJSONString(out);
            return;
        }
        if (value2 instanceof JSONAware) {
            out.write(((JSONAware)value2).toJSONString());
            return;
        }
        if (value2 instanceof Map) {
            JSONObject.writeJSONString((Map)value2, out);
            return;
        }
        if (value2 instanceof List) {
            JSONArray.writeJSONString((List)value2, out);
            return;
        }
        out.write(value2.toString());
    }

    public static String toJSONString(Object value2) {
        if (value2 == null) {
            return "null";
        }
        if (value2 instanceof String) {
            return "\"" + JSONValue.escape((String)value2) + "\"";
        }
        if (value2 instanceof Double) {
            if (((Double)value2).isInfinite() || ((Double)value2).isNaN()) {
                return "null";
            }
            return value2.toString();
        }
        if (value2 instanceof Float) {
            if (((Float)value2).isInfinite() || ((Float)value2).isNaN()) {
                return "null";
            }
            return value2.toString();
        }
        if (value2 instanceof Number) {
            return value2.toString();
        }
        if (value2 instanceof Boolean) {
            return value2.toString();
        }
        if (value2 instanceof JSONAware) {
            return ((JSONAware)value2).toJSONString();
        }
        if (value2 instanceof Map) {
            return JSONObject.toJSONString((Map)value2);
        }
        if (value2 instanceof List) {
            return JSONArray.toJSONString((List)value2);
        }
        return value2.toString();
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        JSONValue.escape(s, sb);
        return sb.toString();
    }

    static void escape(String s, StringBuffer sb) {
        block10: for (int i2 = 0; i2 < s.length(); ++i2) {
            char ch = s.charAt(i2);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }
}

