/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.sugar.impl;

import gg.essential.lib.mixinextras.injector.StackExtension;
import gg.essential.lib.mixinextras.sugar.impl.SugarApplicationException;
import gg.essential.lib.mixinextras.sugar.impl.SugarApplicator;
import gg.essential.lib.mixinextras.sugar.impl.SugarParameter;
import gg.essential.lib.mixinextras.sugar.impl.SugarPostProcessingExtension;
import gg.essential.lib.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import gg.essential.lib.mixinextras.sugar.impl.ref.LocalRefUtils;
import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import java.util.HashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

class LocalSugarApplicator
extends SugarApplicator {
    private final boolean isArgsOnly;
    private final Type targetLocalType;
    private final boolean isMutable;

    LocalSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.targetLocalType = LocalRefUtils.getTargetType(this.paramType, this.paramGeneric);
        this.isMutable = this.targetLocalType != this.paramType;
        this.isArgsOnly = (Boolean)Annotations.getValue((AnnotationNode)this.sugar, (String)"argsOnly", (Object)false);
    }

    @Override
    void validate(Target target2, InjectionNodes.InjectionNode node2) {
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        LocalVariableDiscriminator.Context context = this.getOrCreateLocalContext(target2, node2);
        if (discriminator.printLVT()) {
            this.printLocals(target2, node2.getCurrentTarget(), context, discriminator);
            this.info.addCallbackInvocation(this.info.getMethod());
            throw new SugarApplicationException("Application aborted because locals are being printed instead.");
        }
        try {
            if (discriminator.findLocal(context) < 0) {
                throw new SugarApplicationException("Unable to find matching local!");
            }
        }
        catch (InvalidImplicitDiscriminatorException e) {
            throw new SugarApplicationException("Invalid implicit variable discriminator: ", e);
        }
    }

    @Override
    void prepare(Target target2, InjectionNodes.InjectionNode node2) {
        this.getOrCreateLocalContext(target2, node2);
    }

    @Override
    void inject(Target target2, InjectionNodes.InjectionNode node2, StackExtension stack) {
        LocalVariableDiscriminator.Context context;
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        int index2 = discriminator.findLocal(context = (LocalVariableDiscriminator.Context)node2.getDecoration(this.getLocalContextKey()));
        if (index2 < 0) {
            throw new SugarApplicationException("Failed to match a local, this should have been caught during validation.");
        }
        if (this.isMutable) {
            this.initAndLoadLocalRef(target2, node2, index2, stack);
        } else {
            stack.extra(this.targetLocalType.getSize());
            target2.insns.insertBefore(node2.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), index2));
        }
    }

    private void initAndLoadLocalRef(Target target2, InjectionNodes.InjectionNode node2, int index2, StackExtension stack) {
        String refName = LocalRefClassGenerator.getForType(this.targetLocalType);
        int refIndex = this.getOrCreateRef(target2, node2, index2, refName, stack);
        stack.extra(1);
        target2.insns.insertBefore(node2.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, refIndex));
    }

    private int getOrCreateRef(Target target2, InjectionNodes.InjectionNode node2, int index2, String refImpl, StackExtension stack) {
        HashMap<Integer, Integer> refIndices = (HashMap<Integer, Integer>)node2.getDecoration("mixinextras_localRefMap");
        if (refIndices == null) {
            refIndices = new HashMap<Integer, Integer>();
            node2.decorate("mixinextras_localRefMap", refIndices);
        }
        if (refIndices.containsKey(index2)) {
            return (Integer)refIndices.get(index2);
        }
        int refIndex = target2.allocateLocal();
        target2.addLocalVariable(refIndex, "ref" + refIndex, 'L' + refImpl + ';');
        InsnList construction = new InsnList();
        LocalRefUtils.generateNew(construction, this.targetLocalType);
        construction.add((AbstractInsnNode)new VarInsnNode(58, refIndex));
        target2.insertBefore(node2, construction);
        SugarPostProcessingExtension.enqueuePostProcessing(this, () -> {
            InsnList initialization = new InsnList();
            initialization.add((AbstractInsnNode)new VarInsnNode(25, refIndex));
            initialization.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(21), index2));
            LocalRefUtils.generateInitialization(initialization, this.targetLocalType);
            target2.insertBefore(node2, initialization);
            stack.extra(this.targetLocalType.getSize() + 1);
            InsnList after = new InsnList();
            after.add((AbstractInsnNode)new VarInsnNode(25, refIndex));
            LocalRefUtils.generateDisposal(after, this.targetLocalType);
            after.add((AbstractInsnNode)new VarInsnNode(this.targetLocalType.getOpcode(54), index2));
            target2.insns.insert(node2.getCurrentTarget(), after);
        });
        refIndices.put(index2, refIndex);
        return refIndex;
    }

    private LocalVariableDiscriminator.Context getOrCreateLocalContext(Target target2, InjectionNodes.InjectionNode node2) {
        String decorationKey = this.getLocalContextKey();
        if (node2.hasDecoration(decorationKey)) {
            return (LocalVariableDiscriminator.Context)node2.getDecoration(decorationKey);
        }
        LocalVariableDiscriminator.Context context = CompatibilityHelper.makeLvtContext(this.info, this.targetLocalType, this.isArgsOnly, target2, node2.getCurrentTarget());
        node2.decorate(decorationKey, (Object)context);
        return context;
    }

    private String getLocalContextKey() {
        return String.format("mixinextras_persistent_localSugarContext(%s,%s)", this.targetLocalType, this.isArgsOnly ? "argsOnly" : "fullFrame");
    }

    private void printLocals(Target target2, AbstractInsnNode node2, LocalVariableDiscriminator.Context context, LocalVariableDiscriminator discriminator) {
        int baseArgIndex = target2.isStatic ? 0 : 1;
        new PrettyPrinter().kvWidth(20).kv("Target Class", (Object)target2.classNode.name.replace('/', '.')).kv("Target Method", (Object)target2.method.name).kv("Capture Type", (Object)SignaturePrinter.getTypeName((Type)this.targetLocalType, (boolean)false)).kv("Instruction", "[%d] %s %s", new Object[]{target2.insns.indexOf(node2), node2.getClass().getSimpleName(), Bytecode.getOpcodeName((int)node2.getOpcode())}).hr().kv("Match mode", (Object)(this.isImplicit(discriminator, baseArgIndex) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)")).kv("Match ordinal", discriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(discriminator.getOrdinal())).kv("Match index", discriminator.getIndex() < baseArgIndex ? "any" : Integer.valueOf(discriminator.getIndex())).kv("Match name(s)", discriminator.hasNames() ? discriminator.getNames() : "any").kv("Args only", (Object)this.isArgsOnly).hr().add((PrettyPrinter.IPrettyPrintable)context).print(System.err);
    }

    private boolean isImplicit(LocalVariableDiscriminator discriminator, int baseArgIndex) {
        return discriminator.getOrdinal() < 0 && discriminator.getIndex() < baseArgIndex && discriminator.getNames().isEmpty();
    }
}

