/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.slf4j.helpers;

import gg.essential.lib.slf4j.ILoggerFactory;
import gg.essential.lib.slf4j.Logger;
import gg.essential.lib.slf4j.event.SubstituteLoggingEvent;
import gg.essential.lib.slf4j.helpers.SubstituteLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class SubstituteLoggerFactory
implements ILoggerFactory {
    volatile boolean postInitialization = false;
    final Map<String, SubstituteLogger> loggers = new ConcurrentHashMap<String, SubstituteLogger>();
    final LinkedBlockingQueue<SubstituteLoggingEvent> eventQueue = new LinkedBlockingQueue();

    @Override
    public synchronized Logger getLogger(String name2) {
        SubstituteLogger logger2 = this.loggers.get(name2);
        if (logger2 == null) {
            logger2 = new SubstituteLogger(name2, this.eventQueue, this.postInitialization);
            this.loggers.put(name2, logger2);
        }
        return logger2;
    }

    public List<String> getLoggerNames() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    public List<SubstituteLogger> getLoggers() {
        return new ArrayList<SubstituteLogger>(this.loggers.values());
    }

    public LinkedBlockingQueue<SubstituteLoggingEvent> getEventQueue() {
        return this.eventQueue;
    }

    public void postInitialization() {
        this.postInitialization = true;
    }

    public void clear() {
        this.loggers.clear();
        this.eventQueue.clear();
    }
}

