/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.typesafeconfig.impl;

import gg.essential.lib.typesafeconfig.ConfigOrigin;
import gg.essential.lib.typesafeconfig.ConfigValueType;
import gg.essential.lib.typesafeconfig.impl.ConfigNumber;
import gg.essential.lib.typesafeconfig.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class ConfigLong
extends ConfigNumber
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long value;

    ConfigLong(ConfigOrigin origin, long value2, String originalText) {
        super(origin, originalText);
        this.value = value2;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.NUMBER;
    }

    @Override
    public Long unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        String s = super.transformToString();
        if (s == null) {
            return Long.toString(this.value);
        }
        return s;
    }

    @Override
    protected long longValue() {
        return this.value;
    }

    @Override
    protected double doubleValue() {
        return this.value;
    }

    @Override
    protected ConfigLong newCopy(ConfigOrigin origin) {
        return new ConfigLong(origin, this.value, this.originalText);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

