/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.typesafeconfig.impl;

import gg.essential.lib.typesafeconfig.ConfigException;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigNode;
import gg.essential.lib.typesafeconfig.impl.Path;
import gg.essential.lib.typesafeconfig.impl.Token;
import gg.essential.lib.typesafeconfig.impl.Tokens;
import java.util.ArrayList;
import java.util.Collection;

final class ConfigNodePath
extends AbstractConfigNode {
    private final Path path;
    final ArrayList<Token> tokens;

    ConfigNodePath(Path path, Collection<Token> tokens) {
        this.path = path;
        this.tokens = new ArrayList<Token>(tokens);
    }

    @Override
    protected Collection<Token> tokens() {
        return this.tokens;
    }

    protected Path value() {
        return this.path;
    }

    protected ConfigNodePath subPath(int toRemove) {
        int periodCount = 0;
        ArrayList<Token> tokensCopy = new ArrayList<Token>(this.tokens);
        for (int i2 = 0; i2 < tokensCopy.size(); ++i2) {
            if (Tokens.isUnquotedText(tokensCopy.get(i2)) && tokensCopy.get(i2).tokenText().equals(".")) {
                ++periodCount;
            }
            if (periodCount != toRemove) continue;
            return new ConfigNodePath(this.path.subPath(toRemove), tokensCopy.subList(i2 + 1, tokensCopy.size()));
        }
        throw new ConfigException.BugOrBroken("Tried to remove too many elements from a Path node");
    }

    protected ConfigNodePath first() {
        ArrayList<Token> tokensCopy = new ArrayList<Token>(this.tokens);
        for (int i2 = 0; i2 < tokensCopy.size(); ++i2) {
            if (!Tokens.isUnquotedText(tokensCopy.get(i2)) || !tokensCopy.get(i2).tokenText().equals(".")) continue;
            return new ConfigNodePath(this.path.subPath(0, 1), tokensCopy.subList(0, i2));
        }
        return this;
    }
}

