/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.typesafeconfig.impl;

import gg.essential.lib.typesafeconfig.ConfigException;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigNodeValue;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigValue;
import gg.essential.lib.typesafeconfig.impl.ConfigReference;
import gg.essential.lib.typesafeconfig.impl.ConfigString;
import gg.essential.lib.typesafeconfig.impl.Path;
import gg.essential.lib.typesafeconfig.impl.PathParser;
import gg.essential.lib.typesafeconfig.impl.SubstitutionExpression;
import gg.essential.lib.typesafeconfig.impl.Token;
import gg.essential.lib.typesafeconfig.impl.Tokens;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value2) {
        this.token = value2;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

