/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.typesafeconfig.impl;

import gg.essential.lib.typesafeconfig.ConfigException;
import gg.essential.lib.typesafeconfig.ConfigFactory;
import gg.essential.lib.typesafeconfig.ConfigIncludeContext;
import gg.essential.lib.typesafeconfig.ConfigIncluder;
import gg.essential.lib.typesafeconfig.ConfigIncluderClasspath;
import gg.essential.lib.typesafeconfig.ConfigIncluderFile;
import gg.essential.lib.typesafeconfig.ConfigIncluderURL;
import gg.essential.lib.typesafeconfig.ConfigObject;
import gg.essential.lib.typesafeconfig.ConfigParseOptions;
import gg.essential.lib.typesafeconfig.ConfigParseable;
import gg.essential.lib.typesafeconfig.ConfigSyntax;
import gg.essential.lib.typesafeconfig.impl.ConfigImpl;
import gg.essential.lib.typesafeconfig.impl.FullIncluder;
import gg.essential.lib.typesafeconfig.impl.Parseable;
import gg.essential.lib.typesafeconfig.impl.SimpleConfigObject;
import gg.essential.lib.typesafeconfig.impl.SimpleConfigOrigin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

class SimpleIncluder
implements FullIncluder {
    private ConfigIncluder fallback;

    SimpleIncluder(ConfigIncluder fallback) {
        this.fallback = fallback;
    }

    static ConfigParseOptions clearForInclude(ConfigParseOptions options2) {
        return options2.setSyntax(null).setOriginDescription(null).setAllowMissing(true);
    }

    @Override
    public ConfigObject include(ConfigIncludeContext context, String name2) {
        ConfigObject obj = SimpleIncluder.includeWithoutFallback(context, name2);
        if (this.fallback != null) {
            return obj.withFallback(this.fallback.include(context, name2));
        }
        return obj;
    }

    static ConfigObject includeWithoutFallback(ConfigIncludeContext context, String name2) {
        URL url;
        try {
            url = new URL(name2);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url != null) {
            return SimpleIncluder.includeURLWithoutFallback(context, url);
        }
        RelativeNameSource source = new RelativeNameSource(context);
        return SimpleIncluder.fromBasename(source, name2, context.parseOptions());
    }

    @Override
    public ConfigObject includeURL(ConfigIncludeContext context, URL url) {
        ConfigObject obj = SimpleIncluder.includeURLWithoutFallback(context, url);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderURL) {
            return obj.withFallback(((ConfigIncluderURL)((Object)this.fallback)).includeURL(context, url));
        }
        return obj;
    }

    static ConfigObject includeURLWithoutFallback(ConfigIncludeContext context, URL url) {
        return ConfigFactory.parseURL(url, context.parseOptions()).root();
    }

    @Override
    public ConfigObject includeFile(ConfigIncludeContext context, File file) {
        ConfigObject obj = SimpleIncluder.includeFileWithoutFallback(context, file);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderFile) {
            return obj.withFallback(((ConfigIncluderFile)((Object)this.fallback)).includeFile(context, file));
        }
        return obj;
    }

    static ConfigObject includeFileWithoutFallback(ConfigIncludeContext context, File file) {
        return ConfigFactory.parseFileAnySyntax(file, context.parseOptions()).root();
    }

    @Override
    public ConfigObject includeResources(ConfigIncludeContext context, String resource) {
        ConfigObject obj = SimpleIncluder.includeResourceWithoutFallback(context, resource);
        if (this.fallback != null && this.fallback instanceof ConfigIncluderClasspath) {
            return obj.withFallback(((ConfigIncluderClasspath)((Object)this.fallback)).includeResources(context, resource));
        }
        return obj;
    }

    static ConfigObject includeResourceWithoutFallback(ConfigIncludeContext context, String resource) {
        return ConfigFactory.parseResourcesAnySyntax(resource, context.parseOptions()).root();
    }

    @Override
    public ConfigIncluder withFallback(ConfigIncluder fallback) {
        if (this == fallback) {
            throw new ConfigException.BugOrBroken("trying to create includer cycle");
        }
        if (this.fallback == fallback) {
            return this;
        }
        if (this.fallback != null) {
            return new SimpleIncluder(this.fallback.withFallback(fallback));
        }
        return new SimpleIncluder(fallback);
    }

    static ConfigObject fromBasename(NameSource source, String name2, ConfigParseOptions options2) {
        ConfigObject obj;
        if (name2.endsWith(".conf") || name2.endsWith(".json") || name2.endsWith(".properties")) {
            ConfigParseable p = source.nameToParseable(name2, options2);
            obj = p.parse(p.options().setAllowMissing(options2.getAllowMissing()));
        } else {
            ConfigObject parsed;
            ConfigParseable confHandle = source.nameToParseable(name2 + ".conf", options2);
            ConfigParseable jsonHandle = source.nameToParseable(name2 + ".json", options2);
            ConfigParseable propsHandle = source.nameToParseable(name2 + ".properties", options2);
            boolean gotSomething = false;
            ArrayList<ConfigException.IO> fails = new ArrayList<ConfigException.IO>();
            ConfigSyntax syntax = options2.getSyntax();
            obj = SimpleConfigObject.empty(SimpleConfigOrigin.newSimple(name2));
            if (syntax == null || syntax == ConfigSyntax.CONF) {
                try {
                    obj = confHandle.parse(confHandle.options().setAllowMissing(false).setSyntax(ConfigSyntax.CONF));
                    gotSomething = true;
                }
                catch (ConfigException.IO e) {
                    fails.add(e);
                }
            }
            if (syntax == null || syntax == ConfigSyntax.JSON) {
                try {
                    parsed = jsonHandle.parse(jsonHandle.options().setAllowMissing(false).setSyntax(ConfigSyntax.JSON));
                    obj = obj.withFallback(parsed);
                    gotSomething = true;
                }
                catch (ConfigException.IO e) {
                    fails.add(e);
                }
            }
            if (syntax == null || syntax == ConfigSyntax.PROPERTIES) {
                try {
                    parsed = propsHandle.parse(propsHandle.options().setAllowMissing(false).setSyntax(ConfigSyntax.PROPERTIES));
                    obj = obj.withFallback(parsed);
                    gotSomething = true;
                }
                catch (ConfigException.IO e) {
                    fails.add(e);
                }
            }
            if (!options2.getAllowMissing() && !gotSomething) {
                if (ConfigImpl.traceLoadsEnabled()) {
                    ConfigImpl.trace("Did not find '" + name2 + "' with any extension (.conf, .json, .properties); exceptions should have been logged above.");
                }
                if (fails.isEmpty()) {
                    throw new ConfigException.BugOrBroken("should not be reached: nothing found but no exceptions thrown");
                }
                StringBuilder sb = new StringBuilder();
                for (Throwable throwable : fails) {
                    sb.append(throwable.getMessage());
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
                throw new ConfigException.IO(SimpleConfigOrigin.newSimple(name2), sb.toString(), (Throwable)fails.get(0));
            }
            if (!gotSomething && ConfigImpl.traceLoadsEnabled()) {
                ConfigImpl.trace("Did not find '" + name2 + "' with any extension (.conf, .json, .properties); but '" + name2 + "' is allowed to be missing. Exceptions from load attempts should have been logged above.");
            }
        }
        return obj;
    }

    static FullIncluder makeFull(ConfigIncluder includer) {
        if (includer instanceof FullIncluder) {
            return (FullIncluder)includer;
        }
        return new Proxy(includer);
    }

    private static class Proxy
    implements FullIncluder {
        final ConfigIncluder delegate;

        Proxy(ConfigIncluder delegate2) {
            this.delegate = delegate2;
        }

        @Override
        public ConfigIncluder withFallback(ConfigIncluder fallback) {
            return this;
        }

        @Override
        public ConfigObject include(ConfigIncludeContext context, String what) {
            return this.delegate.include(context, what);
        }

        @Override
        public ConfigObject includeResources(ConfigIncludeContext context, String what) {
            if (this.delegate instanceof ConfigIncluderClasspath) {
                return ((ConfigIncluderClasspath)((Object)this.delegate)).includeResources(context, what);
            }
            return SimpleIncluder.includeResourceWithoutFallback(context, what);
        }

        @Override
        public ConfigObject includeURL(ConfigIncludeContext context, URL what) {
            if (this.delegate instanceof ConfigIncluderURL) {
                return ((ConfigIncluderURL)((Object)this.delegate)).includeURL(context, what);
            }
            return SimpleIncluder.includeURLWithoutFallback(context, what);
        }

        @Override
        public ConfigObject includeFile(ConfigIncludeContext context, File what) {
            if (this.delegate instanceof ConfigIncluderFile) {
                return ((ConfigIncluderFile)((Object)this.delegate)).includeFile(context, what);
            }
            return SimpleIncluder.includeFileWithoutFallback(context, what);
        }
    }

    private static class RelativeNameSource
    implements NameSource {
        private final ConfigIncludeContext context;

        RelativeNameSource(ConfigIncludeContext context) {
            this.context = context;
        }

        @Override
        public ConfigParseable nameToParseable(String name2, ConfigParseOptions options2) {
            ConfigParseable p = this.context.relativeTo(name2);
            if (p == null) {
                return Parseable.newNotFound(name2, "include was not found: '" + name2 + "'", options2);
            }
            return p;
        }
    }

    static interface NameSource {
        public ConfigParseable nameToParseable(String var1, ConfigParseOptions var2);
    }
}

