/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gg.essential.asm.EssentialTransformer;
import gg.essential.data.VersionInfo;
import gg.essential.lib.mixinextras.MixinExtrasBootstrap;
import gg.essential.mixins.injection.points.AfterInvokeInInit;
import gg.essential.mixins.injection.points.BeforeConstantInInit;
import gg.essential.mixins.injection.points.BeforeFieldAccessInInit;
import gg.essential.mixins.injection.points.BeforeInvokeInInit;
import gg.essential.util.MixinUtils;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class Plugin
implements IMixinConfigPlugin {
    private static final Logger logger = LogManager.getLogger((String)"Essential Logger - Plugin");
    private final boolean inOurDevEnv = Boolean.getBoolean("essential.feature.dev_only");
    private final boolean hasOptifine = Plugin.hasClass("optifine.OptiFineForgeTweaker") || Plugin.hasClass("me.modmuss50.optifabric.mod.OptifineInjector");
    private final EssentialTransformer[] transformers = new EssentialTransformer[0];
    private final Multimap<String, EssentialTransformer> transformerMap = ArrayListMultimap.create();

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
        MixinUtils.registerInjectionPoint(AfterInvokeInInit.class);
        MixinUtils.registerInjectionPoint(BeforeConstantInInit.class);
        MixinUtils.registerInjectionPoint(BeforeFieldAccessInInit.class);
        MixinUtils.registerInjectionPoint(BeforeInvokeInInit.class);
        for (EssentialTransformer transformer : this.transformers) {
            for (String target2 : transformer.getTargets()) {
                this.transformerMap.put((Object)target2, (Object)transformer);
            }
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (targetClassName.equals("gg.essential.mixins.DummyTarget")) {
            return false;
        }
        if (mixinClassName.endsWith("MixinFramebuffer")) {
            return false;
        }
        if (mixinClassName.endsWith("MixinKeyBinding")) {
            return false;
        }
        if (mixinClassName.endsWith("Mixin_UnbindConflictingKeybinds") && Plugin.hasClass("com.therandomlabs.randompatches.RandomPatches")) {
            return false;
        }
        if (!this.hasOptifine && mixinClassName.endsWith("_Optifine")) {
            return false;
        }
        if (this.hasOptifine && mixinClassName.endsWith("_Zoom")) {
            return false;
        }
        if (mixinClassName.contains("compatibility") && !Plugin.hasClass(targetClassName)) {
            return false;
        }
        if (mixinClassName.endsWith("Mixin_FancyMainMenu_GuiDrawScreenEvent_Pre") && Plugin.hasClass("de.keksuccino.fancymenu.events.ScreenBackgroundRenderedEvent")) {
            return false;
        }
        if (mixinClassName.endsWith("Mixin_FancyMainMenu_2_14_10_GuiDrawScreenEvent_Pre") && !Plugin.hasClass("de.keksuccino.fancymenu.events.ScreenBackgroundRenderedEvent")) {
            return false;
        }
        return !mixinClassName.contains("Mixin_FixSelfieNameplateOrientation") || !Plugin.hasClass("club.sk1er.patcher.Patcher");
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        for (EssentialTransformer transformer : this.transformerMap.get((Object)targetClassName)) {
            transformer.transform(targetClass);
        }
    }

    private void createDummyIfMissing(ClassNode targetClass, String name2, String desc) {
        for (MethodNode method : targetClass.methods) {
            if (!name2.equals(method.name) || !desc.equals(method.desc)) continue;
            return;
        }
        MethodNode dummyMethod = new MethodNode(0, name2, desc, null, null);
        dummyMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        targetClass.methods.add(dummyMethod);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static boolean hasClass(String name2) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(name2);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        VersionInfo info = new VersionInfo();
        logger.info("Starting Essential v" + info.getEssentialVersion() + " (#" + info.getEssentialCommit() + ") [" + info.getEssentialBranch() + "]");
    }
}

