/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.entity;

import com.mojang.authlib.properties.Property;
import gg.essential.Essential;
import gg.essential.api.utils.JsonHolder;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.cosmetic.ClientCosmeticAnimationTriggerPacket;
import gg.essential.cosmetics.CosmeticsState;
import gg.essential.cosmetics.EssentialModelRenderer;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.cosmetics.events.AnimationTarget;
import gg.essential.cosmetics.skinmask.MaskedSkinProvider;
import gg.essential.cosmetics.source.CosmeticsSource;
import gg.essential.cosmetics.source.LiveCosmeticsSource;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.handlers.GameProfileManager;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.PlayerMolangQuery;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.util.PlayerPoseManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.cosmetics.ConversionsKt;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.util.UIdentifier;
import gg.essential.util.UIdentifierKt;
import gg.essential.util.UUIDUtil;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class MixinAbstractClientPlayer
implements AbstractClientPlayerExt {
    @Unique
    private final PlayerMolangQuery molangQuery = new PlayerMolangQuery((Player)((AbstractClientPlayer)this));
    @Unique
    private CosmeticsSource cosmeticsSource;
    @Unique
    private WearablesManager wearablesManager;
    @Unique
    private final MaskedSkinProvider maskedSkinProvider = new MaskedSkinProvider();
    @Unique
    private String essentialCosmeticsCape;
    @Unique
    private Pair<List<UIdentifier>, @Nullable List<UIdentifier>> essentialCosmeticsCapeResources;
    @Unique
    private Boolean serverSkinOverrideStatus = null;
    @Unique
    private final boolean[] armorRenderingSuppressed = new boolean[4];
    @Unique
    private final PlayerPoseManager poseManager = new PlayerPoseManager(this.molangQuery);
    @Unique
    private boolean poseModified;
    @Unique
    private float lastCosmeticsUpdateTime;

    @Shadow
    public abstract String m_108564_();

    @Override
    public CosmeticsSource getCosmeticsSource() {
        if (this.cosmeticsSource == null) {
            CosmeticsManager cosmeticsManager = Essential.getInstance().getConnectionManager().getCosmeticsManager();
            AbstractClientPlayer self = (AbstractClientPlayer)this;
            UUID uuid = self.m_20148_();
            Collection properties2 = self.m_36316_().getProperties().get((Object)"essential:real_uuid");
            for (Property property2 : properties2) {
                String value2 = property2.getValue();
                try {
                    uuid = UUIDUtil.formatWithDashes(value2);
                }
                catch (IllegalArgumentException e) {
                    Essential.logger.warn("Failed to parse fake_player uuid \"" + value2 + "\" for " + self.m_20148_(), (Throwable)e);
                }
            }
            this.cosmeticsSource = new LiveCosmeticsSource(cosmeticsManager, uuid);
        }
        return this.cosmeticsSource;
    }

    @Override
    public void setCosmeticsSource(CosmeticsSource cosmeticsSource) {
        this.cosmeticsSource = cosmeticsSource;
    }

    @Override
    @NotNull
    public WearablesManager getWearablesManager() {
        if (this.wearablesManager == null) {
            AbstractClientPlayer player2 = (AbstractClientPlayer)this;
            EnumSet<AnimationTarget> animationTargets = player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer ? EnumSet.of(AnimationTarget.SELF, AnimationTarget.OTHERS) : (player2 instanceof LocalPlayer ? EnumSet.of(AnimationTarget.SELF) : EnumSet.of(AnimationTarget.OTHERS));
            boolean sendsAnimationPackets = player2.m_20148_().equals(UUIDUtil.getClientUUID()) && !(player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer);
            this.wearablesManager = new WearablesManager(MinecraftRenderBackend.INSTANCE, this.molangQuery, animationTargets, (Function2<? super Cosmetic, ? super String, Unit>)((Function2)(cosmetic2, event) -> {
                if (sendsAnimationPackets) {
                    CosmeticSlot slot = cosmetic2.getType().getSlot();
                    Essential.getInstance().getConnectionManager().send(new ClientCosmeticAnimationTriggerPacket(ConversionsKt.toInfra(slot), (String)event));
                }
                return Unit.INSTANCE;
            }));
        }
        return this.wearablesManager;
    }

    @Override
    @NotNull
    public CosmeticsState getCosmeticsState() {
        return this.getWearablesManager().getState();
    }

    @Override
    public void setEssentialCosmeticsCape(@Nullable String cape, @Nullable @Nullable Pair<List<UIdentifier>, @Nullable List<UIdentifier>> textures) {
        this.essentialCosmeticsCape = cape;
        this.essentialCosmeticsCapeResources = textures;
    }

    @Override
    public ResourceLocation applyEssentialCosmeticsMask(ResourceLocation skin) {
        ResourceLocation maskedSkin;
        if (EssentialModelRenderer.cosmeticsShouldRender((AbstractClientPlayer)this) && (maskedSkin = this.maskedSkinProvider.provide(skin, this.getCosmeticsState().getSkinMask())) != null) {
            return maskedSkin;
        }
        return skin;
    }

    @Override
    public boolean isSkinOverrodeByServer() {
        if (this.serverSkinOverrideStatus == null) {
            String values = GameProfileManager.getSafeTexturesValue(((Player)this).m_36316_());
            JsonHolder root = new JsonHolder(new String(Base64.getDecoder().decode(values)));
            this.serverSkinOverrideStatus = !root.optString("profileId").isEmpty() && !((Player)this).m_36316_().getId().equals(UUIDUtil.formatWithDashes(root.optString("profileId")));
        }
        return this.serverSkinOverrideStatus;
    }

    @Inject(method={"getCloakTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideCapeIfSelectedInEssential(CallbackInfoReturnable<ResourceLocation> ci) {
        if (!EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return;
        }
        if (!EssentialModelRenderer.cosmeticsShouldRender((AbstractClientPlayer)this)) {
            return;
        }
        if (this.essentialCosmeticsCape != null) {
            Pair<List<UIdentifier>, @Nullable List<UIdentifier>> frames = this.essentialCosmeticsCapeResources;
            if (frames == null) {
                ci.setReturnValue(null);
                return;
            }
            ci.setReturnValue((Object)UIdentifierKt.toMC((UIdentifier)((List)frames.getFirst()).get(this.getCapeAnimationFrame(((List)frames.getFirst()).size()))));
        }
    }

    @Override
    @Nullable
    public UIdentifier getEmissiveCapeTexture() {
        if (!EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return null;
        }
        if (!EssentialModelRenderer.cosmeticsShouldRender((AbstractClientPlayer)this)) {
            return null;
        }
        if (this.essentialCosmeticsCape == null) {
            return null;
        }
        Pair<List<UIdentifier>, @Nullable List<UIdentifier>> frames = this.essentialCosmeticsCapeResources;
        if (frames == null) {
            return null;
        }
        List emissiveFrames = (List)frames.getSecond();
        if (emissiveFrames == null) {
            return null;
        }
        return (UIdentifier)emissiveFrames.get(this.getCapeAnimationFrame(emissiveFrames.size()));
    }

    @Unique
    private int getCapeAnimationFrame(int frameCount) {
        if (frameCount == 1) {
            return 0;
        }
        float lifetime = new PlayerMolangQuery((Player)((AbstractClientPlayer)this)).getLifeTime();
        int frame = (int)(lifetime * 7.0f);
        return frame % frameCount;
    }

    @Override
    public void assumeArmorRenderingSuppressed() {
        Arrays.fill(this.armorRenderingSuppressed, true);
    }

    @Override
    public void armorRenderingNotSuppressed(int slot) {
        this.armorRenderingSuppressed[slot] = false;
    }

    @Override
    public boolean[] wasArmorRenderingSuppressed() {
        return this.armorRenderingSuppressed;
    }

    @Override
    @NotNull
    public PlayerPoseManager getPoseManager() {
        return this.poseManager;
    }

    @Override
    public boolean isPoseModified() {
        return this.poseModified;
    }

    @Override
    public void setPoseModified(boolean poseModified) {
        this.poseModified = poseModified;
    }

    @Override
    public float getLastCosmeticsUpdateTime() {
        return this.lastCosmeticsUpdateTime;
    }

    @Override
    public void setLastCosmeticsUpdateTime(float lastCosmeticsUpdateTime) {
        this.lastCosmeticsUpdateTime = lastCosmeticsUpdateTime;
    }
}

