/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.ice.common.ice4j;

import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.CandidatePairState;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.CheckList;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.RemoteCandidate;
import gg.essential.lib.jitsi.utils.logging2.Logger;
import gg.essential.mixins.transformers.feature.ice.common.ice4j.IceMediaStreamAcc;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Component.class}, remap=false)
public abstract class Mixin_FixIce4JLocalTrickling {
    @Shadow
    @Final
    private List<RemoteCandidate> remoteCandidates;
    @Shadow
    @Final
    private IceMediaStream parentStream;
    @Shadow
    @Final
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"addLocalCandidate"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private void computeNewPairs(LocalCandidate localCnd, CallbackInfoReturnable<Boolean> ci) {
        CheckList checkList;
        if (this.remoteCandidates.isEmpty()) {
            return;
        }
        if (localCnd.getType() == CandidateType.SERVER_REFLEXIVE_CANDIDATE) {
            localCnd = (LocalCandidate)localCnd.getBase();
        }
        ArrayList<CandidatePair> newPairs = new ArrayList<CandidatePair>();
        for (RemoteCandidate remoteCnd : this.remoteCandidates) {
            if (!localCnd.canReach(remoteCnd) || remoteCnd.getTransportAddress().getPort() == 0) continue;
            newPairs.add(new CandidatePair(localCnd, remoteCnd));
        }
        CheckList checkList2 = checkList = this.parentStream.getCheckList();
        synchronized (checkList2) {
            ArrayList<CandidatePair> toBeRemoved = new ArrayList<CandidatePair>();
            block4: for (CandidatePair newPair : newPairs) {
                for (CandidatePair existingPair : checkList) {
                    boolean sameBase = ((LocalCandidate)existingPair.getLocalCandidate().getBase()).equals(newPair.getLocalCandidate().getBase());
                    boolean sameRemote = existingPair.getRemoteCandidate().equals(newPair.getRemoteCandidate());
                    boolean redundant = sameBase && sameRemote;
                    if (!redundant) continue;
                    if (existingPair.getPriority() >= newPair.getPriority()) {
                        this.logger.debug("ignoring new pair " + newPair.toShortString() + " because of existing higher priority pair " + existingPair.toShortString());
                        continue block4;
                    }
                    CandidatePairState state2 = existingPair.getState();
                    if (state2 != CandidatePairState.FROZEN && state2 != CandidatePairState.WAITING) continue;
                    this.logger.debug("removing existing pair " + existingPair.toShortString() + " because of new higher priority pair " + newPair.toShortString());
                    toBeRemoved.add(existingPair);
                }
            }
            toBeRemoved.forEach(newPairs::remove);
            toBeRemoved.forEach(checkList::remove);
            int maxCheckListSize = ((IceMediaStreamAcc)((Object)this.parentStream)).getMaxCheckListSize();
            newPairs.sort(CandidatePair.comparator);
            for (CandidatePair newPair : newPairs) {
                if (checkList.size() + 1 > maxCheckListSize) {
                    for (CandidatePair existingPair : checkList) {
                        if (existingPair.getState() != CandidatePairState.FAILED) continue;
                        this.logger.debug("discarding failed pair " + existingPair.toShortString() + " to make space for new pair");
                        checkList.remove(existingPair);
                        break;
                    }
                }
                if (checkList.size() + 1 > maxCheckListSize) {
                    // empty if block
                }
                if (checkList.size() + 1 > maxCheckListSize) {
                    this.logger.info("ignoring new pair because checklist is full: " + newPair.toShortString());
                    continue;
                }
                checkList.add(newPair);
                this.logger.info("new Pair added: " + newPair.toShortString() + ".");
            }
        }
    }
}

