/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.ice.common.rtt;

import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.attribute.TransactionTransmitCounterAttribute;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.stack.StunClientTransaction;
import gg.essential.lib.ice4j.stack.TransactionID;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StunClientTransaction.class}, remap=false)
public abstract class Mixin_HandleAttributeOnClient {
    @Shadow
    @Final
    private static Logger logger;
    @Shadow
    @Final
    private Request request;
    @Shadow
    @Final
    private TransactionID transactionID;
    @Unique
    private final List<Instant> sendTime = new ArrayList<Instant>();

    @Inject(method={"sendRequest0"}, at={@At(value="HEAD")})
    private void updateTTCAttribute(CallbackInfo ci) {
        TransactionTransmitCounterAttribute attribute = TransactionTransmitCounterAttribute.get(this.request);
        if (attribute == null) {
            attribute = new TransactionTransmitCounterAttribute();
            this.request.putAttribute(attribute);
        }
        this.sendTime.add(Instant.now());
        attribute.req = this.sendTime.size();
    }

    @Inject(method={"handleResponse"}, at={@At(value="HEAD")})
    private void computeRTT(StunMessageEvent evt, CallbackInfo ci) {
        Response response2 = (Response)evt.getMessage();
        TransactionTransmitCounterAttribute attribute = TransactionTransmitCounterAttribute.get(response2);
        if (attribute == null) {
            return;
        }
        int index2 = attribute.req - 1;
        if (index2 < 0 || index2 >= this.sendTime.size()) {
            logger.warning("Received out of bounds " + attribute.getName() + " for " + this.transactionID + " (req: " + attribute.req + ", resp: " + attribute.resp + ", sent: " + this.sendTime.size() + ")");
            return;
        }
        attribute.rtt = Duration.between(this.sendTime.get(index2), Instant.now());
    }
}

