/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.mod.EssentialAsset;
import gg.essential.model.AnimatedCape;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import gg.essential.util.DispatchersKt;
import gg.essential.util.UIdentifier;
import gg.essential.util.image.bitmap.Bitmap;
import gg.essential.util.image.bitmap.GuiEssentialExtensionsKt;
import gg.essential.util.image.bitmap.MutableBitmap;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lgg/essential/model/AnimatedCape;", "", "()V", "createFrames", "Ljava/util/concurrent/CompletableFuture;", "", "Lgg/essential/util/UIdentifier;", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "texture", "Lgg/essential/mod/EssentialAsset;", "textureBytes", "", "essential-gui-essential"})
public final class AnimatedCape {
    @NotNull
    public static final AnimatedCape INSTANCE = new AnimatedCape();

    private AnimatedCape() {
    }

    @NotNull
    public final CompletableFuture<List<UIdentifier>> createFrames(@NotNull Cosmetic cosmetic2, @NotNull EssentialAsset texture, @NotNull byte[] textureBytes) {
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)textureBytes, (String)"textureBytes");
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.completedFuture(textureBytes).thenApplyAsync(arg_0 -> AnimatedCape.createFrames$lambda$0((Function1)new Function1<byte[], List<? extends Pair<? extends String, ? extends ReleasedDynamicTexture>>>(cosmetic2, texture){
            final /* synthetic */ Cosmetic $cosmetic;
            final /* synthetic */ EssentialAsset $texture;
            {
                this.$cosmetic = $cosmetic;
                this.$texture = $texture;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<Pair<String, ReleasedDynamicTexture>> invoke(byte[] bytes) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNull((Object)bytes);
                MutableBitmap fullImage = GuiEssentialExtensionsKt.fromOrThrow(Bitmap.Companion, new ByteArrayInputStream(bytes));
                int frameWidth = 64;
                int frameHeight = 32;
                int frameCount = fullImage.getHeight() / frameHeight;
                if (fullImage.getWidth() != frameWidth || fullImage.getHeight() != frameHeight * frameCount) {
                    throw new IllegalArgumentException("Texture of " + this.$cosmetic.getId() + " has invalid size: " + fullImage.getWidth() + 'x' + fullImage.getHeight());
                }
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)frameCount);
                EssentialAsset essentialAsset = this.$texture;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void frameIdx;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    MutableBitmap frame = Bitmap.Companion.ofSize(frameWidth, frameHeight);
                    MutableBitmap.DefaultImpls.set$default(frame, 0, 0, frameWidth, frameHeight, fullImage, 0, (int)(frameIdx * frameHeight), false, false, 416, null);
                    collection.add(new Pair((Object)(essentialAsset.getChecksum() + '/' + (int)frameIdx), (Object)((Object)GuiEssentialExtensionsKt.toTexture(frame))));
                }
                return (List)destination$iv$iv;
            }
        }, arg_0))).thenApplyAsync(arg_0 -> AnimatedCape.createFrames$lambda$1(createFrames.2.INSTANCE, arg_0), ExecutorsKt.asExecutor((CoroutineDispatcher)DispatchersKt.getClient(Dispatchers.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApplyAsync(...)");
        return completionStage;
    }

    private static final List createFrames$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List createFrames$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

