/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.mod.cosmetics.CapeModel;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.Bone;
import gg.essential.model.Box3;
import gg.essential.model.Cube;
import gg.essential.model.CubeUvData;
import gg.essential.model.EnumPart;
import gg.essential.model.Side;
import gg.essential.model.Vector3;
import gg.essential.model.file.ModelFile;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\nH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020(*\u0004\u0018\u00010)H\u0002J\f\u0010*\u001a\u00020+*\u00020+H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lgg/essential/model/ModelParser;", "", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "textureWidth", "", "textureHeight", "(Lgg/essential/network/cosmetics/Cosmetic;II)V", "boneByName", "", "", "Lgg/essential/model/Bone;", "boundingBoxes", "", "Lkotlin/Pair;", "Lgg/essential/model/Box3;", "Lgg/essential/model/Side;", "getBoundingBoxes", "()Ljava/util/List;", "rootBone", "getRootBone", "()Lgg/essential/model/Bone;", "textureFrameCount", "getTextureFrameCount", "()I", "setTextureFrameCount", "(I)V", "translucent", "", "getTranslucent", "()Z", "setTranslucent", "(Z)V", "makeBone", "name", "parse", "", "file", "Lgg/essential/model/file/ModelFile;", "toFloatArray", "", "Lgg/essential/model/file/ModelFile$UvFace;", "toRadians", "", "Companion", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nModelParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelParser.kt\ngg/essential/model/ModelParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1#2:160\n1849#3,2:161\n1849#3,2:163\n*S KotlinDebug\n*F\n+ 1 ModelParser.kt\ngg/essential/model/ModelParser\n*L\n114#1:161,2\n118#1:163,2\n*E\n"})
public final class ModelParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cosmetic cosmetic;
    private final int textureWidth;
    private final int textureHeight;
    @NotNull
    private final Map<String, Bone> boneByName;
    @NotNull
    private final List<Pair<Box3, Side>> boundingBoxes;
    @NotNull
    private final Bone rootBone;
    private int textureFrameCount;
    private boolean translucent;
    @NotNull
    private static final Iterable<IndexedValue<Set<CosmeticSlot>>> EXTRA_INFLATE_GROUPS;

    public ModelParser(@NotNull Cosmetic cosmetic2, int textureWidth, int textureHeight) {
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        this.cosmetic = cosmetic2;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.boneByName = new LinkedHashMap();
        this.boundingBoxes = new ArrayList();
        this.rootBone = this.makeBone("_root");
        this.textureFrameCount = 1;
    }

    @NotNull
    public final List<Pair<Box3, Side>> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    @NotNull
    public final Bone getRootBone() {
        return this.rootBone;
    }

    public final int getTextureFrameCount() {
        return this.textureFrameCount;
    }

    public final void setTextureFrameCount(int n) {
        this.textureFrameCount = n;
    }

    public final boolean getTranslucent() {
        return this.translucent;
    }

    public final void setTranslucent(boolean bl) {
        this.translucent = bl;
    }

    private final Bone makeBone(String name2) {
        Bone bone = new Bone(name2);
        bone.setTextureWidth(this.textureWidth);
        bone.setTextureHeight(this.textureHeight);
        this.boneByName.put(name2, bone);
        return bone;
    }

    public final void parse(@NotNull ModelFile file) {
        float f;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ModelFile.Geometry geometry = (ModelFile.Geometry)CollectionsKt.firstOrNull(file.getGeometries());
        if (geometry == null) {
            return;
        }
        ModelFile.Geometry geometry2 = geometry;
        this.textureFrameCount = RangesKt.coerceAtLeast((int)(this.textureHeight / geometry2.getDescription().getTextureHeight()), (int)1);
        this.translucent = geometry2.getDescription().getTextureTranslucent();
        if (Intrinsics.areEqual((Object)this.cosmetic.getType().getId(), (Object)"PLAYER")) {
            f = 0.0f;
        } else {
            IndexedValue<Set<CosmeticSlot>> indexedValue;
            block14: {
                Iterable<IndexedValue<Set<CosmeticSlot>>> iterable = EXTRA_INFLATE_GROUPS;
                Iterator<Object> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    IndexedValue<Set<CosmeticSlot>> indexedValue2;
                    IndexedValue<Set<CosmeticSlot>> it = indexedValue2 = iterator.next();
                    boolean bl = false;
                    if (!((Set)it.getValue()).contains(this.cosmetic.getType().getSlot())) continue;
                    indexedValue = indexedValue2;
                    break block14;
                }
                indexedValue = null;
            }
            IndexedValue indexedValue3 = (IndexedValue)indexedValue;
            f = (float)(indexedValue3 != null ? indexedValue3.getIndex() : 0) * 0.01f + 0.01f;
        }
        float extraInflate = f;
        for (ModelFile.Bone bone : geometry2.getBones()) {
            Bone bone2;
            if (StringsKt.startsWith$default((String)bone.getName(), (String)"bbox_", (boolean)false, (int)2, null)) {
                for (ModelFile.Cube cube : bone.getCubes()) {
                    Vector3 origin = cube.getOrigin();
                    Vector3 size = cube.getSize();
                    Box3 box2 = new Box3(null, null, 3, null);
                    box2.expandByPoint(Vector3.copy$default(origin, 0.0f, 0.0f, 0.0f, 7, null).negateY());
                    box2.expandByPoint(origin.plus(size).negateY());
                    box2.expandByScalar(cube.getInflate() + 0.025f);
                    this.boundingBoxes.add((Pair<Box3, Side>)TuplesKt.to((Object)box2, (Object)((Object)bone.getSide())));
                }
                continue;
            }
            Bone boneModel = this.makeBone(bone.getName());
            boneModel.pivotX = bone.getPivot().x;
            boneModel.pivotY = -bone.getPivot().y;
            boneModel.pivotZ = bone.getPivot().z;
            boneModel.rotateAngleX = this.toRadians(bone.getRotation().x);
            boneModel.rotateAngleY = this.toRadians(bone.getRotation().y);
            boneModel.rotateAngleZ = this.toRadians(bone.getRotation().z);
            boneModel.setMirror(bone.getMirror());
            boneModel.setSide(bone.getSide());
            for (ModelFile.Cube cube : bone.getCubes()) {
                Cube cube2;
                Vector3 vector3 = Vector3.copy$default(cube.getOrigin(), 0.0f, 0.0f, 0.0f, 7, null).negateY();
                float x = vector3.component1();
                float y = vector3.component2();
                float z = vector3.component3();
                Vector3 vector32 = cube.getSize();
                float dx = vector32.component1();
                float dy = vector32.component2();
                float dz = vector32.component3();
                Boolean bl = cube.getMirror();
                boolean mirror = bl != null ? bl.booleanValue() : bone.getMirror();
                float inflate = cube.getInflate() + extraInflate;
                ModelFile.Uvs uv = cube.getUv();
                if (uv instanceof ModelFile.Uvs.PerFace) {
                    CubeUvData uvData = new CubeUvData(this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getNorth()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getEast()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getSouth()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getWest()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getUp()), this.toFloatArray(((ModelFile.Uvs.PerFace)uv).getDown()));
                    cube2 = new Cube(boneModel, x, y - dy, z, dx, dy, dz, inflate, mirror, uvData);
                } else if (uv instanceof ModelFile.Uvs.Box) {
                    float[] fArray = ((ModelFile.Uvs.Box)uv).getUv();
                    float u = fArray[0];
                    float v = fArray[1];
                    cube2 = new Cube(boneModel, u, v, x, y - dy, z, dx, dy, dz, inflate, mirror);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Cube cubeModel = cube2;
                boneModel.cubeList.add(cubeModel);
            }
            if (EnumPart.Companion.fromBoneName(bone.getName()) == EnumPart.CAPE && !Intrinsics.areEqual((Object)geometry2.getDescription().getIdentifier(), (Object)CapeModel.INSTANCE.getGEOMETRY_ID())) {
                CollectionsKt.removeFirstOrNull(boneModel.cubeList);
            }
            if ((bone2 = this.boneByName.get(bone.getParent())) == null) {
                bone2 = this.rootBone;
            }
            bone2.addChild(boneModel);
        }
        ModelParser.parse$setAffectsPoseParts(this.rootBone);
    }

    private final float toRadians(float $this$toRadians) {
        return (float)((double)$this$toRadians / 180.0 * Math.PI);
    }

    private final float[] toFloatArray(ModelFile.UvFace $this$toFloatArray) {
        if ($this$toFloatArray == null) {
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            return fArray;
        }
        float[] fArray = $this$toFloatArray.getUv();
        float u = fArray[0];
        float v = fArray[1];
        float[] fArray2 = $this$toFloatArray.getSize();
        float du = fArray2[0];
        float dv = fArray2[1];
        float[] fArray3 = new float[]{u, v, u + du, v + dv};
        return fArray3;
    }

    private static final void parse$setAffectsPoseParts(Bone $this$parse_u24setAffectsPoseParts) {
        Iterable $this$forEach$iv = $this$parse_u24setAffectsPoseParts.childModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bone it = (Bone)element$iv;
            boolean bl = false;
            ModelParser.parse$setAffectsPoseParts(it);
        }
        Set affectedParts = new LinkedHashSet();
        EnumPart enumPart = EnumPart.Companion.fromBoneName($this$parse_u24setAffectsPoseParts.boxName);
        if (enumPart != null) {
            EnumPart it = enumPart;
            boolean bl = false;
            affectedParts.add(it);
        }
        Iterable $this$forEach$iv2 = $this$parse_u24setAffectsPoseParts.childModels;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Bone it = (Bone)element$iv;
            boolean bl = false;
            affectedParts.addAll((Collection)it.getAffectsPoseParts());
        }
        $this$parse_u24setAffectsPoseParts.setAffectsPose(!((Collection)affectedParts).isEmpty());
        $this$parse_u24setAffectsPoseParts.setAffectsPoseParts(affectedParts);
    }

    static {
        Object[] objectArray = new Set[4];
        objectArray[0] = SetsKt.setOf((Object)CosmeticSlot.PANTS);
        Object[] objectArray2 = new CosmeticSlot[]{CosmeticSlot.TOP, CosmeticSlot.HEAD, CosmeticSlot.FACE, CosmeticSlot.BACK};
        objectArray[1] = SetsKt.setOf((Object[])objectArray2);
        objectArray2 = new CosmeticSlot[]{CosmeticSlot.HAT, CosmeticSlot.FULL_BODY};
        objectArray[2] = SetsKt.setOf((Object[])objectArray2);
        objectArray2 = new CosmeticSlot[]{CosmeticSlot.ACCESSORY, CosmeticSlot.ARMS, CosmeticSlot.SHOES};
        objectArray[3] = SetsKt.setOf((Object[])objectArray2);
        EXTRA_INFLATE_GROUPS = CollectionsKt.withIndex((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgg/essential/model/ModelParser$Companion;", "", "()V", "EXTRA_INFLATE_GROUPS", "", "Lkotlin/collections/IndexedValue;", "", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "cosmetics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

