/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.util;

import gg.essential.lib.kotgl.matrix.matrices.Mat3;
import gg.essential.lib.kotgl.matrix.matrices.Matrices;
import gg.essential.lib.kotgl.matrix.vectors.Vec3;
import gg.essential.lib.kotgl.matrix.vectors.Vectors;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.model.util.KotglKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0006\u0010\u0011\u001a\u00020\u0000J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u0011\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006$"}, d2={"Lgg/essential/model/util/Quaternion;", "", "x", "", "y", "z", "w", "(FFFF)V", "getW", "()F", "getX", "getY", "getZ", "component1", "component2", "component3", "component4", "conjugate", "copy", "equals", "", "other", "hashCode", "", "invert", "normalize", "opposite", "projectAroundAxis", "axis", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "times", "v", "q", "toString", "", "Companion", "cosmetics"})
public final class Quaternion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float x;
    private final float y;
    private final float z;
    private final float w;
    @NotNull
    private static final Quaternion Identity = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    @NotNull
    private static final Quaternion X180 = new Quaternion(1.0f, 0.0f, 0.0f, 0.0f);
    @NotNull
    private static final Quaternion Y180 = new Quaternion(0.0f, 1.0f, 0.0f, 0.0f);
    @NotNull
    private static final Quaternion Z180 = new Quaternion(0.0f, 0.0f, 1.0f, 0.0f);

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getZ() {
        return this.z;
    }

    public final float getW() {
        return this.w;
    }

    @NotNull
    public final Quaternion normalize() {
        float invNorm = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        return new Quaternion(this.x * invNorm, this.y * invNorm, this.z * invNorm, this.w * invNorm);
    }

    @NotNull
    public final Quaternion conjugate() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    @NotNull
    public final Quaternion invert() {
        float invNorm = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        return new Quaternion(-this.x * invNorm, -this.y * invNorm, -this.z * invNorm, this.w * invNorm);
    }

    @NotNull
    public final Quaternion times(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        if (this == Identity) {
            return q;
        }
        if (q == Identity) {
            return this;
        }
        return new Quaternion(this.w * q.x + this.x * q.w + this.y * q.z - this.z * q.y, this.w * q.y - this.x * q.z + this.y * q.w + this.z * q.x, this.w * q.z + this.x * q.y - this.y * q.x + this.z * q.w, this.w * q.w - this.x * q.x - this.y * q.y - this.z * q.z);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return KotglKt.rotateBy(v, this);
    }

    @NotNull
    public final Quaternion projectAroundAxis(@NotNull Vec3 axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        MutableVec3 rotationAxis = MutableVectors.mutableVec3(this.x, this.y, this.z);
        float projectedLength = Vectors.dot(axis, rotationAxis);
        MutableVec3 projectedAxis = MutableVectors.times(axis, projectedLength);
        return projectedLength > 0.0f ? new Quaternion(projectedAxis.getX(), projectedAxis.getY(), projectedAxis.getZ(), this.w).normalize() : new Quaternion(-projectedAxis.getX(), -projectedAxis.getY(), -projectedAxis.getZ(), -this.w).normalize();
    }

    @NotNull
    public final Quaternion opposite() {
        return this.times(Y180);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    public final float component4() {
        return this.w;
    }

    @NotNull
    public final Quaternion copy(float x, float y, float z, float w) {
        return new Quaternion(x, y, z, w);
    }

    public static /* synthetic */ Quaternion copy$default(Quaternion quaternion, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = quaternion.x;
        }
        if ((n & 2) != 0) {
            f2 = quaternion.y;
        }
        if ((n & 4) != 0) {
            f3 = quaternion.z;
        }
        if ((n & 8) != 0) {
            f4 = quaternion.w;
        }
        return quaternion.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "Quaternion(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = result * 31 + Float.hashCode(this.y);
        result = result * 31 + Float.hashCode(this.z);
        result = result * 31 + Float.hashCode(this.w);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)other;
        if (Float.compare(this.x, quaternion.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, quaternion.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, quaternion.z) != 0) {
            return false;
        }
        return Float.compare(this.w, quaternion.w) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lgg/essential/model/util/Quaternion$Companion;", "", "()V", "Identity", "Lgg/essential/model/util/Quaternion;", "getIdentity", "()Lgg/essential/model/util/Quaternion;", "X180", "getX180", "Y180", "getY180", "Z180", "getZ180", "fromAxisAngle", "axis", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "angleRad", "", "fromLookAt", "lookAt", "up", "fromRotationMatrix", "m", "Lgg/essential/lib/kotgl/matrix/matrices/Mat3;", "cosmetics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Quaternion getIdentity() {
            return Identity;
        }

        @NotNull
        public final Quaternion getX180() {
            return X180;
        }

        @NotNull
        public final Quaternion getY180() {
            return Y180;
        }

        @NotNull
        public final Quaternion getZ180() {
            return Z180;
        }

        @NotNull
        public final Quaternion fromAxisAngle(@NotNull Vec3 axis, float angleRad) {
            Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
            if (angleRad == 0.0f) {
                return this.getIdentity();
            }
            float s = (float)Math.sin(angleRad * 0.5f);
            float c = (float)Math.cos(angleRad * 0.5f);
            return new Quaternion(axis.getX() * s, axis.getY() * s, axis.getZ() * s, c);
        }

        @NotNull
        public final Quaternion fromLookAt(@NotNull Vec3 lookAt, @NotNull Vec3 up) {
            Intrinsics.checkNotNullParameter((Object)lookAt, (String)"lookAt");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            MutableVec3 z = MutableVectors.normalizeSelf(MutableVectors.minus((Vec3)Vectors.vecZero(), lookAt));
            MutableVec3 x = MutableVectors.normalizeSelf(MutableVectors.cross(up, z));
            MutableVec3 y = MutableVectors.cross(z, x);
            return this.fromRotationMatrix(Matrices.mat3(x.getX(), y.getX(), z.getX(), x.getY(), y.getY(), z.getY(), x.getZ(), y.getZ(), z.getZ()));
        }

        @NotNull
        public final Quaternion fromRotationMatrix(@NotNull Mat3 m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Mat3 $this$fromRotationMatrix_u24lambda_u240 = m;
            boolean bl = false;
            float trace = $this$fromRotationMatrix_u24lambda_u240.getM00() + $this$fromRotationMatrix_u24lambda_u240.getM11() + $this$fromRotationMatrix_u24lambda_u240.getM22();
            if (trace >= 0.0f) {
                float r = (float)Math.sqrt(trace + 1.0f);
                float s = 0.5f / r;
                return new Quaternion(($this$fromRotationMatrix_u24lambda_u240.getM21() - $this$fromRotationMatrix_u24lambda_u240.getM12()) * s, ($this$fromRotationMatrix_u24lambda_u240.getM02() - $this$fromRotationMatrix_u24lambda_u240.getM20()) * s, ($this$fromRotationMatrix_u24lambda_u240.getM10() - $this$fromRotationMatrix_u24lambda_u240.getM01()) * s, 0.5f * r);
            }
            if ($this$fromRotationMatrix_u24lambda_u240.getM00() >= $this$fromRotationMatrix_u24lambda_u240.getM11() && $this$fromRotationMatrix_u24lambda_u240.getM00() >= $this$fromRotationMatrix_u24lambda_u240.getM22()) {
                float r = (float)Math.sqrt($this$fromRotationMatrix_u24lambda_u240.getM00() - ($this$fromRotationMatrix_u24lambda_u240.getM11() + $this$fromRotationMatrix_u24lambda_u240.getM22()) + 1.0f);
                float s = 0.5f / r;
                return new Quaternion(0.5f * r, ($this$fromRotationMatrix_u24lambda_u240.getM10() + $this$fromRotationMatrix_u24lambda_u240.getM01()) * s, ($this$fromRotationMatrix_u24lambda_u240.getM02() + $this$fromRotationMatrix_u24lambda_u240.getM20()) * s, ($this$fromRotationMatrix_u24lambda_u240.getM21() - $this$fromRotationMatrix_u24lambda_u240.getM12()) * s);
            }
            if ($this$fromRotationMatrix_u24lambda_u240.getM11() > $this$fromRotationMatrix_u24lambda_u240.getM22()) {
                float r = (float)Math.sqrt($this$fromRotationMatrix_u24lambda_u240.getM11() - ($this$fromRotationMatrix_u24lambda_u240.getM22() + $this$fromRotationMatrix_u24lambda_u240.getM00()) + 1.0f);
                float s = 0.5f / r;
                return new Quaternion(($this$fromRotationMatrix_u24lambda_u240.getM10() + $this$fromRotationMatrix_u24lambda_u240.getM01()) * s, 0.5f * r, ($this$fromRotationMatrix_u24lambda_u240.getM21() + $this$fromRotationMatrix_u24lambda_u240.getM12()) * s, ($this$fromRotationMatrix_u24lambda_u240.getM02() - $this$fromRotationMatrix_u24lambda_u240.getM20()) * s);
            }
            float r = (float)Math.sqrt($this$fromRotationMatrix_u24lambda_u240.getM22() - ($this$fromRotationMatrix_u24lambda_u240.getM00() + $this$fromRotationMatrix_u24lambda_u240.getM11()) + 1.0f);
            float s = 0.5f / r;
            return new Quaternion(($this$fromRotationMatrix_u24lambda_u240.getM02() + $this$fromRotationMatrix_u24lambda_u240.getM20()) * s, ($this$fromRotationMatrix_u24lambda_u240.getM21() + $this$fromRotationMatrix_u24lambda_u240.getM12()) * s, 0.5f * r, ($this$fromRotationMatrix_u24lambda_u240.getM10() - $this$fromRotationMatrix_u24lambda_u240.getM01()) * s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

