/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.util;

import java.io.Closeable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f0\bR\b\u0012\u0004\u0012\u00028\u00000\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgg/essential/model/util/ResourceCleaner;", "T", "", "()V", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "toBeCleanedUp", "", "Lgg/essential/model/util/ResourceCleaner$Resource;", "register", "", "owner", "cleanup", "Ljava/lang/Runnable;", "(Ljava/lang/Object;Ljava/lang/Runnable;)V", "runCleanups", "Resource", "utils"})
public final class ResourceCleaner<T> {
    @NotNull
    private final ReferenceQueue<T> referenceQueue = new ReferenceQueue();
    @NotNull
    private final Set<Resource> toBeCleanedUp;

    public ResourceCleaner() {
        Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"newSetFromMap(...)");
        this.toBeCleanedUp = set2;
    }

    public final void register(T owner, @NotNull Runnable cleanup) {
        Intrinsics.checkNotNullParameter((Object)cleanup, (String)"cleanup");
        this.toBeCleanedUp.add(new Resource(owner, cleanup));
    }

    public final void runCleanups() {
        while (true) {
            Reference<T> reference = this.referenceQueue.poll();
            if (reference == null) break;
            ((Resource)reference).close();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lgg/essential/model/util/ResourceCleaner$Resource;", "Ljava/lang/ref/PhantomReference;", "Ljava/io/Closeable;", "owner", "cleanup", "Ljava/lang/Runnable;", "(Lgg/essential/model/util/ResourceCleaner;Ljava/lang/Object;Ljava/lang/Runnable;)V", "getCleanup", "()Ljava/lang/Runnable;", "setCleanup", "(Ljava/lang/Runnable;)V", "close", "", "utils"})
    private final class Resource
    extends PhantomReference<T>
    implements Closeable {
        @Nullable
        private Runnable cleanup;

        public Resource(@NotNull T owner, Runnable cleanup) {
            Intrinsics.checkNotNullParameter((Object)cleanup, (String)"cleanup");
            super(owner, ResourceCleaner.this.referenceQueue);
            this.cleanup = cleanup;
        }

        @Nullable
        public final Runnable getCleanup() {
            return this.cleanup;
        }

        public final void setCleanup(@Nullable Runnable runnable) {
            this.cleanup = runnable;
        }

        @Override
        public void close() {
            ResourceCleaner.this.toBeCleanedUp.remove(this);
            Runnable runnable = this.cleanup;
            if (runnable != null) {
                runnable.run();
            }
            this.cleanup = null;
        }
    }
}

