/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model.util;

import gg.essential.lib.kotgl.matrix.matrices.Mat3;
import gg.essential.lib.kotgl.matrix.matrices.Mat4;
import gg.essential.lib.kotgl.matrix.matrices.Matrices;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMat;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMat3;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMat4;
import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMatrices;
import gg.essential.lib.kotgl.matrix.vectors.Vec3;
import gg.essential.model.util.KotglKt;
import gg.essential.model.util.PlatformMathKt;
import gg.essential.model.util.Quaternion;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J.\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0016J\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgg/essential/model/util/UMatrixStack;", "", "model", "Lgg/essential/lib/kotgl/matrix/matrices/Mat4;", "normal", "Lgg/essential/lib/kotgl/matrix/matrices/Mat3;", "(Ldev/folomeev/kotgl/matrix/matrices/Mat4;Ldev/folomeev/kotgl/matrix/matrices/Mat3;)V", "stack", "", "Lgg/essential/model/util/UMatrixStack$Entry;", "(Ljava/util/List;)V", "fork", "multiply", "", "other", "peek", "pop", "push", "rotate", "q", "Lgg/essential/model/util/Quaternion;", "angle", "", "x", "y", "z", "degrees", "", "scale", "value", "translate", "vec", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "Entry", "cosmetics"})
public final class UMatrixStack {
    @NotNull
    private final List<Entry> stack;

    public UMatrixStack(@NotNull List<Entry> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        this.stack = stack;
    }

    public UMatrixStack(@NotNull Mat4 model, @NotNull Mat3 normal) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        Object[] objectArray = new Entry[]{new Entry(MutableMatrices.toMutable(model), MutableMatrices.toMutable(normal))};
        this(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    public /* synthetic */ UMatrixStack(Mat4 mat4, Mat3 mat3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mat4 = Matrices.identityMat4();
        }
        if ((n & 2) != 0) {
            mat3 = Matrices.identityMat3();
        }
        this(mat4, mat3);
    }

    /*
     * WARNING - void declaration
     */
    public final void translate(float x, float y, float z) {
        void $this$translate_u24lambda_u241_u24lambda_u240;
        MutableMat4 mutableMat4;
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return;
        }
        Entry $this$translate_u24lambda_u241 = (Entry)CollectionsKt.last(this.stack);
        boolean bl = false;
        MutableMat4 mutableMat42 = mutableMat4 = MutableMatrices.toMutable(Matrices.identityMat4());
        MutableMat4 mutableMat43 = $this$translate_u24lambda_u241.getModel();
        boolean bl2 = false;
        $this$translate_u24lambda_u241_u24lambda_u240.setM03(x);
        $this$translate_u24lambda_u241_u24lambda_u240.setM13(y);
        $this$translate_u24lambda_u241_u24lambda_u240.setM23(z);
        MutableMatrices.timesSelf(mutableMat43, mutableMat4);
    }

    public final void translate(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.translate(vec.getX(), vec.getY(), vec.getZ());
    }

    public final void scale(float value2) {
        this.scale(value2, value2, value2);
    }

    /*
     * WARNING - void declaration
     */
    public final void scale(float x, float y, float z) {
        void $this$scale_u24lambda_u244_u24lambda_u242;
        MutableMat4 mutableMat4;
        if (x == 1.0f && y == 1.0f && z == 1.0f) {
            return;
        }
        Entry $this$scale_u24lambda_u244 = (Entry)CollectionsKt.last(this.stack);
        boolean bl = false;
        MutableMat4 mutableMat42 = mutableMat4 = MutableMatrices.toMutable(Matrices.identityMat4());
        MutableMat mutableMat = $this$scale_u24lambda_u244.getModel();
        boolean bl2 = false;
        $this$scale_u24lambda_u244_u24lambda_u242.setM00(x);
        $this$scale_u24lambda_u244_u24lambda_u242.setM11(y);
        $this$scale_u24lambda_u244_u24lambda_u242.setM22(z);
        MutableMatrices.timesSelf(mutableMat, mutableMat4);
        if (x == y && y == z) {
            if (x < 0.0f) {
                MutableMatrices.timesSelf($this$scale_u24lambda_u244.getNormal(), -1.0f);
            }
        } else {
            void $this$scale_u24lambda_u244_u24lambda_u243;
            MutableMat3 mutableMat3;
            float ix = 1.0f / x;
            float iy = 1.0f / y;
            float iz = 1.0f / z;
            float rt = PlatformMathKt.cbrt(ix * iy * iz);
            MutableMat3 mutableMat32 = mutableMat3 = MutableMatrices.toMutable(Matrices.identityMat3());
            mutableMat = $this$scale_u24lambda_u244.getNormal();
            boolean bl3 = false;
            $this$scale_u24lambda_u244_u24lambda_u243.setM00(rt * ix);
            $this$scale_u24lambda_u244_u24lambda_u243.setM11(rt * iy);
            $this$scale_u24lambda_u244_u24lambda_u243.setM22(rt * iz);
            MutableMatrices.timesSelf((MutableMat3)mutableMat, mutableMat3);
        }
    }

    public final void rotate(float angle, float x, float y, float z, boolean degrees) {
        if (angle == 0.0f) {
            return;
        }
        Entry $this$rotate_u24lambda_u245 = (Entry)CollectionsKt.last(this.stack);
        boolean bl = false;
        float angleRadians = degrees ? (float)((double)(angle / (float)180) * Math.PI) : angle;
        float c = (float)Math.cos(angleRadians);
        float s = (float)Math.sin(angleRadians);
        float oneMinusC = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float xs = x * s;
        float ys = y * s;
        float zs = z * s;
        Mat3 rotation = Matrices.mat3(xx * oneMinusC + c, xy * oneMinusC - zs, xz * oneMinusC + ys, xy * oneMinusC + zs, yy * oneMinusC + c, yz * oneMinusC - xs, xz * oneMinusC - ys, yz * oneMinusC + xs, zz * oneMinusC + c);
        MutableMatrices.timesSelf($this$rotate_u24lambda_u245.getModel(), KotglKt.toMat4(rotation));
        MutableMatrices.timesSelf($this$rotate_u24lambda_u245.getNormal(), rotation);
    }

    public final void rotate(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        float n = 1.0f / (float)Math.sqrt(1.0f - q.getW() * q.getW());
        this.rotate((float)2 * (float)Math.acos(q.getW()), q.getX() * n, q.getY() * n, q.getZ() * n, false);
    }

    public final void multiply(@NotNull UMatrixStack other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Entry thisEntry = (Entry)CollectionsKt.last(this.stack);
        Entry otherEntry = (Entry)CollectionsKt.last(other.stack);
        MutableMatrices.timesSelf(thisEntry.getModel(), otherEntry.getModel());
        MutableMatrices.timesSelf(thisEntry.getNormal(), otherEntry.getNormal());
    }

    @NotNull
    public final UMatrixStack fork() {
        Object[] objectArray = new Entry[]{((Entry)CollectionsKt.last(this.stack)).deepCopy()};
        return new UMatrixStack(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    public final void push() {
        this.stack.add(((Entry)CollectionsKt.last(this.stack)).deepCopy());
    }

    public final void pop() {
        CollectionsKt.removeLast(this.stack);
    }

    @NotNull
    public final Entry peek() {
        return (Entry)CollectionsKt.last(this.stack);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u000e\u001a\u00020\u0000J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lgg/essential/model/util/UMatrixStack$Entry;", "", "model", "Lgg/essential/lib/kotgl/matrix/matrices/mutables/MutableMat4;", "normal", "Lgg/essential/lib/kotgl/matrix/matrices/mutables/MutableMat3;", "(Ldev/folomeev/kotgl/matrix/matrices/mutables/MutableMat4;Ldev/folomeev/kotgl/matrix/matrices/mutables/MutableMat3;)V", "getModel", "()Ldev/folomeev/kotgl/matrix/matrices/mutables/MutableMat4;", "getNormal", "()Ldev/folomeev/kotgl/matrix/matrices/mutables/MutableMat3;", "component1", "component2", "copy", "deepCopy", "equals", "", "other", "hashCode", "", "toString", "", "cosmetics"})
    public static final class Entry {
        @NotNull
        private final MutableMat4 model;
        @NotNull
        private final MutableMat3 normal;

        public Entry(@NotNull MutableMat4 model, @NotNull MutableMat3 normal) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
            this.model = model;
            this.normal = normal;
        }

        @NotNull
        public final MutableMat4 getModel() {
            return this.model;
        }

        @NotNull
        public final MutableMat3 getNormal() {
            return this.normal;
        }

        @NotNull
        public final Entry deepCopy() {
            return new Entry(this.model.copyOf(), this.normal.copyOf());
        }

        @NotNull
        public final MutableMat4 component1() {
            return this.model;
        }

        @NotNull
        public final MutableMat3 component2() {
            return this.normal;
        }

        @NotNull
        public final Entry copy(@NotNull MutableMat4 model, @NotNull MutableMat3 normal) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
            return new Entry(model, normal);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, MutableMat4 mutableMat4, MutableMat3 mutableMat3, int n, Object object) {
            if ((n & 1) != 0) {
                mutableMat4 = entry.model;
            }
            if ((n & 2) != 0) {
                mutableMat3 = entry.normal;
            }
            return entry.copy(mutableMat4, mutableMat3);
        }

        @NotNull
        public String toString() {
            return "Entry(model=" + this.model + ", normal=" + this.normal + ')';
        }

        public int hashCode() {
            int result = this.model.hashCode();
            result = result * 31 + this.normal.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.model, (Object)entry.model)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.normal, (Object)entry.normal);
        }
    }
}

