/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager;

import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.connection.ClientConnectionDisconnectPacket;
import gg.essential.connectionmanager.common.packet.connection.ServerConnectionReconnectPacket;
import gg.essential.connectionmanager.common.packet.multiplayer.ServerMultiplayerJoinServerPacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerUuidNameMapPacket;
import gg.essential.event.client.PostInitializationEvent;
import gg.essential.gui.elementa.state.v2.combinators.StateKt;
import gg.essential.gui.wardrobe.Item;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.client.MinecraftHook;
import gg.essential.network.connectionmanager.CloseReason;
import gg.essential.network.connectionmanager.Connection;
import gg.essential.network.connectionmanager.ConnectionManagerKt;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.chat.ChatManager;
import gg.essential.network.connectionmanager.coins.CoinsManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.cosmetics.OutfitManager;
import gg.essential.network.connectionmanager.cosmetics.PacketHandlers;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ClientConnectionDisconnectPacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ServerConnectionReconnectPacketHandler;
import gg.essential.network.connectionmanager.handler.mojang.ServerUuidNameMapPacketHandler;
import gg.essential.network.connectionmanager.handler.multiplayer.ServerMultiplayerJoinServerPacketHandler;
import gg.essential.network.connectionmanager.ice.IIceManager;
import gg.essential.network.connectionmanager.ice.IceManagerMcImpl;
import gg.essential.network.connectionmanager.media.ScreenshotManager;
import gg.essential.network.connectionmanager.notices.NoticesManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.network.connectionmanager.relationship.RelationshipManager;
import gg.essential.network.connectionmanager.serverdiscovery.ServerDiscoveryManager;
import gg.essential.network.connectionmanager.skins.SkinsManager;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.network.connectionmanager.telemetry.TelemetryManager;
import gg.essential.util.ModLoaderUtil;
import gg.essential.util.Multithreading;
import gg.essential.util.lwjgl3.Lwjgl3Loader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionManager
extends ConnectionManagerKt {
    @NotNull
    final PacketHandlers packetHandlers = new PacketHandlers();
    @NotNull
    private final MinecraftHook minecraftHook;
    @NotNull
    private final List<NetworkedManager> managers = new ArrayList<NetworkedManager>();
    @NotNull
    private final NoticesManager noticesManager;
    @NotNull
    private final SubscriptionManager subscriptionManager;
    @NotNull
    private final RelationshipManager relationshipManager;
    @NotNull
    private final CosmeticsManager cosmeticsManager;
    @NotNull
    private final ChatManager chatManager;
    @NotNull
    private final ProfileManager profileManager;
    @NotNull
    private final SPSManager spsManager;
    @NotNull
    private final ServerDiscoveryManager serverDiscoveryManager;
    @NotNull
    private final SocialManager socialManager;
    @NotNull
    private final IIceManager iceManager;
    @NotNull
    private final ScreenshotManager screenshotManager;
    @NotNull
    private final TelemetryManager telemetryManager;
    private CoinsManager coinsManager;
    private SkinsManager skinsManager;
    @NotNull
    private final OutfitManager outfitManager;
    private boolean modsLoaded = false;
    private boolean modsSent = false;

    public ConnectionManager(@NotNull MinecraftHook minecraftHook, File baseDir, Lwjgl3Loader lwjgl3) {
        this.minecraftHook = minecraftHook;
        this.subscriptionManager = new SubscriptionManager(this);
        this.managers.add(this.subscriptionManager);
        this.registerPacketHandler(ClientConnectionDisconnectPacket.class, new ClientConnectionDisconnectPacketHandler());
        this.registerPacketHandler(ServerConnectionReconnectPacket.class, new ServerConnectionReconnectPacketHandler());
        this.registerPacketHandler(ServerMultiplayerJoinServerPacket.class, new ServerMultiplayerJoinServerPacketHandler());
        this.registerPacketHandler(ServerUuidNameMapPacket.class, new ServerUuidNameMapPacketHandler());
        this.noticesManager = new NoticesManager(this);
        this.managers.add(this.noticesManager);
        this.cosmeticsManager = new CosmeticsManager(this, baseDir);
        this.managers.add(this.cosmeticsManager);
        this.managers.add(this.cosmeticsManager.getEquippedCosmeticsManager());
        this.relationshipManager = new RelationshipManager(this);
        this.managers.add(this.relationshipManager);
        this.chatManager = new ChatManager(this);
        this.managers.add(this.chatManager);
        this.profileManager = new ProfileManager(this);
        this.managers.add(this.profileManager);
        this.spsManager = new SPSManager(this);
        this.managers.add(this.spsManager);
        this.serverDiscoveryManager = new ServerDiscoveryManager(this);
        this.managers.add(this.serverDiscoveryManager);
        this.socialManager = new SocialManager(this);
        this.managers.add(this.socialManager);
        this.iceManager = new IceManagerMcImpl(this, baseDir.toPath(), (Function1<? super UUID, Boolean>)((Function1)uuid -> this.spsManager.getInvitedUsers().contains(uuid)));
        this.screenshotManager = new ScreenshotManager(this, baseDir, lwjgl3);
        this.managers.add(this.screenshotManager);
        this.telemetryManager = new TelemetryManager(this);
        this.managers.add(this.telemetryManager);
        this.coinsManager = new CoinsManager(this);
        this.managers.add(this.coinsManager);
        this.skinsManager = new SkinsManager(this);
        this.managers.add(this.skinsManager);
        this.outfitManager = new OutfitManager(this, this.cosmeticsManager, StateKt.map(this.skinsManager.getSkins(), map2 -> MapsKt.mapValues((Map)map2, it -> ((Item.SkinItem)it.getValue()).getSkin())));
        this.managers.add(this.outfitManager);
    }

    @NotNull
    public MinecraftHook getMinecraftHook() {
        return this.minecraftHook;
    }

    @NotNull
    public NoticesManager getNoticesManager() {
        return this.noticesManager;
    }

    @NotNull
    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @NotNull
    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    @NotNull
    public CosmeticsManager getCosmeticsManager() {
        return this.cosmeticsManager;
    }

    @NotNull
    public ChatManager getChatManager() {
        return this.chatManager;
    }

    @NotNull
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @NotNull
    public SPSManager getSpsManager() {
        return this.spsManager;
    }

    @NotNull
    public SocialManager getSocialManager() {
        return this.socialManager;
    }

    @NotNull
    public ScreenshotManager getScreenshotManager() {
        return this.screenshotManager;
    }

    @NotNull
    public IIceManager getIceManager() {
        return this.iceManager;
    }

    @NotNull
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @NotNull
    public CoinsManager getCoinsManager() {
        return this.coinsManager;
    }

    @NotNull
    public SkinsManager getSkinsManager() {
        return this.skinsManager;
    }

    @NotNull
    public OutfitManager getOutfitManager() {
        return this.outfitManager;
    }

    public boolean isOpen() {
        Connection connection = this.connection;
        return connection != null && connection.isOpen();
    }

    public boolean isAuthenticated() {
        return this.connection != null;
    }

    public <T extends Packet> void registerPacketHandler(Class<T> cls, PacketHandler<T> handler) {
        this.packetHandlers.register(cls, handler);
    }

    @Override
    public <T extends Packet> void registerPacketHandler(@NotNull Class<T> cls, final @NotNull Function1<? super T, Unit> handler) {
        this.registerPacketHandler(cls, new PacketHandler<T>(){

            @Override
            protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull T packet) {
                handler.invoke(packet);
            }
        });
    }

    @Override
    protected void completeConnection(Connection connection) {
        this.connection = connection;
        for (NetworkedManager manager : this.managers) {
            manager.onConnected();
        }
        if (this.modsLoaded && !this.modsSent) {
            Multithreading.runAsync(() -> this.send(ModLoaderUtil.createModsAnnouncePacket()));
            this.modsSent = true;
        }
    }

    @Override
    protected void onClose() {
        this.connection = null;
        this.modsSent = false;
        JobKt.cancelChildren((CoroutineContext)this.getConnectionScope().getCoroutineContext(), (CancellationException)ExceptionsKt.CancellationException((String)"Connection closed.", null));
        for (NetworkedManager manager : this.managers) {
            manager.onDisconnect();
        }
    }

    @Deprecated
    public void send(@NotNull Packet packet) {
        this.send(packet, null);
    }

    @Deprecated
    public void send(@NotNull Packet packet, @Nullable Consumer<Optional<Packet>> responseCallback) {
        this.send(packet, responseCallback, TimeUnit.SECONDS, 10L);
    }

    @Override
    @Deprecated
    public void send(@NotNull Packet packet, @Nullable Consumer<Optional<Packet>> responseCallback, @Nullable TimeUnit timeoutUnit, @Nullable Long timeoutValue) {
        Connection connection = this.connection;
        if (connection == null || !connection.isOpen()) {
            if (responseCallback != null) {
                responseCallback.accept(Optional.empty());
            }
            return;
        }
        boolean wantsResponseHandling = responseCallback != null && timeoutUnit != null && timeoutValue != null;
        UUID packetId = packet.getPacketUniqueId();
        packetId = wantsResponseHandling && packetId == null ? UUID.randomUUID() : packetId;
        packet.setUniqueId(packetId);
        if (wantsResponseHandling) {
            this.packetHandlers.register(packetId, timeoutUnit, timeoutValue, responseCallback);
        }
        connection.send(packet);
    }

    @Subscribe
    public void onPostInit(PostInitializationEvent event) {
        this.modsLoaded = true;
        if (!this.modsSent && this.isAuthenticated()) {
            Multithreading.runAsync(() -> this.send(ModLoaderUtil.createModsAnnouncePacket()));
            this.modsSent = true;
        }
    }

    public ServerDiscoveryManager getServerDiscoveryManager() {
        return this.serverDiscoveryManager;
    }

    public void onTosRevokedOrEssentialDisabled() {
        if (this.isOpen()) {
            this.close(CloseReason.USER_TOS_REVOKED);
        }
        for (NetworkedManager manager : this.managers) {
            manager.resetState();
        }
    }

    public static enum Status {
        NO_TOS,
        ESSENTIAL_DISABLED,
        OUTDATED,
        CANCELLED,
        ALREADY_CONNECTED,
        NO_RESPONSE,
        INVALID_RESPONSE,
        MOJANG_UNAUTHORIZED,
        GENERAL_FAILURE,
        SUCCESS;

    }
}

