/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.coins;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.checkout.ClientCheckoutClaimCoinsPacket;
import gg.essential.connectionmanager.common.packet.checkout.ClientCheckoutCoinBundlePacket;
import gg.essential.connectionmanager.common.packet.checkout.ClientCheckoutDynamicCoinBundlePacket;
import gg.essential.connectionmanager.common.packet.checkout.ClientCheckoutPartnerCodeRequestDataPacket;
import gg.essential.connectionmanager.common.packet.checkout.ServerCheckoutClaimCoinsResponsePacket;
import gg.essential.connectionmanager.common.packet.checkout.ServerCheckoutPartnerCodeDataPacket;
import gg.essential.connectionmanager.common.packet.checkout.ServerCheckoutUrlPacket;
import gg.essential.connectionmanager.common.packet.coins.ClientCoinBundleOptionsPacket;
import gg.essential.connectionmanager.common.packet.coins.ClientCoinsBalancePacket;
import gg.essential.connectionmanager.common.packet.coins.ServerCoinBundleOptionsPacket;
import gg.essential.connectionmanager.common.packet.coins.ServerCoinsBalancePacket;
import gg.essential.connectionmanager.common.packet.currency.ClientCurrencyOptionsPacket;
import gg.essential.connectionmanager.common.packet.currency.ServerCurrencyOptionsPacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.elementa.state.v2.ListKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.ReferenceHolderImpl;
import gg.essential.gui.elementa.state.v2.SetKt;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateByKt;
import gg.essential.gui.elementa.state.v2.StateByScope;
import gg.essential.gui.elementa.state.v2.collections.MutableTrackedList;
import gg.essential.gui.elementa.state.v2.collections.MutableTrackedSet;
import gg.essential.gui.elementa.state.v2.collections.TrackedList;
import gg.essential.gui.elementa.state.v2.combinators.StateKt;
import gg.essential.gui.notification.HelpersKt;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.gui.wardrobe.modals.CoinsReceivedModal;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.coins.CoinBundle;
import gg.essential.network.connectionmanager.coins.CoinsManager;
import gg.essential.network.connectionmanager.handler.checkout.ServerCheckoutPartnerCodeDataPacketHandler;
import gg.essential.network.connectionmanager.handler.coins.ServerCoinsBalancePacketHandler;
import gg.essential.network.cosmetics.ConversionsKt;
import gg.essential.util.CurrencyKt;
import gg.essential.util.GuiUtil;
import gg.essential.util.Multithreading;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ]2\u00020\u0001:\u0001]B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J)\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\n0\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001f\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010!\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b!\u0010 J\r\u0010\"\u001a\u00020\n\u00a2\u0006\u0004\b\"\u0010\u000eJ\u0019\u0010\"\u001a\u00020\n2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0004\b\"\u0010%J\u000f\u0010&\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b&\u0010\u000eJ\r\u0010'\u001a\u00020\n\u00a2\u0006\u0004\b'\u0010\u000eJ+\u0010*\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\u00122\b\b\u0002\u0010)\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b*\u0010+R\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R(\u00102\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f010,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010.R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u0006038\u0006\u00a2\u0006\f\n\u0004\b\u0007\u00104\u001a\u0004\b5\u00106R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u0006038\u0006\u00a2\u0006\f\n\u0004\b\b\u00104\u001a\u0004\b7\u00106R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010:R\u001d\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f038\u0006\u00a2\u0006\f\n\u0004\b;\u00104\u001a\u0004\b<\u00106R\u001f\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0,8\u0006\u00a2\u0006\f\n\u0004\b=\u0010.\u001a\u0004\b>\u00100R\u001d\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f038\u0006\u00a2\u0006\f\n\u0004\b?\u00104\u001a\u0004\b@\u00106R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010.R\u001f\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0012038\u0006\u00a2\u0006\f\n\u0004\bB\u00104\u001a\u0004\bC\u00106R-\u0010F\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0D03j\b\u0012\u0004\u0012\u00020#`E8\u0006\u00a2\u0006\f\n\u0004\bF\u00104\u001a\u0004\bG\u00106R\u001f\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#038\u0006\u00a2\u0006\f\n\u0004\b$\u00104\u001a\u0004\bH\u00106R\u001d\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000f0,8\u0006\u00a2\u0006\f\n\u0004\bI\u0010.\u001a\u0004\bJ\u00100R\u0016\u0010K\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0016\u0010M\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u001a\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00060,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010.R\u001a\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00060,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010.R*\u0010S\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0Q0,j\b\u0012\u0004\u0012\u00020#`R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010.R*\u0010V\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160T0,j\b\u0012\u0004\u0012\u00020\u0016`U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010.R-\u0010W\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160D03j\b\u0012\u0004\u0012\u00020\u0016`E8\u0006\u00a2\u0006\f\n\u0004\bW\u00104\u001a\u0004\bX\u00106R\u0016\u0010Y\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010NR\u0014\u0010[\u001a\u00020Z8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b[\u0010\\\u00a8\u0006^"}, d2={"Lgg/essential/network/connectionmanager/coins/CoinsManager;", "Lgg/essential/network/connectionmanager/NetworkedManager;", "Lgg/essential/network/connectionmanager/ConnectionManager;", "connectionManager", "<init>", "(Lgg/essential/network/connectionmanager/ConnectionManager;)V", "", "coins", "coinsSpent", "topUpAmount", "", "onBalanceUpdate", "(IILjava/lang/Integer;)V", "onConnected", "()V", "", "code", "name", "", "persist", "onCreatorCodeData", "(Ljava/lang/String;Ljava/lang/String;Z)V", "Lgg/essential/network/connectionmanager/coins/CoinBundle;", "bundle", "Lkotlin/Function1;", "Ljava/net/URI;", "callback", "purchaseBundle", "(Lgg/essential/network/connectionmanager/coins/CoinBundle;Lkotlin/jvm/functions/Function1;)V", "", "retryDelay", "refreshCoins", "(J)V", "refreshCurrencies", "refreshPricing", "Ljava/util/Currency;", "currency", "(Ljava/util/Currency;)V", "resetState", "tryClaimingWelcomeCoins", "debounce", "force", "validateCode", "(Ljava/lang/String;ZZ)V", "Lgg/essential/gui/elementa/state/v2/MutableState;", "areCoinsVisuallyFrozen", "Lgg/essential/gui/elementa/state/v2/MutableState;", "getAreCoinsVisuallyFrozen", "()Lgg/essential/gui/elementa/state/v2/MutableState;", "", "checkedCreatorCodes", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/elementa/state/v2/State;", "getCoins", "()Lgg/essential/gui/elementa/state/v2/State;", "getCoinsSpent", "Lgg/essential/network/connectionmanager/ConnectionManager;", "getConnectionManager", "()Lgg/essential/network/connectionmanager/ConnectionManager;", "creatorCode", "getCreatorCode", "creatorCodeConfigured", "getCreatorCodeConfigured", "creatorCodeName", "getCreatorCodeName", "creatorCodeNonPersistent", "creatorCodeValid", "getCreatorCodeValid", "Lgg/essential/gui/elementa/state/v2/collections/TrackedList;", "Lgg/essential/gui/elementa/state/v2/ListState;", "currencies", "getCurrencies", "getCurrency", "currencyRaw", "getCurrencyRaw", "currentCodeValidationTaskId", "I", "isClaimingCoins", "Z", "mutableCoins", "mutableCoinsSpent", "Lgg/essential/gui/elementa/state/v2/collections/MutableTrackedSet;", "Lgg/essential/gui/elementa/state/v2/MutableSetState;", "mutableCurrencies", "Lgg/essential/gui/elementa/state/v2/collections/MutableTrackedList;", "Lgg/essential/gui/elementa/state/v2/MutableListState;", "mutablePricing", "pricing", "getPricing", "purchaseRequestInProgress", "Lgg/essential/gui/elementa/state/v2/ReferenceHolderImpl;", "referenceHolder", "Lgg/essential/gui/elementa/state/v2/ReferenceHolderImpl;", "Companion", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nCoinsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoinsManager.kt\ngg/essential/network/connectionmanager/coins/CoinsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1549#2:310\n1620#2,3:311\n*S KotlinDebug\n*F\n+ 1 CoinsManager.kt\ngg/essential/network/connectionmanager/coins/CoinsManager\n*L\n204#1:310\n204#1:311,3\n*E\n"})
public final class CoinsManager
implements NetworkedManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final ReferenceHolderImpl referenceHolder;
    private int currentCodeValidationTaskId;
    private boolean isClaimingCoins;
    @NotNull
    private final MutableState<Integer> mutableCoins;
    @NotNull
    private final MutableState<Integer> mutableCoinsSpent;
    @NotNull
    private final MutableState<MutableTrackedList<CoinBundle>> mutablePricing;
    @NotNull
    private final MutableState<MutableTrackedSet<Currency>> mutableCurrencies;
    @NotNull
    private final MutableState<Map<String, String>> checkedCreatorCodes;
    private boolean purchaseRequestInProgress;
    @NotNull
    private final MutableState<String> creatorCodeNonPersistent;
    @NotNull
    private final MutableState<String> currencyRaw;
    @NotNull
    private final MutableState<String> creatorCodeConfigured;
    @NotNull
    private final MutableState<Boolean> areCoinsVisuallyFrozen;
    @NotNull
    private final State<String> creatorCode;
    @NotNull
    private final State<Integer> coins;
    @NotNull
    private final State<Integer> coinsSpent;
    @NotNull
    private final State<TrackedList<CoinBundle>> pricing;
    @NotNull
    private final State<TrackedList<Currency>> currencies;
    @NotNull
    private final State<Currency> currency;
    @NotNull
    private final State<String> creatorCodeName;
    @NotNull
    private final State<Boolean> creatorCodeValid;
    @NotNull
    private static final DecimalFormat COIN_FORMAT = new DecimalFormat("#,###", new DecimalFormatSymbols(Locale.US));

    public CoinsManager(@NotNull ConnectionManager connectionManager) {
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        this.connectionManager = connectionManager;
        this.referenceHolder = new ReferenceHolderImpl();
        this.mutableCoins = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(0);
        this.mutableCoinsSpent = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(0);
        this.mutablePricing = ListKt.mutableListStateOf(new CoinBundle[0]);
        Currency[] currencyArray = new Currency[]{CurrencyKt.getUSD_CURRENCY()};
        this.mutableCurrencies = SetKt.mutableSetState(currencyArray);
        this.checkedCreatorCodes = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(MapsKt.emptyMap());
        this.creatorCodeNonPersistent = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf("");
        this.currencyRaw = EssentialConfig.INSTANCE.getCoinsSelectedCurrencyState();
        this.creatorCodeConfigured = EssentialConfig.INSTANCE.getCoinsPurchaseCreatorCodeState();
        this.areCoinsVisuallyFrozen = gg.essential.gui.elementa.state.v2.StateKt.mutableStateOf(false);
        this.creatorCode = StateByKt.stateBy((Function1)new Function1<StateByScope, String>(this){
            final /* synthetic */ CoinsManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull StateByScope $this$stateBy) {
                Intrinsics.checkNotNullParameter((Object)$this$stateBy, (String)"$this$stateBy");
                String string = (String)$this$stateBy.invoke((State)this.this$0.getCreatorCodeConfigured());
                if (string == null) {
                    string = (String)$this$stateBy.invoke(CoinsManager.access$getCreatorCodeNonPersistent$p(this.this$0));
                }
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                return string2;
            }
        });
        this.coins = this.mutableCoins;
        this.coinsSpent = this.mutableCoinsSpent;
        this.pricing = this.mutablePricing;
        this.currencies = ListKt.toListState(StateKt.map((State)this.mutableCurrencies, currencies.1.INSTANCE));
        this.currency = StateByKt.stateBy((Function1)new Function1<StateByScope, Currency>(this){
            final /* synthetic */ CoinsManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Currency invoke(@NotNull StateByScope $this$stateBy) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$this$stateBy, (String)"$this$stateBy");
                    Currency currency2 = Currency.getInstance((String)$this$stateBy.invoke((State)this.this$0.getCurrencyRaw()));
                    Iterable iterable = $this$stateBy.invoke(this.this$0.getCurrencies());
                    for (T t : iterable) {
                        Currency it = (Currency)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getCurrencyCode(), (Object)currency2.getCurrencyCode())) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        });
        this.creatorCodeName = StateByKt.stateBy((Function1)new Function1<StateByScope, String>(this){
            final /* synthetic */ CoinsManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull StateByScope $this$stateBy) {
                Intrinsics.checkNotNullParameter((Object)$this$stateBy, (String)"$this$stateBy");
                String string = (String)((Map)$this$stateBy.invoke(CoinsManager.access$getCheckedCreatorCodes$p(this.this$0))).get($this$stateBy.invoke(this.this$0.getCreatorCode()));
                if (string == null) {
                    String string2 = $this$stateBy.invoke(this.this$0.getCreatorCode()).toLowerCase(Locale.ROOT);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                }
                return string;
            }
        });
        this.creatorCodeValid = StateByKt.stateBy((Function1)new Function1<StateByScope, Boolean>(this){
            final /* synthetic */ CoinsManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Boolean invoke(@NotNull StateByScope $this$stateBy) {
                Intrinsics.checkNotNullParameter((Object)$this$stateBy, (String)"$this$stateBy");
                Map codesMap = (Map)$this$stateBy.invoke(CoinsManager.access$getCheckedCreatorCodes$p(this.this$0));
                String code = $this$stateBy.invoke(this.this$0.getCreatorCode());
                return codesMap.containsKey(code) ? Boolean.valueOf(codesMap.get(code) != null) : null;
            }
        });
        this.connectionManager.registerPacketHandler(ServerCoinsBalancePacket.class, new ServerCoinsBalancePacketHandler());
        this.connectionManager.registerPacketHandler(ServerCheckoutPartnerCodeDataPacket.class, new ServerCheckoutPartnerCodeDataPacketHandler());
        this.currency.onSetValue(this.referenceHolder, (Function1<Currency, Unit>)((Function1)new Function1<Currency, Unit>(){

            public final void invoke(@Nullable Currency it) {
                this.refreshPricing(it);
            }
        }));
        this.creatorCodeConfigured.onSetValue(this.referenceHolder, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@Nullable String it) {
                CoinsManager.validateCode$default(this, it, true, false, 4, null);
            }
        }));
    }

    @NotNull
    public final ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @NotNull
    public final MutableState<String> getCurrencyRaw() {
        return this.currencyRaw;
    }

    @NotNull
    public final MutableState<String> getCreatorCodeConfigured() {
        return this.creatorCodeConfigured;
    }

    @NotNull
    public final MutableState<Boolean> getAreCoinsVisuallyFrozen() {
        return this.areCoinsVisuallyFrozen;
    }

    @NotNull
    public final State<String> getCreatorCode() {
        return this.creatorCode;
    }

    @NotNull
    public final State<Integer> getCoins() {
        return this.coins;
    }

    @NotNull
    public final State<Integer> getCoinsSpent() {
        return this.coinsSpent;
    }

    @NotNull
    public final State<TrackedList<CoinBundle>> getPricing() {
        return this.pricing;
    }

    @NotNull
    public final State<TrackedList<Currency>> getCurrencies() {
        return this.currencies;
    }

    @NotNull
    public final State<Currency> getCurrency() {
        return this.currency;
    }

    @NotNull
    public final State<String> getCreatorCodeName() {
        return this.creatorCodeName;
    }

    @NotNull
    public final State<Boolean> getCreatorCodeValid() {
        return this.creatorCodeValid;
    }

    @Override
    public void onConnected() {
        this.resetState();
        CoinsManager.refreshCoins$default(this, 0L, 1, null);
        CoinsManager.refreshCurrencies$default(this, 0L, 1, null);
        this.refreshPricing();
        CoinsManager.validateCode$default(this, this.creatorCode.get(), false, false, 4, null);
    }

    @Override
    public void resetState() {
        this.mutableCoins.set(0);
        this.mutableCoinsSpent.set(0);
    }

    public final void purchaseBundle(@NotNull CoinBundle bundle, @NotNull Function1<? super URI, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (this.purchaseRequestInProgress) {
            return;
        }
        this.purchaseRequestInProgress = true;
        String creatorCode2 = Intrinsics.areEqual((Object)this.creatorCodeValid.get(), (Object)true) ? this.creatorCode.get() : null;
        Packet packet = bundle.isSpecificAmount() ? (Packet)new ClientCheckoutDynamicCoinBundlePacket(bundle.getNumberOfCoins(), bundle.getCurrency(), creatorCode2) : (Packet)new ClientCheckoutCoinBundlePacket(bundle.getId(), bundle.getCurrency(), creatorCode2);
        this.connectionManager.send(packet, arg_0 -> CoinsManager.purchaseBundle$lambda$0(this, callback, creatorCode2, arg_0));
    }

    public final void refreshPricing() {
        this.refreshPricing(this.currency.get());
    }

    private final void refreshCoins(long retryDelay) {
        this.connectionManager.send(new ClientCoinsBalancePacket(), arg_0 -> CoinsManager.refreshCoins$lambda$2(retryDelay, this, arg_0));
    }

    static /* synthetic */ void refreshCoins$default(CoinsManager coinsManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        coinsManager.refreshCoins(l);
    }

    private final void refreshCurrencies(long retryDelay) {
        this.connectionManager.send(new ClientCurrencyOptionsPacket(), arg_0 -> CoinsManager.refreshCurrencies$lambda$4(this, retryDelay, arg_0));
    }

    static /* synthetic */ void refreshCurrencies$default(CoinsManager coinsManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        coinsManager.refreshCurrencies(l);
    }

    private final void validateCode(String code, boolean debounce, boolean force) {
        if (!this.connectionManager.isOpen()) {
            return;
        }
        CharSequence charSequence = code;
        if (charSequence == null || charSequence.length() == 0 || !force && ((Map)this.checkedCreatorCodes.get()).containsKey(code)) {
            return;
        }
        ++this.currentCodeValidationTaskId;
        int taskId = this.currentCodeValidationTaskId;
        if (debounce) {
            Multithreading.scheduleOnMainThread(() -> CoinsManager.validateCode$lambda$5(taskId, this, code, force), 500L, TimeUnit.MILLISECONDS);
            return;
        }
        this.connectionManager.send(new ClientCheckoutPartnerCodeRequestDataPacket(code), arg_0 -> CoinsManager.validateCode$lambda$6(this, code, arg_0));
    }

    static /* synthetic */ void validateCode$default(CoinsManager coinsManager, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        coinsManager.validateCode(string, bl, bl2);
    }

    private final void refreshPricing(Currency currency2) {
        if (!this.connectionManager.isOpen()) {
            return;
        }
        if (currency2 == null) {
            return;
        }
        this.connectionManager.send(new ClientCoinBundleOptionsPacket(currency2), arg_0 -> CoinsManager.refreshPricing$lambda$8(this, currency2, arg_0));
    }

    public final void onBalanceUpdate(int coins, int coinsSpent, @Nullable Integer topUpAmount) {
        if (topUpAmount != null) {
            if (!this.isClaimingCoins) {
                GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)new Function1<ModalManager, Modal>(this, topUpAmount, coins){
                    final /* synthetic */ CoinsManager this$0;
                    final /* synthetic */ Integer $topUpAmount;
                    final /* synthetic */ int $coins;
                    {
                        this.this$0 = $receiver;
                        this.$topUpAmount = $topUpAmount;
                        this.$coins = $coins;
                        super(1);
                    }

                    @NotNull
                    public final Modal invoke(@NotNull ModalManager manager) {
                        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                        CoinsReceivedModal coinsReceivedModal = CoinsReceivedModal.Companion.fromPurchase(manager, this.this$0, this.$topUpAmount);
                        CoinsManager coinsManager = this.this$0;
                        int n = this.$coins;
                        CoinsReceivedModal $this$invoke_u24lambda_u240 = coinsReceivedModal;
                        boolean bl = false;
                        CoinsManager.access$getMutableCoins$p(coinsManager).set(n);
                        return coinsReceivedModal;
                    }
                }));
            } else {
                this.isClaimingCoins = false;
                this.mutableCoins.set(coins);
            }
        } else {
            this.mutableCoins.set(coins);
        }
        this.mutableCoinsSpent.set(coinsSpent);
    }

    public final void onCreatorCodeData(@NotNull String code, @NotNull String name2, boolean persist) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.checkedCreatorCodes.set((Map<String, String>)((Function1)new Function1<Map<String, ? extends String>, Map<String, ? extends String>>(code, name2){
            final /* synthetic */ String $code;
            final /* synthetic */ String $name;
            {
                this.$code = $code;
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Map<String, String> invoke(@NotNull Map<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return MapsKt.plus(it, (Pair)new Pair((Object)this.$code, (Object)this.$name));
            }
        }));
        if (persist) {
            this.creatorCodeConfigured.set(code);
        } else {
            this.creatorCodeNonPersistent.set(code);
        }
    }

    public final void tryClaimingWelcomeCoins() {
        if (((Number)this.coins.get()).intValue() != 0 || ((Number)this.coinsSpent.get()).intValue() != 0) {
            return;
        }
        this.isClaimingCoins = true;
        this.areCoinsVisuallyFrozen.set(true);
        this.connectionManager.send(new ClientCheckoutClaimCoinsPacket("WARDROBE_REFRESH"), arg_0 -> CoinsManager.tryClaimingWelcomeCoins$lambda$9(this, arg_0));
    }

    private static final void purchaseBundle$lambda$0(CoinsManager this$0, Function1 $callback, String $creatorCode, Optional maybeResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        this$0.purchaseRequestInProgress = false;
        Packet responsePacket = maybeResponse.orElse(null);
        if (responsePacket instanceof ServerCheckoutUrlPacket) {
            $callback.invoke((Object)new URI(((ServerCheckoutUrlPacket)responsePacket).getUrl()));
        } else {
            HelpersKt.sendCheckoutFailedNotification();
            if ($creatorCode != null) {
                this$0.validateCode($creatorCode, false, true);
            }
        }
    }

    private static final void refreshCoins$lambda$2$lambda$1(CoinsManager this$0, long $retryDelay) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.refreshCoins($retryDelay * (long)2);
    }

    private static final void refreshCoins$lambda$2(long $retryDelay, CoinsManager this$0, Optional maybeResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Packet responsePacket = maybeResponse.orElse(null);
        if (!(responsePacket instanceof ServerCoinsBalancePacket)) {
            Multithreading.scheduleOnMainThread(() -> CoinsManager.refreshCoins$lambda$2$lambda$1(this$0, $retryDelay), $retryDelay, TimeUnit.SECONDS);
        }
    }

    private static final void refreshCurrencies$lambda$4$lambda$3(CoinsManager this$0, long $retryDelay) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.refreshCurrencies($retryDelay * (long)2);
    }

    private static final void refreshCurrencies$lambda$4(CoinsManager this$0, long $retryDelay, Optional maybeResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Packet responsePacket = maybeResponse.orElse(null);
        if (responsePacket instanceof ServerCurrencyOptionsPacket) {
            MutableState mutableState2 = this$0.mutableCurrencies;
            Set<Currency> set2 = ((ServerCurrencyOptionsPacket)responsePacket).getCurrencies();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getCurrencies(...)");
            SetKt.setAll(mutableState2, set2);
        } else {
            Multithreading.scheduleOnMainThread(() -> CoinsManager.refreshCurrencies$lambda$4$lambda$3(this$0, $retryDelay), $retryDelay, TimeUnit.SECONDS);
        }
    }

    private static final void validateCode$lambda$5(int $taskId, CoinsManager this$0, String $code, boolean $force) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($taskId != this$0.currentCodeValidationTaskId) {
            return;
        }
        this$0.validateCode($code, false, $force);
    }

    private static final void validateCode$lambda$6(CoinsManager this$0, String $code, Optional maybeResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Packet responsePacket = maybeResponse.orElse(null);
        if (responsePacket instanceof ServerCheckoutPartnerCodeDataPacket) {
            return;
        }
        if (responsePacket instanceof ResponseActionPacket && ((ResponseActionPacket)responsePacket).getErrorMessage() == null) {
            this$0.checkedCreatorCodes.set((Map<String, String>)((Function1)new Function1<Map<String, ? extends String>, Map<String, ? extends String>>($code){
                final /* synthetic */ String $code;
                {
                    this.$code = $code;
                    super(1);
                }

                @NotNull
                public final Map<String, String> invoke(@NotNull Map<String, String> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return MapsKt.plus(it, (Pair)new Pair((Object)this.$code, null));
                }
            }));
        } else {
            Notifications.INSTANCE.push("Error validating creator code", "An unexpected error has occurred. Try again.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void refreshPricing$lambda$8(CoinsManager this$0, Currency $currency, Optional maybeResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Packet responsePacket = maybeResponse.orElse(null);
        if (responsePacket instanceof ServerCoinBundleOptionsPacket) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            MutableState mutableState2 = this$0.mutablePricing;
            List<gg.essential.coins.model.CoinBundle> list = ((ServerCoinBundleOptionsPacket)responsePacket).getCoinBundles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCoinBundles(...)");
            Iterable iterable = list;
            MutableState mutableState3 = mutableState2;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                gg.essential.coins.model.CoinBundle coinBundle = (gg.essential.coins.model.CoinBundle)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ConversionsKt.toMod((gg.essential.coins.model.CoinBundle)it, $currency));
            }
            ListKt.setAll(mutableState3, (List)destination$iv$iv);
        } else {
            Notifications.INSTANCE.push("Error obtaining coin bundles", "An unexpected error has occurred. Try again.");
        }
    }

    private static final void tryClaimingWelcomeCoins$lambda$9(CoinsManager this$0, Optional optionalPacket) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Packet packet = optionalPacket.orElse(null);
        if (packet instanceof ServerCheckoutClaimCoinsResponsePacket) {
            GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)new Function1<ModalManager, Modal>(this$0, packet){
                final /* synthetic */ CoinsManager this$0;
                final /* synthetic */ Packet $packet;
                {
                    this.this$0 = $receiver;
                    this.$packet = $packet;
                    super(1);
                }

                @NotNull
                public final Modal invoke(@NotNull ModalManager it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CoinsReceivedModal.Companion.fromCoinClaim(it, this.this$0, ((ServerCheckoutClaimCoinsResponsePacket)this.$packet).getCoinsClaimed());
                }
            }));
            return;
        }
        if (!(packet instanceof ResponseActionPacket) || ((ResponseActionPacket)packet).getErrorMessage() == null) {
            Essential.debug.error("ClientCheckoutClaimCoinsPacket gave invalid response!");
        }
        this$0.areCoinsVisuallyFrozen.set(false);
        this$0.isClaimingCoins = false;
    }

    public static final /* synthetic */ MutableState access$getMutableCoins$p(CoinsManager $this) {
        return $this.mutableCoins;
    }

    public static final /* synthetic */ MutableState access$getCreatorCodeNonPersistent$p(CoinsManager $this) {
        return $this.creatorCodeNonPersistent;
    }

    public static final /* synthetic */ MutableState access$getCheckedCreatorCodes$p(CoinsManager $this) {
        return $this.checkedCreatorCodes;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgg/essential/network/connectionmanager/coins/CoinsManager$Companion;", "", "<init>", "()V", "Ljava/text/DecimalFormat;", "COIN_FORMAT", "Ljava/text/DecimalFormat;", "getCOIN_FORMAT", "()Ljava/text/DecimalFormat;", "Essential 1.19.2-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DecimalFormat getCOIN_FORMAT() {
            return COIN_FORMAT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

