/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler;

import com.sparkuniverse.toolbox.util.Validate;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.network.connectionmanager.ConnectionManager;
import org.jetbrains.annotations.NotNull;

public abstract class PacketHandler<IP extends Packet> {
    protected boolean requiresAuthentication;

    public PacketHandler() {
        this(true);
    }

    public PacketHandler(boolean requiresAuthentication) {
        this.requiresAuthentication = requiresAuthentication;
    }

    public Runnable handleAsync(@NotNull ConnectionManager connectionManager, @NotNull IP packet) {
        Validate.isTrue(connectionManager.isOpen(), () -> "Attempted to handle a Packet when the Connection Manager Connection was closed ('" + packet + "').", new Object[0]);
        return () -> {
            if (this.requiresAuthentication && !connectionManager.isAuthenticated()) {
                return;
            }
            this.onHandle(connectionManager, packet);
        };
    }

    protected abstract void onHandle(@NotNull ConnectionManager var1, @NotNull IP var2);
}

