/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gg.essential.connectionmanager.common.packet.ice.IceCandidatePacket;
import gg.essential.connectionmanager.common.packet.ice.IceSessionPacket;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.modal.sps.FirewallBlockingModal;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.IceProcessingState;
import gg.essential.lib.ice4j.ice.KeepAliveStrategy;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.NominationStrategy;
import gg.essential.lib.ice4j.ice.RemoteCandidate;
import gg.essential.lib.ice4j.ice.harvest.StunCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.TrickleCallback;
import gg.essential.lib.ice4j.ice.harvest.TurnCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.UPNPHarvester;
import gg.essential.lib.ice4j.pseudotcp.PseudoTcpSocket;
import gg.essential.lib.ice4j.pseudotcp.PseudoTcpSocketFactory;
import gg.essential.lib.ice4j.socket.MultiplexedDatagramSocket;
import gg.essential.lib.ice4j.socket.MultiplexingDatagramSocket;
import gg.essential.lib.ice4j.socket.SocketClosedException;
import gg.essential.lib.jitsi.utils.logging2.LoggerImpl;
import gg.essential.mixins.ext.network.NetworkSystemExtKt;
import gg.essential.mixins.impl.feature.ice.common.AgentExt;
import gg.essential.mixins.impl.feature.ice.common.MergingDatagramSocketExt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.ice.IIceManager;
import gg.essential.network.connectionmanager.ice.Log4jAsJulLogger;
import gg.essential.network.connectionmanager.ice.NominateBestRTT;
import gg.essential.network.connectionmanager.ice.handler.IceCandidatePacketHandler;
import gg.essential.network.connectionmanager.ice.handler.IceSessionPacketHandler;
import gg.essential.network.connectionmanager.ice.netty.CloseAfterFirstMessage;
import gg.essential.network.connectionmanager.ice.netty.PseudoTcpChannelInitializer;
import gg.essential.network.connectionmanager.ice.netty.QuicStreamChannelInitializer;
import gg.essential.network.connectionmanager.ice.util.CandidateUtil;
import gg.essential.network.connectionmanager.sps.SPSConnectionTelemetry;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.quic.LogOnce;
import gg.essential.sps.ResourcePackSharingHttpServer;
import gg.essential.sps.quic.QuicStream;
import gg.essential.sps.quic.jvm.ForkedJvmClientQuicStream;
import gg.essential.sps.quic.jvm.ForkedJvmServerQuicStreamPool;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.FirewallUtil;
import gg.essential.util.GuiUtil;
import gg.essential.util.Multithreading;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class IceManager
implements NetworkedManager,
IIceManager {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(IceManager.class);
    public static final Lazy<EventLoopGroup> ICE_SERVER_EVENT_LOOP_GROUP = LazyKt.lazy(() -> IceManager.makeIceEventLoopGroup(true));
    public static final Lazy<EventLoopGroup> ICE_CLIENT_EVENT_LOOP_GROUP = LazyKt.lazy(() -> IceManager.makeIceEventLoopGroup(false));
    private static final ForkedJvmServerQuicStreamPool QUIC_SERVER_POOL = new ForkedJvmServerQuicStreamPool();
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final Map<UUID, IceConnection> connections = new ConcurrentHashMap<UUID, IceConnection>();
    private int integratedServerVoicePort;
    private Integer proxyHttpPort;

    private static EventLoopGroup makeIceEventLoopGroup(boolean server) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Netty " + (server ? "Server" : "Client") + " IO ICE #%d").setDaemon(true).setThreadFactory((ThreadFactory)(server ? SidedThreadGroups.SERVER : SidedThreadGroups.CLIENT)).build();
        return new DefaultEventLoopGroup(0, threadFactory);
    }

    private static void bypassSocketLimit() {
        if (System.getSecurityManager() == null) {
            LOGGER.debug("No security manager installed, no need to bypass datagram socket limit.");
            return;
        }
        try {
            Class<?> resourceManagerClass = Class.forName("sun.net.ResourceManager");
            Field numSocketsField = resourceManagerClass.getDeclaredField("numSockets");
            numSocketsField.setAccessible(true);
            AtomicInteger numSockets = (AtomicInteger)numSocketsField.get(null);
            numSockets.addAndGet(-1000);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to bypass datagram socket limit:", t);
        }
    }

    public IceManager(@NotNull ConnectionManager connectionManager, @NotNull SPSManager spsManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(IceSessionPacket.class, new IceSessionPacketHandler(this, spsManager));
        connectionManager.registerPacketHandler(IceCandidatePacket.class, new IceCandidatePacketHandler(this));
    }

    public IceConnection getConnection(UUID remote) {
        return this.connections.get(remote);
    }

    @Override
    public void setVoicePort(int voicePort) {
        this.integratedServerVoicePort = voicePort;
    }

    @Override
    public Integer getProxyHttpPort() {
        return this.proxyHttpPort;
    }

    private Agent createAgent(UUID user, boolean client) {
        Object flags2;
        Object object = flags2 = SUPPORTS_QUIC ? "q" : "";
        if (!client) {
            flags2 = (String)flags2 + "v" + this.integratedServerVoicePort;
        }
        Agent agent = new Agent("essential-" + (String)flags2 + "-", new LoggerImpl("ice4j-" + user));
        agent.setTrickling(true);
        agent.setControlling(client);
        if (!Boolean.getBoolean("essential.sps.legacy-nomination")) {
            agent.setNominationStrategy(NominationStrategy.NONE);
            agent.addStateChangeListener(new NominateBestRTT());
        } else {
            agent.setNominationStrategy(NominationStrategy.NOMINATE_FIRST_HOST_OR_REFLEXIVE_VALID);
        }
        for (String stunHost : STUN_HOSTS) {
            agent.addCandidateHarvester(new StunCandidateHarvester(new TransportAddress(stunHost, 3478, Transport.UDP)));
        }
        agent.addCandidateHarvester(new UPNPHarvester());
        for (String turnHost : TURN_HOSTS) {
            agent.addCandidateHarvester(new TurnCandidateHarvester(new TransportAddress(turnHost, 3478, Transport.UDP)));
        }
        return agent;
    }

    private Component createComponent(Agent agent, IceMediaStream mediaStream) {
        try {
            return agent.createComponent(mediaStream, KeepAliveStrategy.SELECTED_ONLY, true);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create component:", (Throwable)e);
            return null;
        }
    }

    private PseudoTcpSocket createPseudoTcpSocket(DatagramSocket datagramSocket) throws IOException {
        try {
            return new PseudoTcpSocketFactory().createSocket(datagramSocket);
        }
        catch (SocketException e) {
            LOGGER.error("Failed to create ICE pseudo tcp socket:", (Throwable)e);
            throw new IOException("ICE setup failed. Contact support.");
        }
    }

    private IceConnection setupAgent(UUID user, boolean client, Consumer<IceMediaStream> configureMediaStream) {
        Agent agent = this.createAgent(user, client);
        IceMediaStream mediaStream = agent.createMediaStream("minecraft");
        configureMediaStream.accept(mediaStream);
        Component component3 = this.createComponent(agent, mediaStream);
        if (component3 == null) {
            IceManager.freeSafely(agent);
            return null;
        }
        IceConnection connection = new IceConnection(client, agent, mediaStream, component3);
        IceConnection oldConnection = this.connections.put(user, connection);
        if (oldConnection != null) {
            IceManager.freeSafely(oldConnection.agent);
        }
        this.connectionManager.send(new IceSessionPacket(user, agent.getLocalUfrag(), agent.getLocalPassword()));
        Multithreading.getScheduledPool().execute(() -> {
            TrickleCallback trickleCallback = candidates -> {
                if (candidates == null) {
                    this.connectionManager.send(new IceCandidatePacket(user, null));
                    return;
                }
                for (LocalCandidate candidate2 : candidates) {
                    String str = CandidateUtil.candidateToString(candidate2);
                    LOGGER.debug("New local candidate for {}: {}", (Object)user, (Object)str);
                    this.connectionManager.send(new IceCandidatePacket(user, str));
                }
            };
            trickleCallback.onIceCandidates(component3.getLocalCandidates());
            agent.startCandidateTrickle(trickleCallback);
        });
        return connection;
    }

    @Override
    public SocketAddress createClientAgent(UUID user) throws IOException {
        ChannelInitializer channelInitializer;
        LOGGER.debug("Creating client-side ICE agent for {}", (Object)user);
        while (FirewallUtil.INSTANCE.isFirewallBlocking()) {
            CompletableFuture retry = new CompletableFuture();
            GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)manager -> new FirewallBlockingModal((ModalManager)manager, user, (Function1<? super Modal, Unit>)((Function1)_manager -> {
                retry.complete(false);
                return Unit.INSTANCE;
            }), (Function1<? super Modal, Unit>)((Function1)_manager -> {
                retry.complete(true);
                return Unit.INSTANCE;
            }))));
            if (((Boolean)retry.join()).booleanValue()) continue;
            throw new IOException("ICE setup failed - Firewall enabled");
        }
        IceConnection connection = this.setupAgent(user, true, mediaStream -> {});
        if (connection == null) {
            throw new IOException("ICE setup failed. Contact support.");
        }
        try {
            connection.iceReadyFuture.join();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
        try {
            TransportAddress remoteAddress = connection.getSelectedRemoteAddress();
            MultiplexingDatagramSocket iceSocket = connection.component.getSocket();
            iceSocket.connect(remoteAddress.getAddress(), remoteAddress.getPort());
            this.setupVoiceMultiplexing(iceSocket, false, connection.getVoicePort());
            if (connection.isQuic()) {
                ForkedJvmClientQuicStream quicStream = new ForkedJvmClientQuicStream(iceSocket);
                channelInitializer = new QuicStreamChannelInitializer(quicStream, user);
                this.proxyHttpPort = quicStream.getHttpPort();
            } else {
                PseudoTcpSocket tcpSocket = this.createPseudoTcpSocket(iceSocket);
                tcpSocket.connect(remoteAddress, TCP_TIMEOUT);
                channelInitializer = new PseudoTcpChannelInitializer(tcpSocket, user);
                this.proxyHttpPort = null;
            }
        }
        catch (IOException e) {
            IceManager.freeSafely(connection.agent);
            throw e;
        }
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).handler((ChannelHandler)new CloseAfterFirstMessage())).childHandler((ChannelHandler)channelInitializer).group((EventLoopGroup)ICE_CLIENT_EVENT_LOOP_GROUP.getValue()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly().channel().localAddress();
    }

    public void createServerAgent(UUID user, String ufrag, String password) {
        LOGGER.debug("Creating server-side ICE agent at request from {} (ufrag: {}, pwd: {})", (Object)user, (Object)ufrag, (Object)password);
        IceConnection connection = this.setupAgent(user, false, mediaStream -> {
            mediaStream.setRemoteUfrag(ufrag);
            mediaStream.setRemotePassword(password);
        });
        if (connection == null) {
            return;
        }
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        if (server == null) {
            LOGGER.error("Tried to register ICE socket but server was not running!");
            IceManager.freeSafely(connection.agent);
            return;
        }
        connection.startConnectivityChecks();
        ExtensionsKt.logExceptions(((CompletableFuture)connection.iceReadyFuture.thenComposeAsync(__ -> {
            CompletableFuture<ChannelInitializer> future2 = new CompletableFuture<ChannelInitializer>();
            try {
                CandidatePair selectedPair = connection.component.getSelectedPair();
                boolean relayed = selectedPair.getLocalCandidate().getType() == CandidateType.RELAYED_CANDIDATE || selectedPair.getRemoteCandidate().getType() == CandidateType.RELAYED_CANDIDATE;
                ((MergingDatagramSocketExt)((Object)connection.component.getComponentSocket())).essential$setConnectionTelemetry(new SPSConnectionTelemetry(user, this.connectionManager.getSpsManager().getSessionId(), relayed));
                TransportAddress remoteAddress = connection.getSelectedRemoteAddress();
                MultiplexingDatagramSocket iceSocket = connection.component.getSocket();
                iceSocket.connect(remoteAddress.getAddress(), remoteAddress.getPort());
                this.setupVoiceMultiplexing(iceSocket, true, this.integratedServerVoicePort);
                int httpPort = 9;
                Integer maybeHttpPort = ResourcePackSharingHttpServer.INSTANCE.getPort();
                if (maybeHttpPort != null) {
                    httpPort = maybeHttpPort;
                }
                if (connection.isQuic()) {
                    QuicStream quicStream = QUIC_SERVER_POOL.accept(iceSocket, httpPort);
                    future2.complete(new QuicStreamChannelInitializer(quicStream, user));
                } else {
                    PseudoTcpSocket tcpSocket = this.createPseudoTcpSocket(iceSocket);
                    tcpSocket.accept(remoteAddress, TCP_TIMEOUT);
                    future2.complete(new PseudoTcpChannelInitializer(tcpSocket, user));
                }
            }
            catch (Exception e) {
                future2.completeExceptionally(e);
            }
            return future2;
        }, (Executor)ICE_SERVER_EVENT_LOOP_GROUP.getValue())).thenAcceptAsync(channelInitializer -> {
            SocketAddress iceEndpoint = NetworkSystemExtKt.getIceEndpoint(server.m_129919_());
            ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)ICE_SERVER_EVENT_LOOP_GROUP.getValue())).handler((ChannelHandler)channelInitializer)).channel(LocalChannel.class)).connect(iceEndpoint);
        }, (Executor)ExtensionsKt.getExecutor((MinecraftServer)server)));
    }

    private void setupVoiceMultiplexing(MultiplexingDatagramSocket iceSocket, boolean server, int voicePort) throws SocketException {
        AtomicReference<Object> remoteAddress;
        DatagramSocket realVoiceSocket;
        if (server) {
            realVoiceSocket = new DatagramSocket(0);
            remoteAddress = new AtomicReference<InetSocketAddress>(new InetSocketAddress(InetAddress.getLoopbackAddress(), voicePort));
        } else {
            try {
                realVoiceSocket = new DatagramSocket(voicePort);
            }
            catch (SocketException e) {
                LOGGER.error("Failed to allocate port for voice chat forwarding:", (Throwable)e);
                return;
            }
            remoteAddress = new AtomicReference<Object>(null);
        }
        LogOnce debugOnce = LogOnce.to(arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).debug(arg_0));
        MultiplexedDatagramSocket iceVoiceSocket = iceSocket.getSocket(datagramPacket -> {
            byte[] data = datagramPacket.getData();
            return data.length >= 1 && data[0] == VOICE_HEADER_BYTE;
        });
        Thread inboundThread = new Thread(() -> {
            block9: {
                try (DatagramSocket _realVoiceSocket = realVoiceSocket;){
                    while (!iceVoiceSocket.isClosed() && !realVoiceSocket.isClosed()) {
                        byte[] buf = new byte[65535];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        iceVoiceSocket.receive(packet);
                        debugOnce.log("inbound", packet.getLength());
                        packet.setData(buf, 1, packet.getLength() - 1);
                        packet.setSocketAddress((SocketAddress)remoteAddress.get());
                        realVoiceSocket.send(packet);
                    }
                }
                catch (IOException e) {
                    debugOnce.log("inboundException", e);
                    if (iceVoiceSocket.isClosed() || realVoiceSocket.isClosed() || e instanceof PortUnreachableException || e instanceof SocketClosedException) break block9;
                    e.printStackTrace();
                }
            }
        }, "ice voice inbound");
        inboundThread.setDaemon(true);
        inboundThread.start();
        Thread outboundThread = new Thread(() -> {
            block4: {
                try {
                    while (!iceVoiceSocket.isClosed() && !realVoiceSocket.isClosed()) {
                        byte[] buf = new byte[65535];
                        DatagramPacket packet = new DatagramPacket(buf, 1, buf.length - 1);
                        realVoiceSocket.receive(packet);
                        debugOnce.log("outbound", packet.getLength());
                        if (!server) {
                            remoteAddress.set(packet.getSocketAddress());
                        }
                        buf[0] = VOICE_HEADER_BYTE;
                        packet.setData(buf, 0, packet.getLength() + 1);
                        packet.setSocketAddress(iceVoiceSocket.getRemoteSocketAddress());
                        iceVoiceSocket.send(packet);
                    }
                }
                catch (IOException e) {
                    debugOnce.log("outboundException", e);
                    if (iceVoiceSocket.isClosed() || realVoiceSocket.isClosed() || e instanceof PortUnreachableException || e instanceof SocketClosedException) break block4;
                    e.printStackTrace();
                }
            }
        }, "ice voice outbound");
        outboundThread.setDaemon(true);
        outboundThread.start();
    }

    public void addRemoteCandidate(UUID user, String candidateStr) {
        LOGGER.debug("New remote candidate from {}: {}", (Object)user, (Object)candidateStr);
        IceConnection connection = this.connections.get(user);
        if (connection == null) {
            LOGGER.debug("Ignoring candidate from {} because they have no active session.", (Object)user);
            return;
        }
        if (candidateStr == null) {
            ((AgentExt)((Object)connection.agent)).setRemoteTricklingDone();
            return;
        }
        RemoteCandidate candidate2 = CandidateUtil.candidateFromString(candidateStr, connection.component);
        if (candidate2 == null) {
            return;
        }
        Multithreading.runAsync(() -> {
            connection.component.addUpdateRemoteCandidates(candidate2);
            connection.component.updateRemoteCandidates();
        });
    }

    private static void freeSafely(Agent agent) {
        try {
            agent.free();
        }
        catch (Exception e) {
            LOGGER.error("Error while freeing ICE agent:", (Throwable)e);
        }
    }

    static {
        IceManager.bypassSocketLimit();
        try {
            Function<String, Logger> loggerFactory = Log4jAsJulLogger::new;
            Field loggerFactoryField = LoggerImpl.class.getDeclaredField("loggerFactory");
            loggerFactoryField.setAccessible(true);
            loggerFactoryField.set(null, loggerFactory);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (System.getProperty("gg.essential.lib.ice4j.MAX_CTRAN_RETRANS_TIMER") == null) {
            System.setProperty("gg.essential.lib.ice4j.MAX_CTRAN_RETRANS_TIMER", String.valueOf(1600));
        }
        if (System.getProperty("gg.essential.lib.ice4j.MAX_RETRANSMISSIONS") == null) {
            System.setProperty("gg.essential.lib.ice4j.MAX_RETRANSMISSIONS", String.valueOf(6));
        }
    }

    public static class IceConnection {
        private final Agent agent;
        private final IceMediaStream mediaStream;
        private final Component component;
        private final CompletableFuture<Void> iceReadyFuture;
        private boolean needsRemoteCredentials;

        public IceConnection(boolean client, Agent agent, IceMediaStream mediaStream, Component component3) {
            this.agent = agent;
            this.mediaStream = mediaStream;
            this.component = component3;
            this.iceReadyFuture = IceConnection.createReadyFuture(agent, client);
            this.needsRemoteCredentials = client;
        }

        public void setRemoteCredentials(String ufrag, String password) {
            if (!this.needsRemoteCredentials) {
                return;
            }
            this.needsRemoteCredentials = false;
            this.mediaStream.setRemoteUfrag(ufrag);
            this.mediaStream.setRemotePassword(password);
            this.startConnectivityChecks();
        }

        public void startConnectivityChecks() {
            Multithreading.getScheduledPool().execute(this.agent::startConnectivityEstablishment);
        }

        public TransportAddress getSelectedRemoteAddress() {
            CandidatePair selectedPair = this.component.getSelectedPair();
            if (selectedPair == null) {
                throw new IllegalStateException("No candidate pair selected");
            }
            return selectedPair.getRemoteCandidate().getTransportAddress();
        }

        private static CompletableFuture<Void> createReadyFuture(Agent agent, boolean client) {
            CompletableFuture<Void> future2 = new CompletableFuture<Void>();
            Multithreading.scheduleOnBackgroundThread(() -> future2.completeExceptionally(new IceFailedException(client)), IIceManager.ICE_TIMEOUT, TimeUnit.SECONDS);
            Runnable update2 = () -> {
                IceProcessingState state2 = agent.getState();
                if (state2.isEstablished()) {
                    future2.complete(null);
                } else if (state2.isOver()) {
                    future2.completeExceptionally(new IceFailedException(client));
                }
            };
            agent.addStateChangeListener(event -> update2.run());
            update2.run();
            future2.exceptionally(__ -> {
                IceManager.freeSafely(agent);
                return null;
            });
            return future2;
        }

        private Pair<String, String> getUfragFlags() {
            String localUfrag = this.agent.getLocalUfrag();
            String remoteUfrag = this.mediaStream.getRemoteUfrag();
            if (localUfrag == null || remoteUfrag == null) {
                LOGGER.warn("Ufrag missing?!");
                LOGGER.warn("localUfrag: {}", (Object)localUfrag);
                LOGGER.warn("remoteUfrag: {}", (Object)remoteUfrag);
                return new Pair((Object)"", (Object)"");
            }
            String[] localParts = localUfrag.split("-");
            String[] remoteParts = remoteUfrag.split("-");
            String localFlags = localParts.length > 2 ? localParts[1] : "";
            String remoteFlags = remoteParts.length > 2 ? remoteParts[1] : "";
            return new Pair((Object)localFlags, (Object)remoteFlags);
        }

        public boolean isQuic() {
            Pair<String, String> flags2 = this.getUfragFlags();
            boolean localSupport = ((String)flags2.getFirst()).contains("q");
            boolean remoteSupport = ((String)flags2.getSecond()).contains("q");
            if (localSupport && remoteSupport) {
                LOGGER.info("Using QUIC because both parties support it.");
                return true;
            }
            String who = localSupport ? "the remote client does" : (remoteSupport ? "the local client does" : "both sides do");
            LOGGER.warn("Not using QUIC (falling back to PseudoTCP) because {} not support it.", (Object)who);
            return false;
        }

        public int getVoicePort() {
            int endOffset;
            String flags2 = (String)this.getUfragFlags().getSecond();
            int offset2 = flags2.indexOf(118);
            if (offset2 == -1) {
                LOGGER.warn("Remote does not support voice tunneling.");
                return 0;
            }
            for (endOffset = offset2 + 1; endOffset < flags2.length() && Character.isDigit(flags2.charAt(endOffset)); ++endOffset) {
            }
            try {
                return Integer.parseInt(flags2.substring(offset2 + 1, endOffset));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Failed to parse remote voice port from \"" + flags2 + "\":", (Throwable)e);
                return 0;
            }
        }
    }

    private static class IceFailedException
    extends PrettyIOException {
        public IceFailedException(boolean client) {
            super((client ? "Server" : "Client") + " is unreachable (ICE failed)");
        }
    }

    private static class PrettyIOException
    extends IOException {
        public PrettyIOException(String message2) {
            super(message2);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }
}

