/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice;

import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.CandidatePairState;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.IceProcessingState;
import gg.essential.mixins.impl.feature.ice.common.AgentExt;
import gg.essential.mixins.impl.feature.ice.common.rtt.CandidatePairExt;
import gg.essential.util.Multithreading;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NominateBestRTT
implements PropertyChangeListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration WAIT_FOR_DIRECTS = Duration.of(Integer.getInteger("essential.sps.wait_for_directs", 10000).intValue(), ChronoUnit.MILLIS);
    private static final Duration WAIT_FOR_MORE_DIRECTS = Duration.of(Integer.getInteger("essential.sps.wait_for_more_directs", 3000).intValue(), ChronoUnit.MILLIS);
    private static final Duration RELAY_RTT_THRESHOLD = Duration.of(Integer.getInteger("essential.sps.relay_latency_threshold", 100).intValue(), ChronoUnit.MILLIS);
    private Instant firstDirect;
    private Instant firstRelay;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (source instanceof Agent) {
            if ("IceProcessingState".equals(propertyName)) {
                this.iceProcessingStateChange((Agent)source, (IceProcessingState)((Object)evt.getNewValue()));
            }
            if ("RemoteTricklingDone".equals(propertyName)) {
                Agent agent = (Agent)source;
                if (!agent.isControlling()) {
                    return;
                }
                for (IceMediaStream stream : agent.getStreams()) {
                    this.nominatePair(stream);
                }
            }
        }
        if (source instanceof CandidatePair) {
            if ("PairValidated".equals(propertyName)) {
                this.candidatePairStateChanged((CandidatePair)source);
            }
            if ("PairStateChanged".equals(propertyName) && evt.getNewValue() == CandidatePairState.FAILED) {
                this.candidatePairStateChanged((CandidatePair)source);
            }
        }
    }

    private void iceProcessingStateChange(Agent agent, IceProcessingState newState) {
        if (newState == IceProcessingState.RUNNING) {
            for (IceMediaStream stream : agent.getStreams()) {
                stream.addPairChangeListener(this);
            }
        }
    }

    private void candidatePairStateChanged(CandidatePair pair) {
        Component component3 = pair.getParentComponent();
        IceMediaStream stream = component3.getParentStream();
        if (!stream.getParentAgent().isControlling()) {
            return;
        }
        this.nominatePair(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nominatePair(IceMediaStream stream) {
        TreeSet<CandidatePair> allValidPairs;
        TreeSet<CandidatePair> treeSet = allValidPairs = this.getValidPairs(stream);
        synchronized (treeSet) {
            this.nominatePair(stream, allValidPairs);
        }
    }

    private synchronized void nominatePair(IceMediaStream stream, Set<CandidatePair> allValidPairs) {
        for (Component component3 : stream.getComponents()) {
            Collection validPairs = allValidPairs.stream().filter(it -> it.getParentComponent() == component3).collect(Collectors.toList());
            if (validPairs.stream().anyMatch(CandidatePair::isNominated)) continue;
            CandidatePair bestDirectPair = null;
            Duration bestDirectRtt = null;
            CandidatePair bestRelayPair = null;
            Duration bestRelayRtt = null;
            for (CandidatePair pair : allValidPairs) {
                boolean isRelay;
                Duration rtt = ((CandidatePairExt)((Object)pair)).getRtt();
                if (rtt == null) {
                    rtt = Duration.ofMinutes(1L);
                }
                boolean bl = isRelay = pair.getLocalCandidate().getType() == CandidateType.RELAYED_CANDIDATE || pair.getRemoteCandidate().getType() == CandidateType.RELAYED_CANDIDATE;
                if (isRelay) {
                    if (bestRelayRtt != null && bestRelayRtt.compareTo(rtt) <= 0) continue;
                    bestRelayRtt = rtt;
                    bestRelayPair = pair;
                    continue;
                }
                if (bestDirectRtt != null && bestDirectRtt.compareTo(rtt) <= 0) continue;
                bestDirectRtt = rtt;
                bestDirectPair = pair;
            }
            if (bestDirectPair == null && bestRelayPair == null) continue;
            if (bestDirectPair != null && this.firstDirect == null) {
                this.firstDirect = Instant.now();
                Multithreading.getScheduledPool().schedule(() -> this.nominatePair(stream), WAIT_FOR_MORE_DIRECTS.toNanos(), TimeUnit.NANOSECONDS);
            }
            if (bestRelayPair != null && this.firstRelay == null) {
                this.firstRelay = Instant.now();
                Multithreading.getScheduledPool().schedule(() -> this.nominatePair(stream), WAIT_FOR_DIRECTS.toNanos(), TimeUnit.NANOSECONDS);
            }
            if (!stream.getCheckList().allChecksCompleted() || !((AgentExt)((Object)stream.getParentAgent())).isRemoteTricklingDone()) {
                if (this.firstDirect == null) {
                    if (Instant.now().isBefore(this.firstRelay.plus(WAIT_FOR_DIRECTS))) continue;
                    LOGGER.info("Waited {}ms for direct candidate pairs to no avail, going ahead with nomination..", (Object)WAIT_FOR_DIRECTS.toMillis());
                } else {
                    if (Instant.now().isBefore(this.firstDirect.plus(WAIT_FOR_MORE_DIRECTS))) continue;
                    LOGGER.info("Waited {}ms for more direct candidates, going ahead with nomination..", (Object)WAIT_FOR_MORE_DIRECTS.toMillis());
                }
            } else {
                LOGGER.info("All checks have been completed, going ahead with nomination..");
            }
            CandidatePair nominatedPair = bestDirectPair == null ? bestRelayPair : (bestRelayPair == null ? bestDirectPair : (bestRelayRtt.plus(RELAY_RTT_THRESHOLD).compareTo(bestDirectRtt) < 0 ? bestRelayPair : bestDirectPair));
            LOGGER.info("Nominate (best rtt): {}", (Object)this.toShortString(nominatedPair));
            for (CandidatePair pair : validPairs) {
                String extra = "";
                if (pair == bestDirectPair) {
                    extra = " (best direct RTT)";
                } else if (pair == bestRelayPair) {
                    extra = " (best relay RTT)";
                }
                LOGGER.info(" {} {}{}", (Object)(pair == nominatedPair ? "*" : " "), (Object)this.toShortString(pair), (Object)extra);
            }
            stream.getParentAgent().nominate(nominatedPair);
        }
    }

    private String toShortString(CandidatePair pair) {
        if (pair == null) {
            return "null";
        }
        Duration rtt = ((CandidatePairExt)((Object)pair)).getRtt();
        return MessageFormat.format("{0} -> {1} ({2}ms RTT)", pair.getLocalCandidate().toShortString(), pair.getRemoteCandidate().toShortString(), rtt == null ? "?" : Long.valueOf(rtt.toMillis()));
    }

    private TreeSet<CandidatePair> getValidPairs(IceMediaStream stream) {
        try {
            Field field2 = IceMediaStream.class.getDeclaredField("validList");
            field2.setAccessible(true);
            return (TreeSet)field2.get(stream);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

