/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice.handler;

import gg.essential.connectionmanager.common.packet.ice.IceSessionPacket;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.ice.IceManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.upnp.model.UPnPSession;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class IceSessionPacketHandler
extends PacketHandler<IceSessionPacket> {
    @NotNull
    private final IceManager iceManager;
    @NotNull
    private final SPSManager spsManager;

    public IceSessionPacketHandler(@NotNull IceManager iceManager, @NotNull SPSManager spsManager) {
        this.iceManager = iceManager;
        this.spsManager = spsManager;
    }

    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull IceSessionPacket packet) {
        UUID user = packet.getUser();
        UPnPSession localSession = this.spsManager.getLocalSession();
        if (localSession != null) {
            if (!localSession.getInvites().contains(user)) {
                return;
            }
            this.iceManager.createServerAgent(user, packet.getUfrag(), packet.getPassword());
        } else {
            IceManager.IceConnection connection = this.iceManager.getConnection(user);
            if (connection == null) {
                return;
            }
            connection.setRemoteCredentials(packet.getUfrag(), packet.getPassword());
        }
    }
}

