/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.notices;

import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.api.gui.NotificationBuilder;
import gg.essential.event.gui.GuiOpenEvent;
import gg.essential.gui.notification.Notifications;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.connectionmanager.notices.NoticesManager;
import gg.essential.network.connectionmanager.notices.PersistentToastNoticeListener;
import gg.essential.network.connectionmanager.telemetry.TelemetryManager;
import gg.essential.notices.NoticeType;
import gg.essential.notices.model.Notice;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.Multithreading;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0011\u0010\nJ\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\nJ\u000f\u0010\u0013\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\nR&\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00170\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR&\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00170\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0019\u00a8\u0006 "}, d2={"Lgg/essential/network/connectionmanager/notices/PersistentToastNoticeListener;", "Lgg/essential/network/connectionmanager/notices/NoticesManager$NoticeListener;", "Lgg/essential/network/connectionmanager/notices/NoticesManager;", "noticesManager", "<init>", "(Lgg/essential/network/connectionmanager/notices/NoticesManager;)V", "Lgg/essential/notices/model/Notice;", "notice", "", "dismissToast", "(Lgg/essential/notices/model/Notice;)V", "Lgg/essential/event/gui/GuiOpenEvent;", "event", "guiOpenEvent", "(Lgg/essential/event/gui/GuiOpenEvent;)V", "hideAllToasts", "()V", "noticeAdded", "noticeRemoved", "onConnect", "pushNoticeToast", "", "", "Lkotlin/Function0;", "actions", "Ljava/util/Map;", "", "notices", "Ljava/util/Set;", "Lgg/essential/network/connectionmanager/notices/NoticesManager;", "", "pushedToasts", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nPersistentToastNoticeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentToastNoticeListener.kt\ngg/essential/network/connectionmanager/notices/PersistentToastNoticeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1855#2,2:139\n1855#2,2:141\n*S KotlinDebug\n*F\n+ 1 PersistentToastNoticeListener.kt\ngg/essential/network/connectionmanager/notices/PersistentToastNoticeListener\n*L\n104#1:139,2\n116#1:141,2\n*E\n"})
public final class PersistentToastNoticeListener
implements NoticesManager.NoticeListener {
    @NotNull
    private final NoticesManager noticesManager;
    @NotNull
    private final Map<Notice, Function0<Unit>> pushedToasts;
    @NotNull
    private final Set<Notice> notices;
    @NotNull
    private final Map<String, Function0<Unit>> actions;

    public PersistentToastNoticeListener(@NotNull NoticesManager noticesManager) {
        Intrinsics.checkNotNullParameter((Object)noticesManager, (String)"noticesManager");
        this.noticesManager = noticesManager;
        this.pushedToasts = new LinkedHashMap();
        this.notices = new LinkedHashSet();
        this.actions = MapsKt.mapOf((Pair)TuplesKt.to((Object)"OPEN_EMOTES", (Object)((Object)actions.1.INSTANCE)));
        Essential.EVENT_BUS.register(this);
    }

    @Override
    public void noticeAdded(@NotNull Notice notice) {
        Intrinsics.checkNotNullParameter((Object)notice, (String)"notice");
        if (notice.getType() != NoticeType.DISMISSIBLE_TOAST) {
            return;
        }
        this.notices.add(notice);
        if (ExtensionsKt.isMainMenu(Minecraft.m_91087_().f_91080_)) {
            this.pushNoticeToast(notice);
        }
    }

    private final void pushNoticeToast(Notice notice) {
        block5: {
            Object object = notice.getMetadata().get("title");
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                return;
            }
            String title2 = string;
            Object object2 = notice.getMetadata().get("message");
            String string2 = object2 instanceof String ? (String)object2 : null;
            if (string2 == null) {
                return;
            }
            String message2 = string2;
            object2 = notice.getMetadata().get("action");
            String action2 = object2 instanceof String ? (String)object2 : null;
            TelemetryManager telemetryManager = Essential.getInstance().getConnectionManager().getTelemetryManager();
            Intrinsics.checkNotNullExpressionValue((Object)telemetryManager, (String)"getTelemetryManager(...)");
            TelemetryManager telemetryManager2 = telemetryManager;
            Function0 pushNotice2 = (Function0)new Function0<Unit>(title2, message2, this, action2, notice, telemetryManager2){
                final /* synthetic */ String $title;
                final /* synthetic */ String $message;
                final /* synthetic */ PersistentToastNoticeListener this$0;
                final /* synthetic */ String $action;
                final /* synthetic */ Notice $notice;
                final /* synthetic */ TelemetryManager $telemetryManager;
                {
                    this.$title = $title;
                    this.$message = $message;
                    this.this$0 = $receiver;
                    this.$action = $action;
                    this.$notice = $notice;
                    this.$telemetryManager = $telemetryManager;
                    super(0);
                }

                public final void invoke() {
                    Notifications.INSTANCE.pushPersistentToast(this.$title, this.$message, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$action, this.$notice, this.$telemetryManager){
                        final /* synthetic */ PersistentToastNoticeListener this$0;
                        final /* synthetic */ String $action;
                        final /* synthetic */ Notice $notice;
                        final /* synthetic */ TelemetryManager $telemetryManager;
                        {
                            this.this$0 = $receiver;
                            this.$action = $action;
                            this.$notice = $notice;
                            this.$telemetryManager = $telemetryManager;
                            super(0);
                        }

                        public final void invoke() {
                            Function0 function0 = (Function0)PersistentToastNoticeListener.access$getActions$p(this.this$0).get(this.$action);
                            if (function0 != null) {
                                Function0 it = function0;
                                boolean bl = false;
                                it.invoke();
                            }
                            PersistentToastNoticeListener.access$dismissToast(this.this$0, this.$notice);
                            this.$telemetryManager.clientActionPerformed(TelemetryManager.Actions.PERSISTENT_TOAST_CLICKED, this.$notice.getId());
                        }
                    }), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$notice, this.$telemetryManager){
                        final /* synthetic */ PersistentToastNoticeListener this$0;
                        final /* synthetic */ Notice $notice;
                        final /* synthetic */ TelemetryManager $telemetryManager;
                        {
                            this.this$0 = $receiver;
                            this.$notice = $notice;
                            this.$telemetryManager = $telemetryManager;
                            super(0);
                        }

                        public final void invoke() {
                            if (PersistentToastNoticeListener.access$getPushedToasts$p(this.this$0).keySet().contains(this.$notice)) {
                                PersistentToastNoticeListener.access$dismissToast(this.this$0, this.$notice);
                                this.$telemetryManager.clientActionPerformed(TelemetryManager.Actions.PERSISTENT_TOAST_CLEARED, this.$notice.getId());
                            }
                        }
                    }), (Function1<? super NotificationBuilder, Unit>)((Function1)new Function1<NotificationBuilder, Unit>(this.this$0, this.$notice){
                        final /* synthetic */ PersistentToastNoticeListener this$0;
                        final /* synthetic */ Notice $notice;
                        {
                            this.this$0 = $receiver;
                            this.$notice = $notice;
                            super(1);
                        }

                        public final void invoke(@NotNull NotificationBuilder $this$pushPersistentToast) {
                            Intrinsics.checkNotNullParameter((Object)$this$pushPersistentToast, (String)"$this$pushPersistentToast");
                            PersistentToastNoticeListener.access$getPushedToasts$p(this.this$0).put(this.$notice, $this$pushPersistentToast.getDismissNotificationInstantly());
                        }
                    }));
                }
            };
            DateTime dateTime = notice.getActiveAfter();
            if (dateTime == null) {
                return;
            }
            DateTime activeAfter = dateTime;
            if (activeAfter.after(Date.from(Instant.now()))) {
                pushNotice2.invoke();
            } else {
                Multithreading.scheduleOnMainThread(() -> PersistentToastNoticeListener.pushNoticeToast$lambda$0(pushNotice2), Instant.now().until(activeAfter.toInstant(), ChronoUnit.MILLIS), TimeUnit.MILLISECONDS);
            }
            DateTime dateTime2 = notice.getExpiresAt();
            if (dateTime2 == null) break block5;
            DateTime expiresAt = dateTime2;
            boolean bl = false;
            Multithreading.scheduleOnMainThread(() -> PersistentToastNoticeListener.pushNoticeToast$lambda$2$lambda$1(this, notice), Instant.now().until(expiresAt.toInstant(), ChronoUnit.MILLIS), TimeUnit.MILLISECONDS);
        }
    }

    @Subscribe
    public final void guiOpenEvent(@NotNull GuiOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if ((ExtensionsKt.isMainMenu(event.getGui()) || event.getGui() == null) && UMinecraft.getWorld() == null) {
            Iterable $this$forEach$iv = this.notices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Notice notice = (Notice)element$iv;
                boolean bl = false;
                if (this.pushedToasts.keySet().contains(notice)) continue;
                this.pushNoticeToast(notice);
            }
        } else {
            this.hideAllToasts();
        }
    }

    private final void hideAllToasts() {
        Iterable $this$forEach$iv = CollectionsKt.toMutableSet((Iterable)this.pushedToasts.entrySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Notice notice = (Notice)entry.getKey();
            Function0 dismissAction = (Function0)entry.getValue();
            this.pushedToasts.remove(notice);
            dismissAction.invoke();
        }
    }

    private final void dismissToast(Notice notice) {
        this.noticesManager.dismissNotice(notice.getId());
        this.notices.remove(notice);
    }

    @Override
    public void noticeRemoved(@NotNull Notice notice) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)notice, (String)"notice");
            this.notices.remove(notice);
            Function0<Unit> function0 = this.pushedToasts.remove(notice);
            if (function0 == null) break block0;
            Function0<Unit> dismiss = function0;
            boolean bl = false;
            dismiss.invoke();
        }
    }

    @Override
    public void onConnect() {
        this.hideAllToasts();
        this.notices.clear();
    }

    private static final void pushNoticeToast$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void pushNoticeToast$lambda$2$lambda$1(PersistentToastNoticeListener this$0, Notice $notice) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$notice, (String)"$notice");
        this$0.noticeRemoved($notice);
    }

    public static final /* synthetic */ Map access$getActions$p(PersistentToastNoticeListener $this) {
        return $this.actions;
    }

    public static final /* synthetic */ void access$dismissToast(PersistentToastNoticeListener $this, Notice notice) {
        $this.dismissToast(notice);
    }

    public static final /* synthetic */ Map access$getPushedToasts$p(PersistentToastNoticeListener $this) {
        return $this.pushedToasts;
    }
}

