/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.sps;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.telemetry.ClientTelemetryPacket;
import gg.essential.util.ExtensionsKt;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class SPSConnectionTelemetry {
    private final UUID client;
    private final UUID sessionId;
    private final boolean relayed;
    private long sentBytes = 0L;
    private int sentPackets = 0;
    private long receivedBytes = 0L;
    private int receivedPackets = 0;
    private boolean sent = false;

    public SPSConnectionTelemetry(UUID client, UUID sessionId2, boolean relayed) {
        this.client = client;
        this.sessionId = sessionId2;
        this.relayed = relayed;
    }

    public void send() {
        if (this.sent) {
            return;
        }
        this.sent = true;
        HashMap<String, Comparable<UUID>> metadata2 = new HashMap<String, Comparable<UUID>>();
        metadata2.put("client", this.client);
        metadata2.put("sessionId", this.sessionId);
        metadata2.put("sentBytes", Long.valueOf(this.sentBytes));
        metadata2.put("sentPackets", Integer.valueOf(this.sentPackets));
        metadata2.put("receivedBytes", Long.valueOf(this.receivedBytes));
        metadata2.put("receivedPackets", Integer.valueOf(this.receivedPackets));
        metadata2.put("relayed", Boolean.valueOf(this.relayed));
        ExtensionsKt.getExecutor(Minecraft.m_91087_()).execute(() -> Essential.getInstance().getConnectionManager().getTelemetryManager().enqueue(new ClientTelemetryPacket("SPS_CONNECTION", metadata2)));
    }

    public void packetSent(int size) {
        this.sentBytes += (long)size;
        ++this.sentPackets;
    }

    public void packetReceived(int size) {
        this.receivedBytes += (long)size;
        ++this.receivedPackets;
    }
}

