/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic;

import gg.essential.quic.LogOnce;
import gg.essential.quic.LogOnceHandler;
import gg.essential.quic.ProxyHandler;
import gg.essential.quic.QuicConnector;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicChannelBootstrap;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public class QuicClientConnector
extends QuicConnector {
    private static final QuicSslContext quicSslContext = QuicSslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocols(new String[]{"minecraft"}).build();
    private static final ChannelHandler quicCodec = ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)new QuicClientCodecBuilder().sslContext(quicSslContext)).maxIdleTimeout(30L, TimeUnit.SECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(10000000L)).build();
    private final LogOnce debugOnce = LogOnce.toForkedJvmDebug();

    private QuicClientConnector() {
    }

    public int[] bindProxy(String host, int icePort) {
        EventLoop eventLoop = this.group.next();
        Channel udpChannel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoop)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new LogOnceHandler(LogOnce.toForkedJvmDebug(), "transport"))).bind(host, 0).syncUninterruptibly().channel();
        udpChannel.pipeline().addLast(new ChannelHandler[]{quicCodec});
        QuicChannelBootstrap quicChannelBootstrap = QuicChannel.newBootstrap((Channel)udpChannel).streamHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).remoteAddress((SocketAddress)new InetSocketAddress(host, icePort));
        HttpProxyInitializer httpProxy = new HttpProxyInitializer();
        Channel httpChannel = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)eventLoop).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)httpProxy).childOption(ChannelOption.AUTO_READ, (Object)false).bind(host, 0).syncUninterruptibly().channel();
        Channel tcpChannel = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)eventLoop).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new McProxyInitializer(host, udpChannel, quicChannelBootstrap, httpChannel, httpProxy)).childOption(ChannelOption.AUTO_READ, (Object)false).bind(host, 0).syncUninterruptibly().channel();
        int udpPort = ((InetSocketAddress)udpChannel.localAddress()).getPort();
        int tcpPort = ((InetSocketAddress)tcpChannel.localAddress()).getPort();
        int httpPort = ((InetSocketAddress)httpChannel.localAddress()).getPort();
        return new int[]{udpPort, tcpPort, httpPort};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        QuicClientConnector connector = new QuicClientConnector();
        try {
            DataOutputStream out = new DataOutputStream(stdOut);
            DataInputStream in = new DataInputStream(System.in);
            String host = in.readUTF();
            int icePort = in.readUnsignedShort();
            int[] ports = connector.bindProxy(host, icePort);
            out.writeShort(ports[0]);
            out.writeShort(ports[1]);
            out.writeShort(ports[2]);
            out.flush();
            in.read();
        }
        finally {
            connector.group.shutdownGracefully();
        }
    }

    private static class HttpProxyFrontendHandler
    extends ProxyHandler {
        private final QuicChannel quicChannel;

        public HttpProxyFrontendHandler(QuicChannel quicChannel) {
            this.quicChannel = quicChannel;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            Channel tcpChannel = ctx.channel();
            this.quicChannel.createStream(QuicStreamType.BIDIRECTIONAL, (ChannelHandler)new ProxyHandler(tcpChannel)).addListener(streamChannelFuture -> {
                if (!streamChannelFuture.isSuccess()) {
                    streamChannelFuture.cause().printStackTrace();
                    tcpChannel.close();
                    return;
                }
                this.targetChannel = (Channel)streamChannelFuture.getNow();
                if (tcpChannel.isActive()) {
                    tcpChannel.config().setAutoRead(true);
                }
            });
        }
    }

    private static class HttpProxyInitializer
    extends ChannelInitializer<SocketChannel> {
        public QuicChannel quicChannel;

        private HttpProxyInitializer() {
        }

        protected void initChannel(SocketChannel ch) {
            if (this.quicChannel == null) {
                ch.close();
                return;
            }
            ch.pipeline().addLast(new ChannelHandler[]{new HttpProxyFrontendHandler(this.quicChannel)});
        }
    }

    private static class McProxyBackendHandler
    extends ProxyHandler {
        public McProxyBackendHandler(Channel tcpChannel) {
            super(tcpChannel);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                ((QuicChannel)ctx.channel().parent()).close(true, 0, Unpooled.EMPTY_BUFFER);
            }
        }
    }

    private class McProxyFrontendHandler
    extends ProxyHandler {
        private final String host;
        private final Channel udpChannel;
        private final QuicChannelBootstrap quicChannelBootstrap;
        private final Channel httpChannel;
        private final HttpProxyInitializer httpProxy;

        public McProxyFrontendHandler(String host, Channel udpChannel, QuicChannelBootstrap quicChannelBootstrap, Channel httpChannel, HttpProxyInitializer httpProxy) {
            this.host = host;
            this.udpChannel = udpChannel;
            this.quicChannelBootstrap = quicChannelBootstrap;
            this.httpChannel = httpChannel;
            this.httpProxy = httpProxy;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            Channel tcpChannel = ctx.channel();
            QuicClientConnector.this.debugOnce.log("connect");
            this.quicChannelBootstrap.connect().addListener(quicChannelFuture -> {
                if (!quicChannelFuture.isSuccess()) {
                    quicChannelFuture.cause().printStackTrace();
                    tcpChannel.close();
                    return;
                }
                QuicChannel quicChannel = (QuicChannel)quicChannelFuture.getNow();
                QuicClientConnector.this.debugOnce.log("createStream");
                quicChannel.createStream(QuicStreamType.BIDIRECTIONAL, (ChannelHandler)new McProxyBackendHandler(tcpChannel)).addListener(streamChannelFuture -> {
                    if (!streamChannelFuture.isSuccess()) {
                        streamChannelFuture.cause().printStackTrace();
                        tcpChannel.close();
                        quicChannel.close();
                        return;
                    }
                    this.targetChannel = (Channel)streamChannelFuture.getNow();
                    if (tcpChannel.isActive()) {
                        QuicClientConnector.this.debugOnce.log("setAutoRead");
                        tcpChannel.config().setAutoRead(true);
                    }
                });
                this.httpProxy.quicChannel = quicChannel;
            });
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            QuicClientConnector.this.debugOnce.log("channelInactive");
            if (this.targetChannel == null) {
                this.udpChannel.close();
                this.httpChannel.close();
            }
            super.channelInactive(ctx);
        }
    }

    private class McProxyInitializer
    extends ChannelInitializer<SocketChannel> {
        private final String host;
        private final Channel udpChannel;
        private final QuicChannelBootstrap quicChannelBootstrap;
        private final Channel httpChannel;
        private final HttpProxyInitializer httpProxy;

        public McProxyInitializer(String host, Channel udpChannel, QuicChannelBootstrap quicChannelBootstrap, Channel httpChannel, HttpProxyInitializer httpProxy) {
            this.host = host;
            this.udpChannel = udpChannel;
            this.quicChannelBootstrap = quicChannelBootstrap;
            this.httpChannel = httpChannel;
            this.httpProxy = httpProxy;
        }

        protected void initChannel(SocketChannel ch) {
            QuicClientConnector.this.debugOnce.log("initChannel", ch.remoteAddress());
            ch.pipeline().addLast(new ChannelHandler[]{new McProxyFrontendHandler(this.host, this.udpChannel, this.quicChannelBootstrap, this.httpChannel, this.httpProxy)});
        }
    }
}

