/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic;

import gg.essential.quic.LogOnce;
import gg.essential.quic.LogOnceHandler;
import gg.essential.quic.ProxyHandler;
import gg.essential.quic.QuicConnector;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.incubator.codec.quic.InsecureQuicTokenHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicTokenHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;

public class QuicServerConnector
extends QuicConnector {
    private final SelfSignedCertificate certificate = new SelfSignedCertificate();
    private final QuicSslContext quicSslContext = QuicSslContextBuilder.forServer((File)this.certificate.privateKey(), null, (File)this.certificate.certificate()).applicationProtocols(new String[]{"minecraft"}).build();
    private final QuicServerCodecBuilder quicCodecBuilder = (QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)new QuicServerCodecBuilder().sslContext(this.quicSslContext)).tokenHandler((QuicTokenHandler)InsecureQuicTokenHandler.INSTANCE).maxIdleTimeout(30L, TimeUnit.SECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalRemote(10000000L)).initialMaxStreamsBidirectional(10L);

    private QuicServerConnector() throws CertificateException {
    }

    public int bindProxy(String host, int tcpPort, int httpPort) {
        Channel channel2 = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ConnectTimeoutHandler())).bind(host, 0).syncUninterruptibly().channel();
        channel2.pipeline().addLast(new ChannelHandler[]{new LogOnceHandler(LogOnce.toForkedJvmDebug(), "transport")});
        ChannelHandler codec = this.quicCodecBuilder.handler((ChannelHandler)new ChannelInboundHandlerAdapter()).streamHandler((ChannelHandler)new ProxyInitializer(host, tcpPort, httpPort)).build();
        channel2.pipeline().addLast(new ChannelHandler[]{codec});
        return ((InetSocketAddress)channel2.localAddress()).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CertificateException {
        QuicServerConnector connector = new QuicServerConnector();
        try {
            DataOutputStream out = new DataOutputStream(stdOut);
            DataInputStream in = new DataInputStream(System.in);
            while (in.read() == 0) {
                String host = in.readUTF();
                int tcpPort = in.readUnsignedShort();
                int httpPort = in.readUnsignedShort();
                int icePort = connector.bindProxy(host, tcpPort, httpPort);
                out.writeShort(icePort);
                out.flush();
            }
        }
        finally {
            connector.group.shutdownGracefully();
        }
    }

    private static class McProxyFrontendHandler
    extends TcpProxyFrontendHandler {
        public McProxyFrontendHandler(String tcpHost, int tcpPort) {
            super(tcpHost, tcpPort);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt == ChannelInputShutdownReadComplete.INSTANCE) {
                ((QuicChannel)ctx.channel().parent()).close(true, 0, Unpooled.EMPTY_BUFFER);
            }
        }
    }

    private static class TcpProxyFrontendHandler
    extends ProxyHandler {
        private final int tcpPort;
        private final String tcpHost;

        public TcpProxyFrontendHandler(String tcpHost, int tcpPort) {
            this.tcpHost = tcpHost;
            this.tcpPort = tcpPort;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            Channel quicStreamChannel = ctx.channel();
            ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)quicStreamChannel.eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ProxyHandler(quicStreamChannel))).connect(this.tcpHost, this.tcpPort).addListener((GenericFutureListener)((ChannelFutureListener)tcpChannelFuture -> {
                if (!tcpChannelFuture.isSuccess()) {
                    tcpChannelFuture.cause().printStackTrace();
                    quicStreamChannel.close();
                    return;
                }
                this.targetChannel = tcpChannelFuture.channel();
                if (quicStreamChannel.isActive()) {
                    quicStreamChannel.config().setAutoRead(true);
                } else {
                    this.targetChannel.close();
                }
            }));
        }
    }

    private static class ProxyInitializer
    extends ChannelInitializer<QuicStreamChannel> {
        private final LogOnce debugOnce = LogOnce.toForkedJvmDebug();
        private final String tcpHost;
        private final int tcpPort;
        private final int httpPort;
        private boolean waitingForInitialStream = true;

        public ProxyInitializer(String tcpHost, int tcpPort, int httpPort) {
            this.tcpHost = tcpHost;
            this.tcpPort = tcpPort;
            this.httpPort = httpPort;
        }

        protected void initChannel(QuicStreamChannel ch) {
            this.debugOnce.log("initQuicStreamChannel", ch);
            ch.config().setAutoRead(false);
            if (this.waitingForInitialStream) {
                this.waitingForInitialStream = false;
                ch.pipeline().addLast(new ChannelHandler[]{new McProxyFrontendHandler(this.tcpHost, this.tcpPort)});
                ch.parent().parent().pipeline().remove(ReadTimeoutHandler.class);
            } else {
                ch.pipeline().addLast(new ChannelHandler[]{new TcpProxyFrontendHandler(this.tcpHost, this.httpPort)});
            }
        }
    }

    private static class ConnectTimeoutHandler
    extends ChannelInboundHandlerAdapter {
        private ConnectTimeoutHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.channel().pipeline().addFirst(new ChannelHandler[]{new ReadTimeoutHandler(10L, TimeUnit.SECONDS)});
            super.channelActive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof ReadTimeoutException) {
                ctx.channel().close();
            } else {
                super.exceptionCaught(ctx, cause);
            }
        }
    }
}

