/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.slf4j;

import gg.essential.lib.slf4j.Marker;
import gg.essential.lib.slf4j.event.Level;
import gg.essential.lib.slf4j.event.LoggingEvent;
import gg.essential.lib.slf4j.helpers.LegacyAbstractLogger;
import gg.essential.lib.slf4j.spi.LoggingEventAware;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log4jLogger
extends LegacyAbstractLogger
implements LoggingEventAware {
    private static final String FQCN = Log4jLogger.class.getName();
    private final AbstractLogger log4j;

    public Log4jLogger(AbstractLogger log4j, String name2) {
        this.log4j = log4j;
        this.name = name2;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log4j.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log4j.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log4j.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log4j.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log4j.isErrorEnabled();
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return FQCN;
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String msg, Object[] arguments, Throwable throwable) {
        String fqcn = this.getFullyQualifiedCallerName();
        SimpleMessage data = arguments == null ? new SimpleMessage(msg) : new ParameterizedMessage(msg, arguments, throwable);
        AbstractLoggerAccessor.INSTANCE.log(this.log4j, fqcn, this.convertLevel(level), null, (Message)data, throwable);
    }

    @Override
    public void log(LoggingEvent event) {
        String fqcn = event.getCallerBoundary();
        if (fqcn == null) {
            fqcn = FQCN;
        }
        String msg = event.getMessage();
        Object[] arguments = event.getArgumentArray();
        Throwable throwable = event.getThrowable();
        SimpleMessage data = arguments == null ? new SimpleMessage(msg) : new ParameterizedMessage(msg, arguments, throwable);
        AbstractLoggerAccessor.INSTANCE.log(this.log4j, fqcn, this.convertLevel(event.getLevel()), null, (Message)data, throwable);
    }

    private org.apache.logging.log4j.Level convertLevel(Level level) {
        switch (level) {
            case TRACE: {
                return org.apache.logging.log4j.Level.TRACE;
            }
            case DEBUG: {
                return org.apache.logging.log4j.Level.DEBUG;
            }
            case INFO: {
                return org.apache.logging.log4j.Level.INFO;
            }
            case WARN: {
                return org.apache.logging.log4j.Level.WARN;
            }
        }
        return org.apache.logging.log4j.Level.ERROR;
    }

    private static abstract class BetaAbstractLoggerAccessor
    extends AbstractLogger {
        private BetaAbstractLoggerAccessor() {
        }

        static void log(AbstractLogger logger2, String fqcn, org.apache.logging.log4j.Level level, org.apache.logging.log4j.Marker marker, Message data, Throwable t) {
            logger2.log(marker, fqcn, level, data, t);
        }
    }

    private static interface AbstractLoggerAccessor {
        public static final AbstractLoggerAccessor INSTANCE = AbstractLoggerAccessor.get();

        public void log(AbstractLogger var1, String var2, org.apache.logging.log4j.Level var3, org.apache.logging.log4j.Marker var4, Message var5, Throwable var6);

        public static AbstractLoggerAccessor get() {
            try {
                Class[] args = new Class[]{String.class, org.apache.logging.log4j.Level.class, org.apache.logging.log4j.Marker.class, Message.class, Throwable.class};
                Method method = AbstractLogger.class.getMethod("logMessage", args);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                return LambdaMetafactory.metafactory(lookup, "log", MethodType.methodType(AbstractLoggerAccessor.class), MethodType.methodType(Void.TYPE, AbstractLogger.class, args), lookup.unreflect(method), MethodType.methodType(Void.TYPE, AbstractLogger.class, args)).getTarget().invokeExact();
            }
            catch (NoSuchMethodException e) {
                return BetaAbstractLoggerAccessor::log;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

