/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.sps;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import gg.essential.Essential;
import gg.essential.mixins.ext.client.resource.FileResourcePackExt;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.sps.quic.jvm.UtilKt;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.Multithreading;
import gg.essential.util.ResourceManagerUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u000f\u0010\u0016\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u001f\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u0003J\r\u0010\u001c\u001a\u00020\t\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u000f\u0010\u001d\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u001f\u0010\u001f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0013\u0010'\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0018\u0010)\u001a\u0004\u0018\u00010(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0019\u0010-\u001a\u00070+\u00a2\u0006\u0002\b,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u00060"}, d2={"Lgg/essential/sps/ResourcePackSharingHttpServer;", "", "<init>", "()V", "Ljava/nio/file/Path;", "rootPath", "srcFile", "Ljava/util/zip/ZipOutputStream;", "zip", "", "addFileToZip", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/zip/ZipOutputStream;)V", "srcFolder", "addFolderToZip", "file", "", "getChecksum", "(Ljava/nio/file/Path;)Ljava/lang/String;", "Lnet/minecraft/server/packs/PackResources;", "getPrimaryResourcePack", "()Lnet/minecraft/server/packs/PackResources;", "onShareResourcePackEnable", "recomputePrimaryPack", "Lcom/sun/net/httpserver/HttpExchange;", "exchange", "sendFile", "(Ljava/nio/file/Path;Lcom/sun/net/httpserver/HttpExchange;)V", "startServer", "stopServer", "updateResourcePack", "destZipFile", "zipFolder", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "Lgg/essential/sps/ResourcePackSharingHttpServer$PackInfo;", "packInfo", "Lgg/essential/sps/ResourcePackSharingHttpServer$PackInfo;", "", "getPort", "()Ljava/lang/Integer;", "port", "Lcom/sun/net/httpserver/HttpServer;", "server", "Lcom/sun/net/httpserver/HttpServer;", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "Lorg/jetbrains/annotations/NotNull;", "spsManager", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "PackInfo", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nResourcePackSharingHttpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcePackSharingHttpServer.kt\ngg/essential/sps/ResourcePackSharingHttpServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class ResourcePackSharingHttpServer {
    @NotNull
    public static final ResourcePackSharingHttpServer INSTANCE = new ResourcePackSharingHttpServer();
    @NotNull
    private static final SPSManager spsManager;
    @Nullable
    private static HttpServer server;
    @Nullable
    private static PackInfo packInfo;

    private ResourcePackSharingHttpServer() {
    }

    @Nullable
    public final Integer getPort() {
        Object object = server;
        return object != null && (object = ((HttpServer)object).getAddress()) != null ? Integer.valueOf(((InetSocketAddress)object).getPort()) : null;
    }

    public final void startServer() {
        HttpServer server = HttpServer.create(new InetSocketAddress(UtilKt.getLOCALHOST(), 0), 0);
        server.createContext("/", ResourcePackSharingHttpServer::startServer$lambda$1);
        server.setExecutor(Multithreading.pool);
        server.start();
        ResourcePackSharingHttpServer.server = server;
    }

    public final void stopServer() {
        HttpServer httpServer = server;
        if (httpServer != null) {
            httpServer.stop(0);
        }
        server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendFile(Path file, HttpExchange exchange) {
        exchange.sendResponseHeaders(200, Files.size(file));
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            OutputStream outputStream = exchange.getResponseBody();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getResponseBody(...)");
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)outputStream, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        exchange.getResponseBody().close();
    }

    private final PackResources getPrimaryResourcePack() {
        PackRepository resourcePackRepository = Minecraft.m_91087_().m_91099_();
        Collection repositoryEntries = resourcePackRepository.m_10524_();
        if (repositoryEntries.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNull((Object)repositoryEntries);
        return ((Pack)CollectionsKt.last((Iterable)repositoryEntries)).m_10445_();
    }

    public final void onShareResourcePackEnable() {
        if (packInfo == null) {
            this.updateResourcePack();
        }
    }

    private final void updateResourcePack() {
        if (spsManager.getLocalSession() == null || !spsManager.isShareResourcePack()) {
            Object object = packInfo;
            if (object != null) {
                PackInfo packInfo;
                PackInfo it = packInfo = object;
                boolean bl = false;
                object = it.isTemp() ? packInfo : null;
                if (object != null && (object = ((PackInfo)object).getFile()) != null) {
                    Files.deleteIfExists((Path)object);
                }
            }
            packInfo = null;
            spsManager.updateResourcePack(null);
            return;
        }
        this.recomputePrimaryPack();
        spsManager.updateResourcePack(packInfo);
    }

    private final void recomputePrimaryPack() {
        PackResources resourcePack;
        PackInfo packInfo;
        PackInfo packInfo2 = packInfo = ResourcePackSharingHttpServer.packInfo;
        boolean bl = packInfo2 != null ? packInfo2.isTemp() : false;
        if (bl) {
            Files.deleteIfExists(packInfo.getFile());
        }
        if ((resourcePack = this.getPrimaryResourcePack()) == null) {
            ResourcePackSharingHttpServer.packInfo = null;
            return;
        }
        if (resourcePack instanceof FileResourcePackExt) {
            Path file = ((FileResourcePackExt)resourcePack).getEssential$file();
            if (file == null) {
                ResourcePackSharingHttpServer.packInfo = null;
                return;
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path tempFile = Files.createTempFile("resource-pack", ".zip", new FileAttribute[0]);
                Essential.logger.info("Zipping host resource pack to " + tempFile);
                Intrinsics.checkNotNull((Object)tempFile);
                this.zipFolder(file, tempFile);
                ResourcePackSharingHttpServer.packInfo = new PackInfo(tempFile, this.getChecksum(tempFile), true);
            } else {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    ResourcePackSharingHttpServer.packInfo = new PackInfo(file, this.getChecksum(file), false);
                } else {
                    ResourcePackSharingHttpServer.packInfo = null;
                    Essential.logger.error("Unable to determine primary resource pack: " + resourcePack.m_8017_() + " " + resourcePack.getClass().getName() + " " + file);
                }
            }
        } else {
            ResourcePackSharingHttpServer.packInfo = null;
            Essential.logger.error("Unable to determine primary resource pack: " + resourcePack.m_8017_() + " " + resourcePack.getClass().getName());
        }
    }

    private final String getChecksum(Path file) {
        byte[] byArray = Files.readAllBytes(file);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        String string = DigestUtils.sha1Hex((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sha1Hex(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipFolder(Path srcFolder, Path destZipFile) throws Exception {
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(destZipFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            OutputStream fileWriter = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipOutputStream(fileWriter);
            Throwable throwable2 = null;
            try {
                ZipOutputStream zip2 = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                INSTANCE.addFolderToZip(srcFolder, srcFolder, zip2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFileToZip(Path rootPath, Path srcFile, ZipOutputStream zip2) throws Exception {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(srcFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.addFolderToZip(rootPath, srcFile, zip2);
        } else {
            byte[] buf = new byte[1024];
            int len = 0;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(srcFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream in = (InputStream)closeable;
                boolean bl = false;
                String name2 = ((Object)PathsKt.relativeTo((Path)srcFile, (Path)rootPath)).toString();
                zip2.putNextEntry(new ZipEntry(name2));
                while (true) {
                    int n;
                    int it = n = in.read(buf);
                    boolean bl2 = false;
                    len = it;
                    if (n <= 0) break;
                    zip2.write(buf, 0, len);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private final void addFolderToZip(Path rootPath, Path srcFolder, ZipOutputStream zip2) throws Exception {
        for (Path fileName : PathsKt.listDirectoryEntries$default((Path)srcFolder, null, (int)1, null)) {
            this.addFileToZip(rootPath, fileName, zip2);
        }
    }

    private static final void _init_$lambda$0() {
        INSTANCE.updateResourcePack();
    }

    private static final void startServer$lambda$1(HttpExchange it) {
        if (spsManager.getLocalSession() == null || !spsManager.isShareResourcePack()) {
            it.sendResponseHeaders(403, 0L);
            it.getResponseBody().close();
            return;
        }
        PackInfo packInfo = ResourcePackSharingHttpServer.packInfo;
        if (packInfo == null) {
            it.sendResponseHeaders(404, 0L);
            it.getResponseBody().close();
        } else {
            try {
                Path path = packInfo.getFile();
                Intrinsics.checkNotNull((Object)it);
                INSTANCE.sendFile(path, it);
            }
            catch (Exception e) {
                e.printStackTrace();
                it.getResponseBody().close();
            }
        }
    }

    static {
        SPSManager sPSManager = Essential.getInstance().getConnectionManager().getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        spsManager = sPSManager;
        ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(ResourcePackSharingHttpServer::_init_$lambda$0);
        ResourceManagerUtil.INSTANCE.onResourceManagerReload((Function0<Unit>)((Function0)2.INSTANCE));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0013\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u000bR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u0007\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lgg/essential/sps/ResourcePackSharingHttpServer$PackInfo;", "", "Ljava/nio/file/Path;", "file", "", "checksum", "", "isTemp", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Z)V", "component1", "()Ljava/nio/file/Path;", "component2", "()Ljava/lang/String;", "component3", "()Z", "copy", "(Ljava/nio/file/Path;Ljava/lang/String;Z)Lgg/essential/sps/ResourcePackSharingHttpServer$PackInfo;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getChecksum", "Ljava/nio/file/Path;", "getFile", "Z", "Essential 1.19.2-forge"})
    public static final class PackInfo {
        @NotNull
        private final Path file;
        @NotNull
        private final String checksum;
        private final boolean isTemp;

        public PackInfo(@NotNull Path file, @NotNull String checksum, boolean isTemp) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
            this.file = file;
            this.checksum = checksum;
            this.isTemp = isTemp;
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }

        @NotNull
        public final String getChecksum() {
            return this.checksum;
        }

        public final boolean isTemp() {
            return this.isTemp;
        }

        @NotNull
        public final Path component1() {
            return this.file;
        }

        @NotNull
        public final String component2() {
            return this.checksum;
        }

        public final boolean component3() {
            return this.isTemp;
        }

        @NotNull
        public final PackInfo copy(@NotNull Path file, @NotNull String checksum, boolean isTemp) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
            return new PackInfo(file, checksum, isTemp);
        }

        public static /* synthetic */ PackInfo copy$default(PackInfo packInfo, Path path, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path = packInfo.file;
            }
            if ((n & 2) != 0) {
                string = packInfo.checksum;
            }
            if ((n & 4) != 0) {
                bl = packInfo.isTemp;
            }
            return packInfo.copy(path, string, bl);
        }

        @NotNull
        public String toString() {
            return "PackInfo(file=" + this.file + ", checksum=" + this.checksum + ", isTemp=" + this.isTemp + ")";
        }

        public int hashCode() {
            int result = ((Object)this.file).hashCode();
            result = result * 31 + this.checksum.hashCode();
            result = result * 31 + Boolean.hashCode(this.isTemp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackInfo)) {
                return false;
            }
            PackInfo packInfo = (PackInfo)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)packInfo.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.checksum, (Object)packInfo.checksum)) {
                return false;
            }
            return this.isTemp == packInfo.isTemp;
        }
    }
}

