/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.sps.quic.jvm;

import gg.essential.quic.LogOnce;
import gg.essential.sps.quic.QuicStream;
import gg.essential.sps.quic.jvm.ForkedJvmQuicConnector;
import gg.essential.sps.quic.jvm.UtilKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f*\u00020\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u0015\u00a8\u0006%"}, d2={"Lgg/essential/sps/quic/jvm/ForkedJvmClientQuicStream;", "Lgg/essential/sps/quic/QuicStream;", "Ljava/net/DatagramSocket;", "iceSocket", "<init>", "(Ljava/net/DatagramSocket;)V", "", "close", "()V", "Lgg/essential/sps/quic/jvm/ForkedJvmQuicConnector;", "", "udpPort", "Lkotlin/Triple;", "bind", "(Lgg/essential/sps/quic/jvm/ForkedJvmQuicConnector;I)Lkotlin/Triple;", "connector", "Lgg/essential/sps/quic/jvm/ForkedJvmQuicConnector;", "httpPort", "I", "getHttpPort", "()I", "Ljava/net/DatagramSocket;", "Ljava/io/InputStream;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "Ljava/io/OutputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "Ljava/net/Socket;", "tcpSocket", "Ljava/net/Socket;", "udpSocket", "Companion", "Essential 1.19.2-forge"})
public final class ForkedJvmClientQuicStream
implements QuicStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatagramSocket iceSocket;
    @NotNull
    private final ForkedJvmQuicConnector connector;
    @NotNull
    private final DatagramSocket udpSocket;
    @NotNull
    private final Socket tcpSocket;
    private final int httpPort;
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final OutputStream outputStream;
    private static final Logger LOGGER = LogManager.getLogger();

    public ForkedJvmClientQuicStream(@NotNull DatagramSocket iceSocket) {
        Intrinsics.checkNotNullParameter((Object)iceSocket, (String)"iceSocket");
        this.iceSocket = iceSocket;
        this.connector = new ForkedJvmQuicConnector("gg.essential.quic.QuicClientConnector");
        this.udpSocket = new DatagramSocket(0, UtilKt.getLOCALHOST());
        try {
            Triple<Integer, Integer, Integer> triple = this.bind(this.connector, this.udpSocket.getLocalPort());
            int udpPort = ((Number)triple.component1()).intValue();
            int tcpPort = ((Number)triple.component2()).intValue();
            int httpPort = ((Number)triple.component3()).intValue();
            LOGGER.debug("udp: " + this.udpSocket.getLocalPort() + " <> " + udpPort + ", tcp: " + tcpPort + ", http: " + httpPort);
            this.udpSocket.connect(UtilKt.getLOCALHOST(), udpPort);
            LogOnce logOnce = LogOnce.to(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)logOnce, (String)"to(...)");
            UtilKt.forwardAsync("quic\u2192ice", this.udpSocket, this.iceSocket, logOnce);
            LogOnce logOnce2 = LogOnce.to(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)logOnce2, (String)"to(...)");
            UtilKt.forwardAsync("ice\u2192quic", this.iceSocket, this.udpSocket, logOnce2);
            this.tcpSocket = new Socket(UtilKt.getLOCALHOST(), tcpPort);
            this.httpPort = httpPort;
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)this.udpSocket);
            IOUtils.closeQuietly((Closeable)this.connector);
            throw e;
        }
        InputStream inputStream = this.tcpSocket.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        this.inputStream = inputStream;
        OutputStream outputStream = this.tcpSocket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        this.outputStream = outputStream;
    }

    public final int getHttpPort() {
        return this.httpPort;
    }

    private final synchronized Triple<Integer, Integer, Integer> bind(ForkedJvmQuicConnector $this$bind, int udpPort) {
        $this$bind.getOutput().writeUTF(UtilKt.getLOCALHOST().getHostAddress());
        $this$bind.getOutput().writeShort(udpPort);
        $this$bind.getOutput().flush();
        return new Triple((Object)$this$bind.getInput().readUnsignedShort(), (Object)$this$bind.getInput().readUnsignedShort(), (Object)$this$bind.getInput().readUnsignedShort());
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public synchronized void close() {
        LOGGER.debug("close");
        this.tcpSocket.close();
        this.connector.close();
        this.udpSocket.close();
        this.iceSocket.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgg/essential/sps/quic/jvm/ForkedJvmClientQuicStream$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "Essential 1.19.2-forge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

