/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.sps.quic.jvm;

import gg.essential.quic.LogOnce;
import gg.essential.sps.quic.QuicStream;
import gg.essential.sps.quic.jvm.ForkedJvmQuicConnector;
import gg.essential.sps.quic.jvm.ForkedJvmServerQuicStreamPool;
import gg.essential.sps.quic.jvm.UtilKt;
import gg.essential.util.Multithreading;
import gg.essential.util.RefCounted;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\r\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lgg/essential/sps/quic/jvm/ForkedJvmServerQuicStreamPool;", "", "<init>", "()V", "Ljava/net/DatagramSocket;", "iceSocket", "", "httpPort", "Lgg/essential/sps/quic/QuicStream;", "accept", "(Ljava/net/DatagramSocket;I)Lgg/essential/sps/quic/QuicStream;", "Lgg/essential/sps/quic/jvm/ForkedJvmQuicConnector;", "tcpPort", "bind", "(Lgg/essential/sps/quic/jvm/ForkedJvmQuicConnector;II)I", "Lgg/essential/sps/quic/jvm/ForkedJvmServerQuicStreamPool$LazyConnector;", "lazyConnector", "Lgg/essential/sps/quic/jvm/ForkedJvmServerQuicStreamPool$LazyConnector;", "Companion", "LazyConnector", "Stream", "Essential 1.19.2-forge"})
public final class ForkedJvmServerQuicStreamPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LazyConnector lazyConnector = new LazyConnector();
    private static final Logger LOGGER = LogManager.getLogger();

    private final synchronized int bind(ForkedJvmQuicConnector $this$bind, int tcpPort, int httpPort) {
        $this$bind.getOutput().write(0);
        $this$bind.getOutput().writeUTF(UtilKt.getLOCALHOST().getHostAddress());
        $this$bind.getOutput().writeShort(tcpPort);
        $this$bind.getOutput().writeShort(httpPort);
        $this$bind.getOutput().flush();
        return $this$bind.getInput().readUnsignedShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final QuicStream accept(@NotNull DatagramSocket iceSocket, int httpPort) {
        Intrinsics.checkNotNullParameter((Object)iceSocket, (String)"iceSocket");
        ForkedJvmQuicConnector connector = this.lazyConnector.obtain();
        DatagramSocket udpSocket = new DatagramSocket(0, UtilKt.getLOCALHOST());
        try {
            Closeable closeable = new ServerSocket(0, 1, UtilKt.getLOCALHOST());
            Throwable throwable = null;
            try {
                ServerSocket serverSocket = (ServerSocket)closeable;
                boolean bl = false;
                int connectorPort = this.bind(connector, serverSocket.getLocalPort(), httpPort);
                LOGGER.debug("udp: " + udpSocket.getLocalPort() + " <> " + connectorPort + ", tcp: " + serverSocket.getLocalPort() + ", http: " + httpPort);
                udpSocket.connect(UtilKt.getLOCALHOST(), connectorPort);
                LogOnce logOnce = LogOnce.to(arg_0 -> ((Logger)LOGGER).debug(arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)logOnce, (String)"to(...)");
                UtilKt.forwardAsync("quic\u2192ice", udpSocket, iceSocket, logOnce);
                LogOnce logOnce2 = LogOnce.to(arg_0 -> ((Logger)LOGGER).debug(arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)logOnce2, (String)"to(...)");
                UtilKt.forwardAsync("ice\u2192quic", iceSocket, udpSocket, logOnce2);
                serverSocket.setSoTimeout((int)Duration.of(10L, ChronoUnit.SECONDS).toMillis());
                Socket tcpSocket = serverSocket.accept();
                Intrinsics.checkNotNull((Object)tcpSocket);
                QuicStream quicStream = new Stream(iceSocket, udpSocket, tcpSocket);
                return quicStream;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)udpSocket);
            this.lazyConnector.release();
            throw e;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgg/essential/sps/quic/jvm/ForkedJvmServerQuicStreamPool$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "Essential 1.19.2-forge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0003R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgg/essential/sps/quic/jvm/ForkedJvmServerQuicStreamPool$LazyConnector;", "", "<init>", "()V", "Lgg/essential/sps/quic/jvm/ForkedJvmQuicConnector;", "obtain", "()Lgg/essential/sps/quic/jvm/ForkedJvmQuicConnector;", "", "release", "Lgg/essential/util/RefCounted;", "inner", "Lgg/essential/util/RefCounted;", "Essential 1.19.2-forge"})
    private static final class LazyConnector {
        @NotNull
        private final RefCounted<ForkedJvmQuicConnector> inner = new RefCounted();

        @NotNull
        public final ForkedJvmQuicConnector obtain() {
            return this.inner.obtain((Function0<ForkedJvmQuicConnector>)((Function0)obtain.1.INSTANCE));
        }

        public final void release() {
            this.inner.release((Function1<ForkedJvmQuicConnector, Unit>)((Function1)release.1.INSTANCE));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u00108\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u00158\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lgg/essential/sps/quic/jvm/ForkedJvmServerQuicStreamPool$Stream;", "Lgg/essential/sps/quic/QuicStream;", "Ljava/net/DatagramSocket;", "iceSocket", "udpSocket", "Ljava/net/Socket;", "tcpSocket", "<init>", "(Lgg/essential/sps/quic/jvm/ForkedJvmServerQuicStreamPool;Ljava/net/DatagramSocket;Ljava/net/DatagramSocket;Ljava/net/Socket;)V", "", "close", "()V", "", "closed", "Z", "Ljava/net/DatagramSocket;", "Ljava/io/InputStream;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "Ljava/io/OutputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "Ljava/net/Socket;", "Essential 1.19.2-forge"})
    private final class Stream
    implements QuicStream {
        @NotNull
        private final DatagramSocket iceSocket;
        @NotNull
        private final DatagramSocket udpSocket;
        @NotNull
        private final Socket tcpSocket;
        @NotNull
        private final InputStream inputStream;
        @NotNull
        private final OutputStream outputStream;
        private boolean closed;

        public Stream(@NotNull DatagramSocket iceSocket, @NotNull DatagramSocket udpSocket, Socket tcpSocket) {
            Intrinsics.checkNotNullParameter((Object)iceSocket, (String)"iceSocket");
            Intrinsics.checkNotNullParameter((Object)udpSocket, (String)"udpSocket");
            Intrinsics.checkNotNullParameter((Object)tcpSocket, (String)"tcpSocket");
            this.iceSocket = iceSocket;
            this.udpSocket = udpSocket;
            this.tcpSocket = tcpSocket;
            InputStream inputStream = this.tcpSocket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            this.inputStream = inputStream;
            OutputStream outputStream = this.tcpSocket.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
            this.outputStream = outputStream;
        }

        @Override
        @NotNull
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        @NotNull
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            LOGGER.debug("close");
            this.tcpSocket.close();
            Multithreading.scheduleOnBackgroundThread(() -> Stream.close$lambda$0(this, ForkedJvmServerQuicStreamPool.this), 5L, TimeUnit.SECONDS);
        }

        private static final void close$lambda$0(Stream this$0, ForkedJvmServerQuicStreamPool this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            LOGGER.debug("force close");
            this$0.iceSocket.close();
            this$0.udpSocket.close();
            this$1.lazyConnector.release();
        }
    }
}

