/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.sps.quic.jvm;

import gg.essential.quic.LogOnce;
import gg.essential.quic.QuicUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a/\u0010\b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a-\u0010\n\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\t\"\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"", "name", "Ljava/net/DatagramSocket;", "source", "target", "Lgg/essential/quic/LogOnce;", "logOnce", "", "forward", "(Ljava/lang/String;Ljava/net/DatagramSocket;Ljava/net/DatagramSocket;Lgg/essential/quic/LogOnce;)V", "forwardAsync", "Ljava/net/InetAddress;", "LOCALHOST", "Ljava/net/InetAddress;", "getLOCALHOST", "()Ljava/net/InetAddress;", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ngg/essential/sps/quic/jvm/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final InetAddress LOCALHOST;

    @NotNull
    public static final InetAddress getLOCALHOST() {
        return LOCALHOST;
    }

    public static final void forwardAsync(@NotNull String name2, @NotNull DatagramSocket source, @NotNull DatagramSocket target2, @NotNull LogOnce logOnce) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)logOnce, (String)"logOnce");
        Thread thread = new Thread(() -> UtilKt.forwardAsync$lambda$2(source, target2, name2, logOnce), name2);
        thread.setDaemon(true);
        thread.start();
    }

    private static final void forward(String name2, DatagramSocket source, DatagramSocket target2, LogOnce logOnce) {
        block3: {
            try {
                while (!source.isClosed() && !target2.isClosed()) {
                    byte[] buf = new byte[65535];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    source.receive(packet);
                    logOnce.log(name2, packet.getLength());
                    packet.setSocketAddress(target2.getRemoteSocketAddress());
                    target2.send(packet);
                }
            }
            catch (IOException e) {
                logOnce.log(name2 + " exception", e);
                if (source.isClosed() || target2.isClosed() || e instanceof PortUnreachableException) break block3;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void forwardAsync$lambda$2(DatagramSocket $source, DatagramSocket $target, String $name, LogOnce $logOnce) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$logOnce, (String)"$logOnce");
        Closeable closeable = $source;
        Throwable throwable = null;
        try {
            DatagramSocket s = (DatagramSocket)closeable;
            boolean bl = false;
            Closeable closeable2 = $target;
            Throwable throwable2 = null;
            try {
                DatagramSocket t = (DatagramSocket)closeable2;
                boolean bl2 = false;
                UtilKt.forward($name, s, t, $logOnce);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        InetAddress inetAddress = QuicUtil.LOCALHOST;
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"LOCALHOST");
        LOCALHOST = inetAddress;
    }
}

