/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lgg/essential/util/AddressUtil;", "", "<init>", "()V", "", "address", "", "isLanOrLocalAddress", "(Ljava/lang/String;)Z", "isSpecialFormattedAddress", "removeDefaultPort", "(Ljava/lang/String;)Ljava/lang/String;", "LOCAL_SERVER", "Ljava/lang/String;", "SINGLEPLAYER", "Essential 1.19.2-forge"})
public final class AddressUtil {
    @NotNull
    public static final AddressUtil INSTANCE = new AddressUtil();
    @NotNull
    public static final String SINGLEPLAYER = "Singleplayer";
    @NotNull
    public static final String LOCAL_SERVER = "Local Server";

    private AddressUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String removeDefaultPort(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return StringsKt.removeSuffix((String)address, (CharSequence)":25565");
    }

    @JvmStatic
    public static final boolean isLanOrLocalAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        String host = HostAndPort.fromString((String)address).getHost();
        if (StringsKt.equals((String)host, (String)"localhost", (boolean)true)) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddresses.forString((String)host);
            boolean bl = false;
            return inetAddress.isSiteLocalAddress() || inetAddress.isLoopbackAddress();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @JvmStatic
    public static final boolean isSpecialFormattedAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return Intrinsics.areEqual((Object)address, (Object)SINGLEPLAYER) || Intrinsics.areEqual((Object)address, (Object)LOCAL_SERVER);
    }
}

