/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.data.VersionInfo;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.components.image.BlurHashImage;
import gg.essential.elementa.state.v2.ReferenceHolder;
import gg.essential.gui.layoutdsl.LayoutScope;
import gg.essential.gui.layoutdsl.Modifier;
import gg.essential.gui.layoutdsl.SizeKt;
import gg.essential.handlers.CertChain;
import gg.essential.lib.caffeine.cache.AsyncLoadingCache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.slf4j.Logger;
import gg.essential.lib.slf4j.LoggerFactory;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.GuiEssentialPlatform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.net.ssl.SSLContext;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0007J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\rH\u0007J\f\u0010\"\u001a\u00020#*\u00020\rH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR;\u0010\u000b\u001a/\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\r0\r\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f \u0005*\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u000e0\f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0013\u001a#\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u000f0\u000f0\f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lgg/essential/util/CachedAvatarImage;", "", "()V", "LOGGER", "Lgg/essential/lib/slf4j/Logger;", "kotlin.jvm.PlatformType", "cacheBasePath", "Ljava/nio/file/Path;", "cachePath", "gg/essential/util/CachedAvatarImage$cachePath$1", "Lgg/essential/util/CachedAvatarImage$cachePath$1;", "diskCache", "Lgg/essential/lib/caffeine/cache/AsyncLoadingCache;", "Ljava/util/UUID;", "Ljava/util/Optional;", "Ljava/awt/image/BufferedImage;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "fallbackImage", "Lgg/essential/elementa/components/image/BlurHashImage;", "freshCache", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "getHttpClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "create", "Lgg/essential/elementa/UIComponent;", "uuid", "createHttpClient", "loadFromDisk", "loadFromWeb", "ofUUID", "Lgg/essential/elementa/components/UIImage;", "toDashlessString", "", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nCachedAvatarImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedAvatarImage.kt\ngg/essential/util/CachedAvatarImage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 layout.kt\ngg/essential/gui/layoutdsl/LayoutKt\n*L\n1#1,192:1\n1#2:193\n305#3,6:194\n*S KotlinDebug\n*F\n+ 1 CachedAvatarImage.kt\ngg/essential/util/CachedAvatarImage\n*L\n184#1:194,6\n*E\n"})
public final class CachedAvatarImage {
    @NotNull
    public static final CachedAvatarImage INSTANCE = new CachedAvatarImage();
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedAvatarImage.class);
    private static final Path cacheBasePath = GuiEssentialPlatform.Companion.getPlatform$essential_gui_essential().getEssentialBaseDir().resolve("avatar-cache");
    @NotNull
    private static final cachePath.1 cachePath = new Object(){

        @NotNull
        public final Path get(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            String it = CachedAvatarImage.access$toDashlessString(CachedAvatarImage.INSTANCE, uuid);
            boolean bl = false;
            Path path = CachedAvatarImage.access$getCacheBasePath$p().resolve(String.valueOf(it.charAt(0))).resolve(String.valueOf(it.charAt(1)));
            String string = it.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Path path2 = path.resolve(string);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"let(...)");
            return path2;
        }
    };
    @NotNull
    private static final AsyncLoadingCache<UUID, BufferedImage> freshCache;
    @NotNull
    private static final AsyncLoadingCache<UUID, Optional<BufferedImage>> diskCache;
    @NotNull
    private static final BlurHashImage fallbackImage;
    @NotNull
    private static final Lazy httpClient$delegate;

    private CachedAvatarImage() {
    }

    private final CloseableHttpClient getHttpClient() {
        Lazy lazy2 = httpClient$delegate;
        return (CloseableHttpClient)lazy2.getValue();
    }

    private final BufferedImage loadFromDisk(UUID uuid) {
        BufferedImage bufferedImage;
        Path path = cachePath.get(uuid);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        try {
            bufferedImage = ImageIO.read(path.toFile());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load avatar " + uuid + " from cache: ", e);
            bufferedImage = null;
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BufferedImage loadFromWeb(UUID uuid) {
        Object e2;
        FileAttribute[] fileAttributeArray;
        Object request2;
        String url = "https://crafthead.net/helm/" + this.toDashlessString(uuid);
        try {
            byte[] byArray;
            request2 = new HttpGet(url);
            CloseableHttpResponse response2 = this.getHttpClient().execute((HttpUriRequest)request2);
            fileAttributeArray = (FileAttribute[])response2.getEntity().getContent();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)fileAttributeArray;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)fileAttributeArray, (Throwable)throwable);
            }
            byte[] content = byArray;
            if (response2.getStatusLine().getStatusCode() != 200) {
                LOGGER.warn("Non-OK status code received when fetching " + url + ": " + new String(content, Charsets.UTF_8));
                return null;
            }
            request2 = content;
        }
        catch (Exception e2) {
            LOGGER.warn("Failed to fetch " + url + ": ", e2);
            return null;
        }
        Object bytes = request2;
        try {
            e2 = ImageIO.read(new ByteArrayInputStream((byte[])bytes));
        }
        catch (Exception e3) {
            LOGGER.warn("Failed read avatar " + uuid + " image: ", e3);
            return null;
        }
        BufferedImage image2 = e2;
        ConcurrentMap<UUID, CompletableFuture<Optional<BufferedImage>>> concurrentMap = diskCache.asMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"asMap(...)");
        e2 = concurrentMap;
        Object object = CompletableFuture.completedFuture(Optional.of(image2));
        e2.put(uuid, object);
        try {
            Path path = cachePath.get(uuid);
            Path path2 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            object = path2;
            fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write(path, (byte[])bytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
        }
        catch (Exception e2) {
            LOGGER.warn("Failed to write avatar " + uuid + " cache: ", e2);
            return null;
        }
        return image2;
    }

    private final CloseableHttpClient createHttpClient() {
        SSLContext sslContext = (SSLContext)new CertChain().loadEmbedded().done().component1();
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setUserAgent("Essential/" + new VersionInfo().getEssentialVersion() + " (https://essential.gg)").setSslcontext(sslContext).build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"build(...)");
        return closeableHttpClient;
    }

    @JvmStatic
    @Deprecated(message="Use create(uuid) instead", replaceWith=@ReplaceWith(expression="create(uuid)", imports={}))
    @NotNull
    public static final UIImage ofUUID(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletionStage freshFuture2 = freshCache.get(uuid).thenApply(arg_0 -> CachedAvatarImage.ofUUID$lambda$3(ofUUID.freshFuture.1.INSTANCE, arg_0));
        if (((CompletableFuture)freshFuture2).isDone()) {
            CompletableFuture completableFuture = ((CompletableFuture)freshFuture2).toCompletableFuture();
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"toCompletableFuture(...)");
            return new UIImage(completableFuture, fallbackImage, null, 4, null);
        }
        CompletionStage diskFuture2 = diskCache.get(uuid).thenCompose(arg_0 -> CachedAvatarImage.ofUUID$lambda$4((Function1)new Function1<Optional<BufferedImage>, CompletionStage<BufferedImage>>((CompletableFuture<BufferedImage>)freshFuture2){
            final /* synthetic */ CompletableFuture<BufferedImage> $freshFuture;
            {
                this.$freshFuture = $freshFuture;
                super(1);
            }

            public final CompletionStage<BufferedImage> invoke(Optional<BufferedImage> it) {
                return it.map(arg_0 -> ofUUID.diskFuture.1.invoke$lambda$0(ofUUID.diskFuture.1.INSTANCE, arg_0)).orElse(this.$freshFuture);
            }

            private static final CompletableFuture invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CompletableFuture)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNull((Object)freshFuture2);
        Intrinsics.checkNotNull((Object)diskFuture2);
        return new UIImage((CompletableFuture)freshFuture2, new UIImage((CompletableFuture)diskFuture2, fallbackImage, null, 4, null), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final UIComponent create(@NotNull UUID uuid) {
        void $this$layout$iv;
        UIImage uIImage;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CompletionStage freshFuture2 = freshCache.get(uuid).thenApply(arg_0 -> CachedAvatarImage.create$lambda$5(create.freshFuture.1.INSTANCE, arg_0));
        if (((CompletableFuture)freshFuture2).isDone()) {
            CompletableFuture completableFuture = ((CompletableFuture)freshFuture2).toCompletableFuture();
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"toCompletableFuture(...)");
            uIImage = new UIImage(completableFuture, fallbackImage, null, 4, null);
        } else {
            CompletionStage diskFuture2 = diskCache.get(uuid).thenCompose(arg_0 -> CachedAvatarImage.create$lambda$6((Function1)new Function1<Optional<BufferedImage>, CompletionStage<BufferedImage>>((CompletableFuture<BufferedImage>)freshFuture2){
                final /* synthetic */ CompletableFuture<BufferedImage> $freshFuture;
                {
                    this.$freshFuture = $freshFuture;
                    super(1);
                }

                public final CompletionStage<BufferedImage> invoke(Optional<BufferedImage> it) {
                    return it.map(arg_0 -> create.image.diskFuture.1.invoke$lambda$0(create.image.diskFuture.1.INSTANCE, arg_0)).orElse(this.$freshFuture);
                }

                private static final CompletableFuture invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (CompletableFuture)$tmp0.invoke(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)freshFuture2);
            Intrinsics.checkNotNull((Object)diskFuture2);
            uIImage = new UIImage((CompletableFuture)freshFuture2, new UIImage((CompletableFuture)diskFuture2, fallbackImage, null, 4, null), null, 4, null);
        }
        UIImage image2 = uIImage;
        UIContainer uiContainer = new UIContainer();
        UIComponent uIComponent = uiContainer;
        Modifier modifier$iv = SizeKt.heightAspect(SizeKt.width((Modifier)Modifier.Companion, 8.0f), 1.0f);
        boolean $i$f$layout = false;
        modifier$iv.applyToComponent((UIComponent)$this$layout$iv);
        LayoutScope $this$create_u24lambda_u247 = new LayoutScope((UIComponent)$this$layout$iv, null, (ReferenceHolder)$this$layout$iv);
        boolean bl = false;
        LayoutScope.invoke$default($this$create_u24lambda_u247, image2, SizeKt.fillParent$default(Modifier.Companion, 0.0f, 0.0f, 3, null), null, 2, null);
        return uiContainer;
    }

    private final String toDashlessString(UUID $this$toDashlessString) {
        String string = $this$toDashlessString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    private static final BufferedImage freshCache$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.loadFromWeb(it);
    }

    private static final Optional diskCache$lambda$1(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Optional.ofNullable(INSTANCE.loadFromDisk(it));
    }

    private static final BufferedImage ofUUID$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BufferedImage)$tmp0.invoke(p0);
    }

    private static final CompletionStage ofUUID$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final BufferedImage create$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BufferedImage)$tmp0.invoke(p0);
    }

    private static final CompletionStage create$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$toDashlessString(CachedAvatarImage $this, UUID $receiver) {
        return $this.toDashlessString($receiver);
    }

    public static final /* synthetic */ Path access$getCacheBasePath$p() {
        return cacheBasePath;
    }

    public static final /* synthetic */ CloseableHttpClient access$createHttpClient(CachedAvatarImage $this) {
        return $this.createHttpClient();
    }

    static {
        AsyncLoadingCache<UUID, BufferedImage> asyncLoadingCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())).buildAsync(CachedAvatarImage::freshCache$lambda$0);
        Intrinsics.checkNotNullExpressionValue(asyncLoadingCache, (String)"buildAsync(...)");
        freshCache = asyncLoadingCache;
        AsyncLoadingCache<UUID, Optional> asyncLoadingCache2 = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())).buildAsync(CachedAvatarImage::diskCache$lambda$1);
        Intrinsics.checkNotNullExpressionValue(asyncLoadingCache2, (String)"buildAsync(...)");
        diskCache = asyncLoadingCache2;
        fallbackImage = new BlurHashImage("U9QuA+e8vyu48wVsVYkq_~tlP9Z~Y7pIyXVX");
        httpClient$delegate = LazyKt.lazy((Function0)httpClient.2.INSTANCE);
    }
}

