/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\fJ-\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J=\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\r\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0006J!\u0010 \u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b \u0010!J-\u0010#\u001a\u00020\b2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\"\u00a2\u0006\u0004\b#\u0010$J+\u0010%\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u000b\u001a\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0002\u00a2\u0006\u0004\b%\u0010&R$\u0010(\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R$\u0010,\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b,\u0010)\u001a\u0004\b-\u0010+R$\u0010\u0004\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0004\u0010)\u001a\u0004\b.\u0010+R$\u0010/\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b/\u0010)\u001a\u0004\b0\u0010+R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b1\u0010+\u00a8\u00062"}, d2={"Lgg/essential/util/GlFrameBuffer;", "", "", "width", "height", "<init>", "(II)V", "Lkotlin/Function0;", "", "bind", "()Lkotlin/jvm/functions/Function0;", "glId", "(I)Lkotlin/jvm/functions/Function0;", "Ljava/awt/Color;", "clearColor", "", "clearDepth", "clearStencil", "clear", "(Ljava/awt/Color;DI)V", "delete", "()V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "x", "y", "color", "drawTexture", "(Lgg/essential/universal/UMatrixStack;DDDDLjava/awt/Color;)V", "resize", "T", "block", "use", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlin/Function3;", "useAsRenderTarget", "(Lkotlin/jvm/functions/Function3;)V", "withFrameBuffer", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "<set-?>", "depthStencil", "I", "getDepthStencil", "()I", "frameBuffer", "getFrameBuffer", "getHeight", "texture", "getTexture", "getWidth", "Essential 1.19.2-forge"})
public final class GlFrameBuffer {
    private int width;
    private int height;
    private int frameBuffer;
    private int texture;
    private int depthStencil;

    public GlFrameBuffer(int width2, int height2) {
        this.width = width2;
        this.height = height2;
        this.frameBuffer = -1;
        this.texture = -1;
        this.depthStencil = -1;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getFrameBuffer() {
        return this.frameBuffer;
    }

    public final int getTexture() {
        return this.texture;
    }

    public final int getDepthStencil() {
        return this.depthStencil;
    }

    public final void resize(int width2, int height2) {
        if (this.width == width2 && this.height == height2 && this.frameBuffer != -1) {
            return;
        }
        this.width = width2;
        this.height = height2;
        this.delete();
        this.frameBuffer = GL30.glGenFramebuffers();
        this.texture = GL11.glGenTextures();
        this.depthStencil = GL11.glGenTextures();
        UGraphics.configureTexture(this.texture, () -> GlFrameBuffer.resize$lambda$0(width2, height2));
        UGraphics.configureTexture(this.depthStencil, () -> GlFrameBuffer.resize$lambda$1(width2, height2));
        this.withFrameBuffer(this.frameBuffer, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GlFrameBuffer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.this$0.getTexture(), (int)0);
                GL30.glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)this.this$0.getDepthStencil(), (int)0);
            }
        });
    }

    public final void delete() {
        if (this.depthStencil != -1) {
            GL11.glDeleteTextures((int)this.depthStencil);
            this.depthStencil = -1;
        }
        if (this.texture != -1) {
            GL11.glDeleteTextures((int)this.texture);
            this.texture = -1;
        }
        if (this.frameBuffer != -1) {
            GL30.glDeleteFramebuffers((int)this.frameBuffer);
            this.frameBuffer = -1;
        }
    }

    public final <T> T use(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.frameBuffer == -1) {
            this.resize(this.width, this.height);
        }
        return this.withFrameBuffer(this.frameBuffer, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withFrameBuffer(int glId, Function0<? extends T> block) {
        Function0<Unit> unbind = this.bind(glId);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            unbind.invoke();
        }
    }

    public final void useAsRenderTarget(@NotNull Function3<? super UMatrixStack, ? super Integer, ? super Integer, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.use((Function0)new Function0<Unit>(this, block){
            final /* synthetic */ GlFrameBuffer this$0;
            final /* synthetic */ Function3<UMatrixStack, Integer, Integer, Unit> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            public final void invoke() {
                boolean scissorState = GL11.glGetBoolean((int)3089);
                GL11.glDisable((int)3089);
                GL11.glViewport((int)0, (int)0, (int)this.this$0.getWidth(), (int)this.this$0.getHeight());
                UMatrixStack stack = new UMatrixStack();
                double scale2 = 1.0 / UResolution.getScaleFactor();
                stack.scale(scale2 * (double)UResolution.getViewportWidth() / (double)this.this$0.getWidth(), scale2 * (double)UResolution.getViewportHeight() / (double)this.this$0.getHeight(), 1.0);
                this.$block.invoke((Object)stack, (Object)this.this$0.getWidth(), (Object)this.this$0.getHeight());
                GL11.glViewport((int)0, (int)0, (int)UResolution.getViewportWidth(), (int)UResolution.getViewportHeight());
                if (scissorState) {
                    GL11.glEnable((int)3089);
                }
            }
        });
    }

    public final void drawTexture(@NotNull UMatrixStack matrixStack, double x, double y, double width2, double height2, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        matrixStack.push();
        UGraphics.enableBlend();
        UGraphics.enableAlpha();
        matrixStack.scale(1.0f, 1.0f, 50.0f);
        UGraphics.bindTexture(0, this.texture);
        float red = (float)color2.getRed() / 255.0f;
        float green = (float)color2.getGreen() / 255.0f;
        float blue = (float)color2.getBlue() / 255.0f;
        float alpha = (float)color2.getAlpha() / 255.0f;
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, DefaultVertexFormat.f_85819_);
        worldRenderer.pos(matrixStack, x, y + height2, 0.0).tex(0.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width2, y + height2, 0.0).tex(1.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width2, y, 0.0).tex(1.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x, y, 0.0).tex(0.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.drawDirect();
        UGraphics.bindTexture(0, 0);
        matrixStack.pop();
    }

    @NotNull
    public final Function0<Unit> bind() {
        if (this.frameBuffer == -1) {
            this.resize(this.width, this.height);
        }
        return this.bind(this.frameBuffer);
    }

    private final Function0<Unit> bind(int glId) {
        int prevReadFrameBufferBinding = GL11.glGetInteger((int)36010);
        int prevDrawFrameBufferBinding = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)glId);
        return (Function0)new Function0<Unit>(prevReadFrameBufferBinding, prevDrawFrameBufferBinding){
            final /* synthetic */ int $prevReadFrameBufferBinding;
            final /* synthetic */ int $prevDrawFrameBufferBinding;
            {
                this.$prevReadFrameBufferBinding = $prevReadFrameBufferBinding;
                this.$prevDrawFrameBufferBinding = $prevDrawFrameBufferBinding;
                super(0);
            }

            public final void invoke() {
                GL30.glBindFramebuffer((int)36008, (int)this.$prevReadFrameBufferBinding);
                GL30.glBindFramebuffer((int)36009, (int)this.$prevDrawFrameBufferBinding);
            }
        };
    }

    @JvmOverloads
    public final void clear(@NotNull Color clearColor, double clearDepth, int clearStencil) {
        Intrinsics.checkNotNullParameter((Object)clearColor, (String)"clearColor");
        this.use((Function0)new Function0<Unit>(clearColor, clearDepth, clearStencil){
            final /* synthetic */ Color $clearColor;
            final /* synthetic */ double $clearDepth;
            final /* synthetic */ int $clearStencil;
            {
                this.$clearColor = $clearColor;
                this.$clearDepth = $clearDepth;
                this.$clearStencil = $clearStencil;
                super(0);
            }

            public final void invoke() {
                Color $this$invoke_u24lambda_u240 = this.$clearColor;
                boolean bl = false;
                RenderSystem.m_69424_((float)((float)$this$invoke_u24lambda_u240.getRed() / 255.0f), (float)((float)$this$invoke_u24lambda_u240.getGreen() / 255.0f), (float)((float)$this$invoke_u24lambda_u240.getBlue() / 255.0f), (float)((float)$this$invoke_u24lambda_u240.getAlpha() / 255.0f));
                RenderSystem.m_69430_((double)this.$clearDepth);
                GL11.glClearStencil((int)this.$clearStencil);
                GL11.glClear((int)17664);
            }
        });
    }

    public static /* synthetic */ void clear$default(GlFrameBuffer glFrameBuffer, Color color2, double d, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            color2 = new Color(0, 0, 0, 0);
        }
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        glFrameBuffer.clear(color2, d, n);
    }

    @JvmOverloads
    public final void clear(@NotNull Color clearColor, double clearDepth) {
        Intrinsics.checkNotNullParameter((Object)clearColor, (String)"clearColor");
        GlFrameBuffer.clear$default(this, clearColor, clearDepth, 0, 4, null);
    }

    @JvmOverloads
    public final void clear(@NotNull Color clearColor) {
        Intrinsics.checkNotNullParameter((Object)clearColor, (String)"clearColor");
        GlFrameBuffer.clear$default(this, clearColor, 0.0, 0, 6, null);
    }

    @JvmOverloads
    public final void clear() {
        GlFrameBuffer.clear$default(this, null, 0.0, 0, 7, null);
    }

    private static final void resize$lambda$0(int $width, int $height) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)$width, (int)$height, (int)0, (int)6408, (int)5121, null);
    }

    private static final void resize$lambda$1(int $width, int $height) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)35056, (int)$width, (int)$height, (int)0, (int)34041, (int)34042, null);
    }
}

