/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.elementa.components.Window;
import gg.essential.event.client.ReAuthEvent;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.gui.overlay.ModalManagerImpl;
import gg.essential.gui.overlay.OverlayManagerImpl;
import gg.essential.gui.util.ElementaExtensionsKt;
import gg.essential.handlers.PauseMenuDisplay;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.util.Color;
import gg.essential.network.CMConnection;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.universal.UImage;
import gg.essential.universal.UScreen;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.GuiEssentialPlatform;
import gg.essential.util.HelpersKt;
import gg.essential.util.MinecraftCoroutineDispatchers;
import gg.essential.util.ResourceManagerUtil;
import gg.essential.util.ServerType;
import gg.essential.util.UIdentifier;
import gg.essential.util.UIdentifierKt;
import gg.essential.util.USession;
import gg.essential.util.image.bitmap.Bitmap;
import gg.essential.util.image.bitmap.MutableBitmap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010!\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010'\u001a\u00020\t2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010+\u001a\u00020%2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,R\u0014\u00100\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00104\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00108\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010<\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010@\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010D\u001a\u00020A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0014\u0010F\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010/\u00a8\u0006G"}, d2={"Lgg/essential/util/GuiEssentialPlatformImpl;", "Lgg/essential/util/GuiEssentialPlatform;", "<init>", "()V", "Ljava/io/InputStream;", "inputStream", "Lgg/essential/util/image/bitmap/MutableBitmap;", "bitmapFromInputStream", "(Ljava/io/InputStream;)Lgg/essential/util/image/bitmap/MutableBitmap;", "Lgg/essential/util/UIdentifier;", "identifier", "bitmapFromMinecraftResource", "(Lgg/essential/util/UIdentifier;)Lgg/essential/util/image/bitmap/MutableBitmap;", "Lgg/essential/gui/overlay/ModalManager;", "createModalManager", "()Lgg/essential/gui/overlay/ModalManager;", "Lgg/essential/util/ServerType;", "currentServerType", "()Lgg/essential/util/ServerType;", "Lgg/essential/gui/common/modal/Modal;", "modal", "Lkotlin/Function0;", "", "dismiss", "dismissModalOnScreenChange", "(Lgg/essential/gui/common/modal/Modal;Lkotlin/jvm/functions/Function0;)V", "Ljava/lang/Runnable;", "runnable", "onResourceManagerReload", "(Ljava/lang/Runnable;)V", "Lgg/essential/gui/elementa/state/v2/MutableState;", "Lgg/essential/util/USession;", "state", "registerActiveSessionState", "(Lgg/essential/gui/elementa/state/v2/MutableState;)V", "", "name", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "texture", "registerCosmeticTexture", "(Ljava/lang/String;Lgg/essential/universal/utils/ReleasedDynamicTexture;)Lgg/essential/util/UIdentifier;", "Lgg/essential/universal/UImage;", "uImage", "uImageIntoReleasedDynamicTexture", "(Lgg/essential/universal/UImage;)Lgg/essential/universal/utils/ReleasedDynamicTexture;", "Lkotlinx/coroutines/CoroutineDispatcher;", "getClientThreadDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "clientThreadDispatcher", "Lgg/essential/network/CMConnection;", "getCmConnection", "()Lgg/essential/network/CMConnection;", "cmConnection", "Lgg/essential/util/GuiEssentialPlatform$Config;", "getConfig", "()Lgg/essential/util/GuiEssentialPlatform$Config;", "config", "Ljava/nio/file/Path;", "getEssentialBaseDir", "()Ljava/nio/file/Path;", "essentialBaseDir", "Lgg/essential/elementa/components/Window;", "getPauseMenuDisplayWindow", "()Lgg/essential/elementa/components/Window;", "pauseMenuDisplayWindow", "Lgg/essential/model/backend/RenderBackend;", "getRenderBackend", "()Lgg/essential/model/backend/RenderBackend;", "renderBackend", "getRenderThreadDispatcher", "renderThreadDispatcher", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nGuiEssentialPlatformImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiEssentialPlatformImpl.kt\ngg/essential/util/GuiEssentialPlatformImpl\n+ 2 extensions.kt\ngg/essential/util/image/bitmap/ExtensionsKt\n*L\n1#1,162:1\n35#2,6:163\n*S KotlinDebug\n*F\n+ 1 GuiEssentialPlatformImpl.kt\ngg/essential/util/GuiEssentialPlatformImpl\n*L\n78#1:163,6\n*E\n"})
public final class GuiEssentialPlatformImpl
implements GuiEssentialPlatform {
    @Override
    @NotNull
    public CoroutineDispatcher getClientThreadDispatcher() {
        return MinecraftCoroutineDispatchers.INSTANCE.getClientThread();
    }

    @Override
    @NotNull
    public CoroutineDispatcher getRenderThreadDispatcher() {
        return MinecraftCoroutineDispatchers.INSTANCE.getRenderThread();
    }

    @Override
    @NotNull
    public RenderBackend getRenderBackend() {
        return MinecraftRenderBackend.INSTANCE;
    }

    @Override
    @NotNull
    public CMConnection getCmConnection() {
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        return connectionManager;
    }

    @Override
    @NotNull
    public ModalManager createModalManager() {
        return new ModalManagerImpl(OverlayManagerImpl.INSTANCE, null, 2, null);
    }

    @Override
    public void onResourceManagerReload(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        ResourceManagerUtil.INSTANCE.onResourceManagerReload((Function0<Unit>)((Function0)new Function0<Unit>(runnable){
            final /* synthetic */ Runnable $runnable;
            {
                this.$runnable = $runnable;
                super(0);
            }

            public final void invoke() {
                this.$runnable.run();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MutableBitmap bitmapFromMinecraftResource(@NotNull UIdentifier identifier2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        Resource resource = ResourceManagerUtil.INSTANCE.getResource(UIdentifierKt.toMC(identifier2));
        if (resource == null) {
            return null;
        }
        Resource resource2 = resource;
        Closeable closeable = resource2.m_215507_();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            MutableBitmap mutableBitmap = this.bitmapFromInputStream(it);
            return mutableBitmap;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableBitmap bitmapFromInputStream(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        UImage image2 = ExtensionsKt.read(UImage.Companion, inputStream);
        MutableBitmap bitmap = Bitmap.Companion.ofSize(image2.getWidth(), image2.getHeight());
        Bitmap $this$forEachPixel$iv = bitmap;
        boolean $i$f$forEachPixel = false;
        int n = $this$forEachPixel$iv.getHeight();
        for (int y$iv = 0; y$iv < n; ++y$iv) {
            int x$iv = 0;
            int n2 = $this$forEachPixel$iv.getWidth();
            while (x$iv < n2) {
                void y;
                void x;
                $this$forEachPixel$iv.get-XEV4ZDs(x$iv, y$iv);
                int n3 = y$iv;
                int n4 = x$iv++;
                boolean bl = false;
                bitmap.set-gk-R20I((int)x, (int)y, Color.constructor-impl(UInt.constructor-impl((int)image2.getPixelRGBA((int)x, (int)y))));
            }
        }
        image2.getNativeImage().close();
        return bitmap;
    }

    @Override
    @NotNull
    public ReleasedDynamicTexture uImageIntoReleasedDynamicTexture(@NotNull UImage uImage) {
        Intrinsics.checkNotNullParameter((Object)uImage, (String)"uImage");
        return new ReleasedDynamicTexture(uImage.getNativeImage());
    }

    @Override
    @NotNull
    public UIdentifier registerCosmeticTexture(@NotNull String name2, @NotNull ReleasedDynamicTexture texture) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)texture), (String)"texture");
        return UIdentifierKt.toU(new MinecraftRenderBackend.CosmeticTexture(name2, texture).getIdentifier());
    }

    @Override
    public void dismissModalOnScreenChange(@NotNull Modal modal2, @NotNull Function0<Unit> dismiss) {
        Intrinsics.checkNotNullParameter((Object)modal2, (String)"modal");
        Intrinsics.checkNotNullParameter(dismiss, (String)"dismiss");
        Ref.ObjectRef screen = new Ref.ObjectRef();
        screen.element = UScreen.Companion.getCurrentScreen();
        ElementaExtensionsKt.onAnimationFrame(modal2, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<Screen>)screen, dismiss){
            final /* synthetic */ Ref.ObjectRef<Screen> $screen;
            final /* synthetic */ Function0<Unit> $dismiss;
            {
                this.$screen = $screen;
                this.$dismiss = $dismiss;
                super(0);
            }

            public final void invoke() {
                Screen newScreen = UScreen.Companion.getCurrentScreen();
                if (newScreen == null || Intrinsics.areEqual((Object)newScreen, (Object)this.$screen.element) || newScreen instanceof OverlayManagerImpl.OverlayInteractionScreen) {
                    return;
                }
                this.$screen.element = UScreen.Companion.getCurrentScreen();
                Window.Companion.enqueueRenderOperation((Function0<Unit>)((Function0)new Function0<Unit>(this.$dismiss){
                    final /* synthetic */ Function0<Unit> $dismiss;
                    {
                        this.$dismiss = $dismiss;
                        super(0);
                    }

                    public final void invoke() {
                        this.$dismiss.invoke();
                    }
                }));
            }
        }));
    }

    @Override
    @NotNull
    public Path getEssentialBaseDir() {
        Path path = Essential.getInstance().getBaseDir().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @Override
    @NotNull
    public GuiEssentialPlatform.Config getConfig() {
        return EssentialConfig.INSTANCE;
    }

    @Override
    @NotNull
    public Window getPauseMenuDisplayWindow() {
        return PauseMenuDisplay.Companion.getWindow();
    }

    @Override
    @Nullable
    public ServerType currentServerType() {
        Minecraft minecraft = Minecraft.m_91087_();
        SPSManager sPSManager = Essential.getInstance().getConnectionManager().getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        SPSManager spsManager = sPSManager;
        UPnPSession localSpsSession = spsManager.getLocalSession();
        if (localSpsSession != null) {
            UUID uUID = localSpsSession.getHostUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getHostUUID(...)");
            return new ServerType.SPS.Host(uUID);
        }
        if (minecraft.m_91091_()) {
            return ServerType.Singleplayer.INSTANCE;
        }
        if (minecraft.m_91294_()) {
            return ServerType.Realms.INSTANCE;
        }
        ServerData serverData = minecraft.m_91089_();
        if (serverData == null) {
            return null;
        }
        ServerData serverData2 = serverData;
        UUID remoteSpsHost = spsManager.getHostFromSpsAddress(serverData2.f_105363_);
        if (remoteSpsHost != null) {
            return new ServerType.SPS.Guest(remoteSpsHost);
        }
        String string = serverData2.f_105362_;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String string2 = serverData2.f_105363_;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ip");
        return new ServerType.Multiplayer(string, string2);
    }

    @Override
    public void registerActiveSessionState(@NotNull MutableState<USession> state2) {
        Intrinsics.checkNotNullParameter(state2, (String)"state");
        User user = Minecraft.m_91087_().m_91094_();
        Intrinsics.checkNotNullExpressionValue((Object)user, (String)"getUser(...)");
        state2.set(HelpersKt.toUSession(user));
        Essential.EVENT_BUS.register(new Object(state2){
            final /* synthetic */ MutableState<USession> $state;
            {
                this.$state = $state;
            }

            @Subscribe(priority=1000)
            private final void onReAuth(ReAuthEvent event) {
                USession uSession = event.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)uSession, (String)"getSession(...)");
                this.$state.set(uSession);
            }
        });
    }
}

