/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.data.VersionInfo;
import gg.essential.handlers.CertChain;
import gg.essential.lib.okhttp3.Interceptor;
import gg.essential.lib.okhttp3.OkHttpClient;
import gg.essential.lib.okhttp3.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"httpClient", "Ljava/util/concurrent/CompletableFuture;", "Lgg/essential/lib/okhttp3/OkHttpClient;", "getHttpClient", "()Ljava/util/concurrent/CompletableFuture;", "essential-gui-essential"})
@JvmName(name="HttpUtils")
public final class HttpUtils {
    @NotNull
    private static final CompletableFuture<OkHttpClient> httpClient;

    @NotNull
    public static final CompletableFuture<OkHttpClient> getHttpClient() {
        return httpClient;
    }

    private static final Response httpClient$lambda$1$lambda$0(Interceptor.Chain it) {
        return it.proceed(it.request().newBuilder().header("User-Agent", "Essential/" + new VersionInfo().getEssentialVersion() + " (https://essential.gg)").build());
    }

    private static final OkHttpClient httpClient$lambda$1() {
        Pair<SSLContext, TrustManager[]> pair = new CertChain().loadEmbedded().done();
        SSLContext sslContext = (SSLContext)pair.component1();
        TrustManager[] trustManagers = (TrustManager[])pair.component2();
        TrustManager trustManager = trustManagers[0];
        Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        X509TrustManager trustManager2 = (X509TrustManager)trustManager;
        return new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), trustManager2).readTimeout(60L, TimeUnit.SECONDS).addInterceptor(HttpUtils::httpClient$lambda$1$lambda$0).build();
    }

    static {
        CompletableFuture<OkHttpClient> completableFuture = CompletableFuture.supplyAsync(HttpUtils::httpClient$lambda$1);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        httpClient = completableFuture;
    }
}

