/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import gg.essential.api.utils.TrustedHostsUtil;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ClientProfileTrustedHostsCreatePacket;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ClientProfileTrustedHostsDeletePacket;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.profiles.model.TrustedHost;
import gg.essential.universal.wrappers.UPlayer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\u00020\u0004*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u0013*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lgg/essential/util/TrustedHostsUtil;", "Lgg/essential/api/utils/TrustedHostsUtil;", "<init>", "()V", "Lgg/essential/api/utils/TrustedHostsUtil$TrustedHost;", "host", "", "addTrustedHost", "(Lgg/essential/api/utils/TrustedHostsUtil$TrustedHost;)V", "", "id", "getTrustedHostByID", "(Ljava/lang/String;)Lgg/essential/api/utils/TrustedHostsUtil$TrustedHost;", "", "getTrustedHosts", "()Ljava/util/Set;", "hostId", "removeTrustedHost", "(Ljava/lang/String;)V", "Lgg/essential/profiles/model/TrustedHost;", "toApiHost", "(Lgg/essential/profiles/model/TrustedHost;)Lgg/essential/api/utils/TrustedHostsUtil$TrustedHost;", "toModel", "(Lgg/essential/api/utils/TrustedHostsUtil$TrustedHost;)Lgg/essential/profiles/model/TrustedHost;", "Essential 1.19.2-forge"})
@SourceDebugExtension(value={"SMAP\nTrustedHostsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrustedHostsUtil.kt\ngg/essential/util/TrustedHostsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1855#2,2:49\n*S KotlinDebug\n*F\n+ 1 TrustedHostsUtil.kt\ngg/essential/util/TrustedHostsUtil\n*L\n25#1:49,2\n*E\n"})
public final class TrustedHostsUtil
implements gg.essential.api.utils.TrustedHostsUtil {
    @NotNull
    public static final TrustedHostsUtil INSTANCE = new TrustedHostsUtil();

    private TrustedHostsUtil() {
    }

    @Override
    @NotNull
    public Set<TrustedHostsUtil.TrustedHost> getTrustedHosts() {
        Collection<TrustedHost> hosts = Essential.getInstance().getConnectionManager().getProfileManager().getTrustedHosts().values();
        Set a = new LinkedHashSet();
        Iterable $this$forEach$iv = hosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrustedHost it = (TrustedHost)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            a.add(INSTANCE.toApiHost(it));
        }
        return a;
    }

    @Override
    @Nullable
    public TrustedHostsUtil.TrustedHost getTrustedHostByID(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        TrustedHost trustedHost = Essential.getInstance().getConnectionManager().getProfileManager().getTrustedHosts().get(id2);
        return trustedHost != null ? this.toApiHost(trustedHost) : null;
    }

    @Override
    public void addTrustedHost(@NotNull TrustedHostsUtil.TrustedHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        ConnectionManager cm = connectionManager;
        cm.getProfileManager().addTrustedHost(this.toModel(host));
        cm.send(new ClientProfileTrustedHostsCreatePacket(host.getName(), host.getDomains()));
    }

    @Override
    public void removeTrustedHost(@NotNull String hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        ConnectionManager cm = connectionManager;
        cm.getProfileManager().removeTrustedHost(hostId);
        cm.send(new ClientProfileTrustedHostsDeletePacket(hostId));
    }

    private final TrustedHostsUtil.TrustedHost toApiHost(TrustedHost $this$toApiHost) {
        String string = $this$toApiHost.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$toApiHost.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Set<String> set2 = $this$toApiHost.getDomains();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getDomains(...)");
        return new TrustedHostsUtil.TrustedHost(string, string2, set2);
    }

    private final TrustedHost toModel(TrustedHostsUtil.TrustedHost $this$toModel) {
        return new TrustedHost($this$toModel.getId(), $this$toModel.getName(), $this$toModel.getDomains(), UPlayer.getUUID());
    }
}

