/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.impl.nightconfig.core;

import gg.essential.vigilance.impl.nightconfig.core.Config;
import gg.essential.vigilance.impl.nightconfig.core.ConfigFormat;
import gg.essential.vigilance.impl.nightconfig.core.utils.ConfigWrapper;
import gg.essential.vigilance.impl.nightconfig.core.utils.TransformingMap;
import gg.essential.vigilance.impl.nightconfig.core.utils.TransformingSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CheckedConfig
extends ConfigWrapper<Config> {
    CheckedConfig(Config config) {
        super(config);
        config.valueMap().forEach((k, v) -> this.checkValue(v));
    }

    @Override
    public Config checked() {
        return this;
    }

    @Override
    public <T> T set(List<String> path, Object value2) {
        return super.set(path, this.checkedValue(value2));
    }

    @Override
    public boolean add(List<String> path, Object value2) {
        return super.add(path, this.checkedValue(value2));
    }

    @Override
    public Map<String, Object> valueMap() {
        return new TransformingMap<String, Object, Object>(super.valueMap(), v -> v, this::checkedValue, o -> o);
    }

    @Override
    public Set<? extends Config.Entry> entrySet() {
        return new TransformingSet<Config.Entry, Config.Entry>(super.entrySet(), v -> v, this::checkedValue, o -> o);
    }

    @Override
    public String toString() {
        return "checked of " + this.config;
    }

    private void checkValue(Object value2) {
        ConfigFormat<?> format = this.configFormat();
        if (value2 != null && !format.supportsType(value2.getClass())) {
            throw new IllegalArgumentException("Unsupported value type: " + value2.getClass().getTypeName());
        }
        if (value2 == null && !format.supportsType(null)) {
            throw new IllegalArgumentException("Null values aren't supported by this configuration.");
        }
        if (value2 instanceof Config) {
            ((Config)value2).valueMap().forEach((k, v) -> this.checkValue(v));
        }
    }

    private <T> T checkedValue(T value2) {
        this.checkValue(value2);
        return value2;
    }
}

