/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.impl.nightconfig.core.conversion;

import gg.essential.vigilance.impl.nightconfig.core.EnumGetMethod;
import gg.essential.vigilance.impl.nightconfig.core.conversion.AdvancedPath;
import gg.essential.vigilance.impl.nightconfig.core.conversion.Conversion;
import gg.essential.vigilance.impl.nightconfig.core.conversion.Converter;
import gg.essential.vigilance.impl.nightconfig.core.conversion.InvalidValueException;
import gg.essential.vigilance.impl.nightconfig.core.conversion.Path;
import gg.essential.vigilance.impl.nightconfig.core.conversion.PreserveNotNull;
import gg.essential.vigilance.impl.nightconfig.core.conversion.ReflectionException;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecClassInArray;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecDoubleInRange;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecEnum;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecFloatInRange;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecIntInRange;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecLongInRange;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecNotNull;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecStringInArray;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecStringInRange;
import gg.essential.vigilance.impl.nightconfig.core.conversion.SpecValidator;
import gg.essential.vigilance.impl.nightconfig.core.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

final class AnnotationUtils {
    private AnnotationUtils() {
    }

    static boolean isEnum(Field annotatedElement) {
        return annotatedElement.getType().isEnum() || annotatedElement.isAnnotationPresent(PreserveNotNull.class);
    }

    static boolean hasPreserveNotNull(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(PreserveNotNull.class);
    }

    static boolean mustPreserve(Field field2, Class<?> fieldClass) {
        return AnnotationUtils.hasPreserveNotNull(field2) || AnnotationUtils.hasPreserveNotNull(fieldClass);
    }

    static Converter<Object, Object> getConverter(Field field2) {
        Conversion conversion = field2.getAnnotation(Conversion.class);
        if (conversion != null) {
            try {
                Constructor<Converter<?, ?>> constructor = conversion.value().getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new ReflectionException("Cannot create a converter for field " + field2, ex);
            }
        }
        return null;
    }

    static List<String> getPath(Field field2) {
        List<String> annotatedPath = AnnotationUtils.getPath((AnnotatedElement)field2);
        return annotatedPath == null ? Collections.singletonList(field2.getName()) : annotatedPath;
    }

    static List<String> getPath(AnnotatedElement annotatedElement) {
        Path path = annotatedElement.getDeclaredAnnotation(Path.class);
        if (path != null) {
            return StringUtils.split(path.value(), '.');
        }
        AdvancedPath advancedPath = annotatedElement.getDeclaredAnnotation(AdvancedPath.class);
        if (advancedPath != null) {
            return Arrays.asList(advancedPath.value());
        }
        return null;
    }

    static void checkField(Field field2, Object value2) {
        SpecValidator specValidator;
        SpecEnum specEnum;
        SpecNotNull specNotNull = field2.getDeclaredAnnotation(SpecNotNull.class);
        if (specNotNull != null) {
            AnnotationUtils.checkNotNull(field2, value2);
            return;
        }
        SpecClassInArray specClassInArray = field2.getDeclaredAnnotation(SpecClassInArray.class);
        if (specClassInArray != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specClassInArray);
            return;
        }
        SpecStringInArray specStringInArray = field2.getDeclaredAnnotation(SpecStringInArray.class);
        if (specStringInArray != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specStringInArray);
            return;
        }
        SpecStringInRange specStringInRange = field2.getDeclaredAnnotation(SpecStringInRange.class);
        if (specStringInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specStringInRange);
            return;
        }
        SpecDoubleInRange specDoubleInRange = field2.getDeclaredAnnotation(SpecDoubleInRange.class);
        if (specDoubleInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specDoubleInRange);
            return;
        }
        SpecFloatInRange specFloatInRange = field2.getDeclaredAnnotation(SpecFloatInRange.class);
        if (specFloatInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specFloatInRange);
            return;
        }
        SpecLongInRange specLongInRange = field2.getDeclaredAnnotation(SpecLongInRange.class);
        if (specLongInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specLongInRange);
            return;
        }
        SpecIntInRange specIntInRange = field2.getDeclaredAnnotation(SpecIntInRange.class);
        if (specIntInRange != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specIntInRange);
        }
        if ((specEnum = field2.getDeclaredAnnotation(SpecEnum.class)) != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specEnum);
        }
        if ((specValidator = field2.getDeclaredAnnotation(SpecValidator.class)) != null) {
            AnnotationUtils.checkFieldSpec(field2, value2, specValidator);
        }
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecValidator spec) {
        Predicate<Object> validatorInstance;
        try {
            Constructor<? extends Predicate<Object>> constructor = spec.value().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            validatorInstance = constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException("Cannot create a converter for field " + field2, ex);
        }
        if (!validatorInstance.test(value2)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecClassInArray spec) {
        AnnotationUtils.checkNotNull(field2, value2);
        Class<?> valueClass = value2.getClass();
        if (spec.strict()) {
            for (Class<?> aClass : spec.value()) {
                if (!aClass.isAssignableFrom(valueClass)) continue;
                return;
            }
        } else {
            for (Class<?> aClass : spec.value()) {
                if (!aClass.equals(valueClass)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field2, spec);
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecStringInRange spec) {
        AnnotationUtils.checkClass(field2, value2, String.class);
        String s = (String)value2;
        if (s.compareTo(spec.min()) < 0 || s.compareTo(spec.max()) > 0) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecEnum spec) {
        EnumGetMethod m = spec.method();
        Class<?> fieldType = field2.getType();
        if (!fieldType.isEnum()) {
            throw new InvalidValueException("Field %s is annotated with @SpecEnum but isn't of type enum", field2);
        }
        Class<?> t = fieldType;
        if (!m.validate(value2, t)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecStringInArray spec) {
        AnnotationUtils.checkClass(field2, value2, String.class);
        String s = (String)value2;
        if (spec.ignoreCase()) {
            for (String acceptable : spec.value()) {
                if (!s.equalsIgnoreCase(acceptable)) continue;
                return;
            }
        } else {
            for (String acceptable : spec.value()) {
                if (!s.equals(acceptable)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field2, spec);
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecDoubleInRange spec) {
        AnnotationUtils.checkClass(field2, value2, Double.class);
        double d = (Double)value2;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", value2, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecFloatInRange spec) {
        AnnotationUtils.checkClass(field2, value2, Float.class);
        float d = ((Float)value2).floatValue();
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", value2, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecLongInRange spec) {
        AnnotationUtils.checkClass(field2, value2, Long.class);
        long d = (Long)value2;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", value2, field2, spec);
        }
    }

    private static void checkFieldSpec(Field field2, Object value2, SpecIntInRange spec) {
        AnnotationUtils.checkClass(field2, value2, Integer.class);
        int d = (Integer)value2;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", value2, field2, spec);
        }
    }

    private static void checkNotNull(Field field2, Object value2) {
        if (value2 == null) {
            throw new InvalidValueException("Invalid null value for field %s", field2);
        }
    }

    private static void checkClass(Field field2, Object value2, Class<?> expectedClass) {
        AnnotationUtils.checkNotNull(field2, value2);
        Class<?> valueClass = value2.getClass();
        if (valueClass != expectedClass) {
            throw new InvalidValueException("Invalid type %s for field %s, expected %s", valueClass, field2, expectedClass);
        }
    }
}

