/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.impl.nightconfig.toml;

import gg.essential.vigilance.impl.nightconfig.core.Config;
import gg.essential.vigilance.impl.nightconfig.core.NullObject;
import gg.essential.vigilance.impl.nightconfig.core.io.CharacterOutput;
import gg.essential.vigilance.impl.nightconfig.core.io.WritingException;
import gg.essential.vigilance.impl.nightconfig.toml.ArrayWriter;
import gg.essential.vigilance.impl.nightconfig.toml.StringWriter;
import gg.essential.vigilance.impl.nightconfig.toml.TableWriter;
import gg.essential.vigilance.impl.nightconfig.toml.TemporalWriter;
import gg.essential.vigilance.impl.nightconfig.toml.TomlWriter;
import java.time.temporal.Temporal;
import java.util.List;

final class ValueWriter {
    private static void writeString(String string, CharacterOutput output, TomlWriter writer) {
        if (writer.writesLiteral(string)) {
            StringWriter.writeLiteral(string, output);
        } else {
            StringWriter.writeBasic(string, output);
        }
    }

    static void write(Object value2, CharacterOutput output, TomlWriter writer) {
        if (value2 instanceof Config) {
            TableWriter.writeInline((Config)value2, output, writer);
        } else if (value2 instanceof List) {
            List list = (List)value2;
            if (!list.isEmpty() && list.get(0) instanceof Config) {
                for (Object table : list) {
                    TableWriter.writeInline((Config)table, output, writer);
                }
            } else {
                ArrayWriter.write((List)value2, output, writer);
            }
        } else if (value2 instanceof CharSequence) {
            ValueWriter.writeString(value2.toString(), output, writer);
        } else if (value2 instanceof Enum) {
            ValueWriter.writeString(((Enum)value2).name(), output, writer);
        } else if (value2 instanceof Temporal) {
            TemporalWriter.write((Temporal)value2, output);
        } else if (value2 instanceof Float || value2 instanceof Double) {
            double d = ((Number)value2).doubleValue();
            if (Double.isNaN(d)) {
                output.write("nan");
            } else if (d == Double.POSITIVE_INFINITY) {
                output.write("+inf");
            } else if (d == Double.NEGATIVE_INFINITY) {
                output.write("-inf");
            } else {
                output.write(value2.toString());
            }
        } else if (value2 instanceof Number || value2 instanceof Boolean) {
            output.write(value2.toString());
        } else {
            if (value2 == null || value2 == NullObject.NULL_OBJECT) {
                throw new WritingException("TOML doesn't support null values");
            }
            throw new WritingException("Unsupported value type: " + value2.getClass());
        }
    }

    private ValueWriter() {
    }
}

