/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.enchantment;

import com.oblivioussp.spartanshields.enchantment.EnchantmentSS;
import com.oblivioussp.spartanshields.init.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class PaybackEnchantment
extends EnchantmentSS {
    public static final String NBT_PAYBACK_DMG = "PaybackDamage";

    public PaybackEnchantment(Enchantment.Rarity rarityIn, EquipmentSlot ... slots) {
        super(rarityIn, EnchantmentSS.TYPE_SHIELD, slots);
    }

    public int m_6183_(int enchantmentLevel) {
        return 15 + (enchantmentLevel - 1) * 7;
    }

    public int m_6175_(int enchantmentLevel) {
        return super.m_6183_(enchantmentLevel) + 50;
    }

    public int m_6586_() {
        return 4;
    }

    @Override
    public void onUserAttacked(LivingEntity user, Entity attacker, float damage, int level) {
        ItemStack activeStack = user.m_21211_();
        if (!activeStack.m_41619_()) {
            float currentDmg = activeStack.m_41784_().m_128457_(NBT_PAYBACK_DMG);
            float maxDmg = this.getMaxDamageCapacity(level);
            float absorbedDmg = damage * this.getAbsorbedDamageRatio();
            currentDmg = Mth.m_14036_((float)(currentDmg + absorbedDmg), (float)0.0f, (float)maxDmg);
            activeStack.m_41783_().m_128350_(NBT_PAYBACK_DMG, currentDmg);
            if (currentDmg == maxDmg) {
                user.f_19853_.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)ModSounds.SHIELD_PAYBACK_CHARGE.get(), user.m_5720_(), 0.5f, 2.0f);
            }
        }
    }

    protected float getMaxDamageCapacity(int level) {
        return 2.0f * (float)level;
    }

    protected float getAbsorbedDamageRatio() {
        return 0.5f;
    }
}

