/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.oblivioussp.spartanshields.client.ClientHelper;
import com.oblivioussp.spartanshields.config.Config;
import com.oblivioussp.spartanshields.item.IDamageShield;
import com.oblivioussp.spartanshields.item.IItemPoweredFE;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.util.EnergyCapabilityProviderItem;
import com.oblivioussp.spartanshields.util.PowerUnit;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class FEPoweredShieldItem
extends ShieldBaseItem
implements IDamageShield,
IItemPoweredFE {
    public static final String NBT_ENERGY = "Energy";
    protected int energyCapacity;
    protected int maxEnergyReceive;
    protected String modName;
    protected PowerUnit preferredEnergyUnit;

    public FEPoweredShieldItem(int capacity, int maxReceive, String modName, PowerUnit preferredUnit, boolean isTowerShieldIn, Item.Properties prop) {
        super(0, isTowerShieldIn, prop);
        this.energyCapacity = isTowerShieldIn ? Mth.m_14143_((float)((float)capacity * 1.25f)) : capacity;
        this.maxEnergyReceive = maxReceive;
        this.modName = modName;
        this.preferredEnergyUnit = preferredUnit;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerPoweredShieldPropertyOverrides(this);
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> subItems) {
        if (this.m_220152_(group)) {
            ItemStack fullShield = new ItemStack((ItemLike)this);
            fullShield.m_41784_().m_128405_(NBT_ENERGY, this.energyCapacity);
            subItems.add((Object)new ItemStack((ItemLike)this));
            subItems.add((Object)fullShield);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public int m_142158_(ItemStack stack) {
        int energy = stack.m_41784_().m_128451_(NBT_ENERGY);
        return Math.round(13.0f * (float)energy / (float)this.energyCapacity);
    }

    public boolean m_142522_(ItemStack stack) {
        int energy = stack.m_41784_().m_128451_(NBT_ENERGY);
        return energy < this.energyCapacity;
    }

    public int m_142159_(ItemStack stack) {
        return 6927359;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 6927359;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return this.energyCapacity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        LocalizedNumberFormatter formatter = NumberFormatter.withLocale((Locale)Minecraft.m_91087_().m_91102_().m_118983_().getJavaLocale());
        tooltip.add((Component)Component.m_237110_((String)("tooltip.spartanshields." + this.preferredEnergyUnit.getCapacityTranslationKey()), (Object[])new Object[]{formatter.format((long)Mth.m_14143_((float)((float)this.getFEStored(stack) * this.preferredEnergyUnit.getEnergyScaleToFE()))), formatter.format((long)Mth.m_14143_((float)((float)this.getFECapacity(stack) * this.preferredEnergyUnit.getEnergyScaleToFE())))}));
        tooltip.add((Component)Component.m_237110_((String)("tooltip.spartanshields." + this.preferredEnergyUnit.getEnergyChargeRateTranslationKey()), (Object[])new Object[]{formatter.format((long)Mth.m_14143_((float)((float)this.maxEnergyReceive * this.preferredEnergyUnit.getEnergyScaleToFE())))}));
        tooltip.add((Component)Component.m_237110_((String)("tooltip.spartanshields." + this.preferredEnergyUnit.getEnergyPerDamageTranslationKey()), (Object[])new Object[]{formatter.format((long)Mth.m_14143_((float)((float)((Integer)Config.INSTANCE.damageToFEMultiplier.get() * 2) * this.preferredEnergyUnit.getEnergyScaleToFE())))}));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.spartanshields.fe_shield.desc"));
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (this.getFEStored(stack) > 0) {
            return UseAnim.BLOCK;
        }
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        ItemStack stack = player.m_21120_(hand);
        if (this.getFEStored(stack) > 0) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (level.f_46443_) {
            player.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.YELLOW.toString() + I18n.m_118938_((String)"message.spartanshields.powered_shield_block_fail", (Object[])new Object[]{stack.m_41786_().getString()}))));
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public void damageShield(ItemStack shieldStack, Player player, Entity attacker, float damage) {
        int energyToUse = Mth.m_14143_((float)damage);
        int currentEnergy = shieldStack.m_41784_().m_128451_(NBT_ENERGY);
        int energyRemoved = Math.min(energyToUse, currentEnergy);
        shieldStack.m_41783_().m_128405_(NBT_ENERGY, currentEnergy -= energyRemoved);
        if (currentEnergy == 0) {
            player.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + player.f_19853_.f_46441_.m_188501_() * 0.4f);
        }
    }

    public FEPoweredShieldItem setCapacity(int capacity) {
        this.energyCapacity = capacity;
        return this;
    }

    public FEPoweredShieldItem setMaxReceive(int maxReceive) {
        this.maxEnergyReceive = maxReceive;
        return this;
    }

    @Override
    public int receiveFE(ItemStack container, int maxReceive, boolean simulate) {
        int energy = container.m_41784_().m_128451_(NBT_ENERGY);
        int energyReceived = Math.min(this.energyCapacity - energy, Math.min(this.maxEnergyReceive, maxReceive));
        if (!simulate) {
            container.m_41783_().m_128405_(NBT_ENERGY, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractFE(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getFEStored(ItemStack container) {
        if (!container.m_41784_().m_128441_(NBT_ENERGY)) {
            return 0;
        }
        return container.m_41783_().m_128451_(NBT_ENERGY);
    }

    @Override
    public int getFECapacity(ItemStack container) {
        return this.energyCapacity;
    }

    @Override
    public boolean canExtractFE(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canReceiveFE(ItemStack stack) {
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new EnergyCapabilityProviderItem(stack, this);
    }
}

