/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.network;

import com.oblivioussp.spartanshields.config.Config;
import com.oblivioussp.spartanshields.init.ModEnchantments;
import com.oblivioussp.spartanshields.init.ModSounds;
import com.oblivioussp.spartanshields.init.ModStats;
import com.oblivioussp.spartanshields.tags.ModItemTags;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.NetworkEvent;

public class ShieldBashPacket {
    protected InteractionHand hand;
    protected int entityId;
    protected boolean attackEntity = false;

    public ShieldBashPacket(InteractionHand handIn, int entityIdIn, boolean attackEntityIn) {
        this.hand = handIn;
        this.entityId = entityIdIn;
        this.attackEntity = attackEntityIn;
    }

    public static void encode(ShieldBashPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.hand);
        buf.writeInt(packet.entityId);
        buf.writeBoolean(packet.attackEntity);
    }

    public static ShieldBashPacket decode(FriendlyByteBuf buf) {
        return new ShieldBashPacket((InteractionHand)buf.m_130066_(InteractionHand.class), buf.readInt(), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(ShieldBashPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity victim = player.f_19853_.m_6815_(packet.entityId);
                if (player.m_21254_()) {
                    ItemStack shieldStack = player.m_21120_(packet.hand);
                    boolean isTowerShield = shieldStack.m_204117_(ModItemTags.TOWER_SHIELDS);
                    if (!shieldStack.m_41619_() && !player.m_36335_().m_41519_(shieldStack.m_41720_()) && player.m_21211_().m_204117_(ModItemTags.SHIELDS_WITH_BASH) && player.m_21211_().m_41720_().canPerformAction(player.m_21211_(), ToolActions.SHIELD_BLOCK)) {
                        if (packet.attackEntity && victim != null && victim instanceof LivingEntity) {
                            int knockLvl = shieldStack.getEnchantmentLevel(Enchantments.f_44980_);
                            if (isTowerShield) {
                                double reach = player.getAttackRange();
                                for (LivingEntity entity : player.f_19853_.m_6443_(LivingEntity.class, victim.m_20191_().m_82377_(1.0, 0.25, 1.0), target -> target != player && target != victim && !target.m_7307_((Entity)player) && (!(target instanceof ArmorStand) || !((ArmorStand)target).m_31677_()) && player.m_20280_((Entity)target) < reach * reach)) {
                                    Handler.bashEntity((Entity)entity, (Player)player, shieldStack, knockLvl, packet.hand);
                                }
                            }
                            boolean powerfulBash = Handler.bashEntity(victim, (Player)player, shieldStack, knockLvl, packet.hand);
                            player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.SHIELD_BASH_HIT.get(), player.m_5720_(), 1.0f, powerfulBash ? 2.0f : 1.0f);
                            player.m_5704_(victim);
                            player.m_36220_(ModStats.SHIELD_BASH_HITS);
                        } else {
                            player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.SHIELD_BASH_MISS.get(), player.m_5720_(), 0.5f, 0.01f);
                        }
                        player.m_5810_();
                        player.m_36335_().m_41524_(shieldStack.m_41720_(), (isTowerShield ? (Integer)Config.INSTANCE.cooldownTowerShieldBash.get() : (Integer)Config.INSTANCE.cooldownShieldBash.get()).intValue());
                    }
                }
            });
        }

        protected static boolean bashEntity(Entity targetEntity, Player player, ItemStack shieldStack, int knockbackLevel, InteractionHand hand) {
            targetEntity.f_19802_ = 0;
            ((LivingEntity)targetEntity).m_147240_((double)(1.0f + (float)knockbackLevel), (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
            float bashDamage = 1.0f;
            if (shieldStack.getEnchantmentLevel((Enchantment)ModEnchantments.PAYBACK.get()) != 0) {
                bashDamage += shieldStack.m_41784_().m_128457_("PaybackDamage");
                shieldStack.m_41783_().m_128350_("PaybackDamage", 0.0f);
            }
            targetEntity.m_6469_(DamageSource.m_19344_((Player)player), bashDamage);
            shieldStack.m_41622_(5, (LivingEntity)player, entity -> entity.m_21190_(hand));
            int firebrandLvl = shieldStack.getEnchantmentLevel((Enchantment)ModEnchantments.FIREBRAND.get());
            if (firebrandLvl != 0) {
                targetEntity.m_20254_(firebrandLvl * 5);
            }
            return bashDamage > 1.0f;
        }
    }
}

