/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.api.client.container.v1.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.easyshulkerboxes.EasyShulkerBoxes;
import fuzs.easyshulkerboxes.api.client.container.v1.tooltip.ExpandableClientTooltipComponent;
import fuzs.easyshulkerboxes.impl.client.core.ClientAbstractions;
import fuzs.easyshulkerboxes.impl.client.handler.ClientInputActionHandler;
import fuzs.easyshulkerboxes.impl.config.ClientConfig;
import fuzs.easyshulkerboxes.impl.world.inventory.ContainerSlotHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class AbstractClientContainerItemTooltip
extends ExpandableClientTooltipComponent {
    public static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation TEXTURE_LOCATION = EasyShulkerBoxes.id("textures/gui/container/inventory_tooltip.png");
    private static final int BORDER_SIZE = 7;
    private static final MutableInt ACTIVE_CONTAINER_ITEM_TOOLTIPS = new MutableInt();
    protected final NonNullList<ItemStack> items;
    private final float[] backgroundColor;

    public AbstractClientContainerItemTooltip(NonNullList<ItemStack> items, float[] backgroundColor) {
        this.items = items;
        this.backgroundColor = backgroundColor;
    }

    protected abstract int getGridSizeX();

    protected abstract int getGridSizeY();

    protected boolean isSlotBlocked(int itemIndex) {
        return false;
    }

    @Override
    public int getExpandedHeight() {
        return this.getGridSizeY() * 18 + 14;
    }

    @Override
    public int getExpandedWidth(Font font) {
        return this.getGridSizeX() * 18 + 14;
    }

    @Override
    public void renderExpandedImage(Font font, int mouseX, int mouseY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        ACTIVE_CONTAINER_ITEM_TOOLTIPS.increment();
        float[] color = this.getBackgroundColor();
        if (this.defaultSize()) {
            ContainerTexture.FULL.blit(poseStack, mouseX, mouseY, blitOffset, color);
        } else {
            this.drawBorder(mouseX, mouseY, this.getGridSizeX(), this.getGridSizeY(), poseStack, blitOffset);
        }
        int itemIndex = 0;
        int lastFilledSlot = this.getLastFilledSlot();
        for (int l = 0; l < this.getGridSizeY(); ++l) {
            for (int i1 = 0; i1 < this.getGridSizeX(); ++i1) {
                int posX = mouseX + i1 * 18 + 7;
                int posY = mouseY + l * 18 + 7;
                if (!this.defaultSize()) {
                    if (this.isSlotBlocked(itemIndex)) {
                        ContainerTexture.BLOCKED_SLOT.blit(poseStack, posX, posY, blitOffset, color);
                    } else {
                        ContainerTexture.SLOT.blit(poseStack, posX, posY, blitOffset, color);
                    }
                }
                this.drawSlot(posX, posY, itemIndex, font, itemRenderer);
                if (itemIndex == lastFilledSlot) {
                    this.drawSlotOverlay(poseStack, posX, posY, blitOffset);
                }
                ++itemIndex;
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawSelectedSlotTooltip(font, mouseX, mouseY, poseStack, lastFilledSlot);
        ACTIVE_CONTAINER_ITEM_TOOLTIPS.decrement();
    }

    private void drawSelectedSlotTooltip(Font font, int mouseX, int mouseY, PoseStack poseStack, int lastFilledSlot) {
        if (!((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).selectedItemTooltips.isActive()) {
            return;
        }
        if (ACTIVE_CONTAINER_ITEM_TOOLTIPS.intValue() > 1) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null && !AbstractClientContainerItemTooltip.willTooltipBeMoved(minecraft, font, mouseX, mouseY) && lastFilledSlot >= 0 && lastFilledSlot < this.items.size()) {
            ItemStack stack = (ItemStack)this.items.get(lastFilledSlot);
            List itemTooltip = minecraft.f_91080_.m_96555_(stack);
            Optional itemTooltipImage = stack.m_150921_();
            List<ClientTooltipComponent> tooltipComponents = ClientAbstractions.INSTANCE.getTooltipComponents(minecraft.f_91080_, font, mouseX, mouseY, stack);
            int maxWidth = tooltipComponents.stream().mapToInt(tooltipComponent -> tooltipComponent.m_142069_(font)).max().orElse(0);
            poseStack.m_85836_();
            minecraft.f_91080_.m_169388_(poseStack, itemTooltip, itemTooltipImage, mouseX - maxWidth - 36, mouseY);
            poseStack.m_85849_();
        }
    }

    private static boolean willTooltipBeMoved(Minecraft minecraft, Font font, int mouseX, int mouseY) {
        Screen screen = minecraft.f_91080_;
        if (!(screen instanceof AbstractContainerScreen)) {
            return false;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        ItemStack stack = ClientInputActionHandler.getContainerStack(containerScreen, true);
        if (stack.m_41619_()) {
            return false;
        }
        List<ClientTooltipComponent> tooltipComponents = ClientAbstractions.INSTANCE.getTooltipComponents((Screen)containerScreen, font, mouseX, mouseY, stack);
        int maxWidth = tooltipComponents.stream().mapToInt(tooltipComponent -> tooltipComponent.m_142069_(font)).max().orElse(0);
        mouseX = (int)(minecraft.f_91067_.m_91589_() * (double)minecraft.m_91268_().m_85445_() / (double)minecraft.m_91268_().m_85443_());
        return mouseX + 12 + maxWidth > containerScreen.f_96543_;
    }

    private boolean defaultSize() {
        return this.getGridSizeX() == 9 && this.getGridSizeY() == 3;
    }

    private float[] getBackgroundColor() {
        if (!((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).colorfulTooltips) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        return this.backgroundColor;
    }

    private int getLastFilledSlot() {
        Minecraft minecraft = Minecraft.m_91087_();
        int currentContainerSlot = ContainerSlotHelper.getCurrentContainerSlot((Player)minecraft.f_91074_);
        if (currentContainerSlot != -1 && currentContainerSlot < this.items.size() && !((ItemStack)this.items.get(currentContainerSlot)).m_41619_()) {
            return currentContainerSlot;
        }
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    private void drawBorder(int mouseX, int mouseY, int gridSizeX, int gridSizeY, PoseStack poseStack, int blitOffset) {
        float[] color = this.getBackgroundColor();
        ContainerTexture.BORDER_TOP_LEFT.blit(poseStack, mouseX, mouseY, blitOffset, color);
        ContainerTexture.BORDER_TOP_RIGHT.blit(poseStack, mouseX + gridSizeX * 18 + 7, mouseY, blitOffset, color);
        for (int i = 0; i < gridSizeX; ++i) {
            ContainerTexture.BORDER_TOP.blit(poseStack, mouseX + 7 + i * 18, mouseY, blitOffset, color);
            ContainerTexture.BORDER_BOTTOM.blit(poseStack, mouseX + 7 + i * 18, mouseY + gridSizeY * 18 + 7, blitOffset, color);
        }
        for (int j = 0; j < gridSizeY; ++j) {
            ContainerTexture.BORDER_LEFT.blit(poseStack, mouseX, mouseY + j * 18 + 7, blitOffset, color);
            ContainerTexture.BORDER_RIGHT.blit(poseStack, mouseX + gridSizeX * 18 + 7, mouseY + j * 18 + 7, blitOffset, color);
        }
        ContainerTexture.BORDER_BOTTOM_LEFT.blit(poseStack, mouseX, mouseY + gridSizeY * 18 + 7, blitOffset, color);
        ContainerTexture.BORDER_BOTTOM_RIGHT.blit(poseStack, mouseX + gridSizeX * 18 + 7, mouseY + gridSizeY * 18 + 7, blitOffset, color);
    }

    private void drawSlot(int posX, int posY, int itemIndex, Font font, ItemRenderer itemRenderer) {
        if (itemIndex < this.items.size()) {
            ItemStack itemstack = (ItemStack)this.items.get(itemIndex);
            itemRenderer.m_174253_(itemstack, posX + 1, posY + 1, itemIndex);
            itemRenderer.m_115169_(font, itemstack, posX + 1, posY + 1);
        }
    }

    private void drawSlotOverlay(PoseStack poseStack, int posX, int posY, int blitOffset) {
        if (ACTIVE_CONTAINER_ITEM_TOOLTIPS.intValue() > 1) {
            return;
        }
        ClientConfig.SlotOverlay slotOverlay = ((ClientConfig)EasyShulkerBoxes.CONFIG.get(ClientConfig.class)).slotOverlay;
        if (slotOverlay == ClientConfig.SlotOverlay.HOTBAR) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)(posX - 3), (int)(posY - 3), (int)(blitOffset + 100), (float)0.0f, (float)22.0f, (int)24, (int)24, (int)256, (int)256);
        } else if (slotOverlay == ClientConfig.SlotOverlay.HOVER) {
            AbstractContainerScreen.m_169606_((PoseStack)poseStack, (int)(posX + 1), (int)(posY + 1), (int)blitOffset);
        }
    }

    private static enum ContainerTexture {
        SLOT(7, 7, 18, 18),
        BLOCKED_SLOT(39, 7, 18, 18),
        BORDER_TOP_LEFT(0, 0, 7, 7),
        BORDER_TOP(7, 0, 18, 7),
        BORDER_TOP_RIGHT(25, 0, 7, 7),
        BORDER_RIGHT(25, 7, 7, 18),
        BORDER_BOTTOM_RIGHT(25, 25, 7, 7),
        BORDER_BOTTOM(7, 25, 18, 7),
        BORDER_BOTTOM_LEFT(0, 25, 7, 7),
        BORDER_LEFT(0, 7, 7, 18),
        FULL(0, 32, 176, 68);

        public final int textureX;
        public final int textureY;
        public final int width;
        public final int height;

        private ContainerTexture(int textureX, int textureY, int width, int height) {
            this.textureX = textureX;
            this.textureY = textureY;
            this.width = width;
            this.height = height;
        }

        private void blit(PoseStack poseStack, int posX, int posY, int blitOffset, float[] color) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
            GuiComponent.m_93143_((PoseStack)poseStack, (int)posX, (int)posY, (int)blitOffset, (float)this.textureX, (float)this.textureY, (int)this.width, (int)this.height, (int)256, (int)256);
        }
    }
}

