/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.api.container.v1.provider;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.easyshulkerboxes.api.container.v1.ContainerItemHelper;
import fuzs.easyshulkerboxes.api.container.v1.provider.TooltipItemContainerProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class NestedTagItemProvider
implements TooltipItemContainerProvider {
    @Nullable
    private final DyeColor dyeColor;
    private final float[] backgroundColor;
    private final String[] nbtKey;
    private final List<Value> values = Lists.newArrayList();
    @Nullable
    private Set<Item> disallowedItems;

    public NestedTagItemProvider(@Nullable DyeColor dyeColor, String ... nbtKey) {
        String[] stringArray;
        this.dyeColor = dyeColor;
        this.backgroundColor = ContainerItemHelper.INSTANCE.getBackgroundColor(dyeColor);
        if (nbtKey.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Items";
        } else {
            stringArray = nbtKey;
        }
        this.nbtKey = stringArray;
    }

    protected float[] getBackgroundColor() {
        return this.backgroundColor;
    }

    protected String getNbtKey() {
        return this.nbtKey[this.nbtKey.length - 1];
    }

    private String[] getNbtPath() {
        return Arrays.copyOf(this.nbtKey, this.nbtKey.length - 1);
    }

    public NestedTagItemProvider disallowValues(Collection<String> value) {
        for (String s : value) {
            this.disallowValue(s);
        }
        return this;
    }

    public NestedTagItemProvider disallowValue(String value) {
        boolean tag = value.startsWith("#");
        if (tag) {
            value = value.substring(1);
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)value);
        Objects.requireNonNull(id, "invalid resource location '%s'".formatted(value));
        Value valueObj = tag ? new TagValue(id) : new ItemValue(id);
        this.values.add(valueObj);
        return this;
    }

    @Override
    public boolean isItemAllowedInContainer(ItemStack containerStack, ItemStack stackToAdd) {
        if (this.disallowedItems == null) {
            this.disallowedItems = (Set)this.values.stream().flatMap(value -> value.getItems().stream()).collect(ImmutableSet.toImmutableSet());
        }
        return !this.disallowedItems.contains(stackToAdd.m_41720_());
    }

    @Override
    public boolean hasItemContainerData(ItemStack containerStack) {
        CompoundTag tag = this.getItemContainerData(containerStack);
        return tag != null && tag.m_128441_(this.getNbtKey());
    }

    @Override
    @Nullable
    public final CompoundTag getItemContainerData(ItemStack containerStack) {
        return this.getItemDataAtPath(this.getItemDataBase(containerStack), false);
    }

    @Nullable
    protected CompoundTag getItemDataBase(ItemStack containerStack) {
        return containerStack.m_41783_();
    }

    @Nullable
    private CompoundTag getItemDataAtPath(@Nullable CompoundTag tag, boolean computeIfAbsent) {
        for (String path : this.getNbtPath()) {
            if (tag == null) break;
            if (tag.m_128425_(path, 10)) {
                tag = tag.m_128469_(path);
                continue;
            }
            if (computeIfAbsent) {
                CompoundTag compoundTag = new CompoundTag();
                tag.m_128365_(path, (Tag)compoundTag);
                tag = compoundTag;
                continue;
            }
            tag = null;
        }
        return tag;
    }

    @Override
    public final void setItemContainerData(ItemStack containerStack, ListTag itemsTag, String nbtKey) {
        CompoundTag itemDataBase = this.getItemDataBase(containerStack);
        if (itemsTag.isEmpty()) {
            CompoundTag itemData = this.getItemDataAtPath(itemDataBase, false);
            if (itemData != null) {
                itemData.m_128473_(nbtKey);
            }
        } else {
            if (itemDataBase == null) {
                itemDataBase = new CompoundTag();
            }
            CompoundTag itemData = this.getItemDataAtPath(itemDataBase, true);
            Objects.requireNonNull(itemData, "tag at path %s was null".formatted(Arrays.toString(this.getNbtPath())));
            itemData.m_128365_(nbtKey, (Tag)itemsTag);
        }
        if (itemDataBase != null && itemDataBase.m_128456_()) {
            itemDataBase = null;
        }
        this.setItemDataToStack(containerStack, itemDataBase);
    }

    protected void setItemDataToStack(ItemStack containerStack, @Nullable CompoundTag tag) {
        containerStack.m_41751_(tag);
    }

    @Override
    public void toJson(JsonObject jsonObject) {
        if (this.dyeColor != null) {
            jsonObject.addProperty("background_color", this.dyeColor.m_41065_());
        }
        if (this.nbtKey.length != 1 || !this.nbtKey[0].equals("Items")) {
            jsonObject.addProperty("nbt_key", String.join((CharSequence)"/", this.nbtKey));
        }
        if (!this.values.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (Value value : this.values) {
                jsonArray.add(value.getValue());
            }
            jsonObject.add("disallowed_items", (JsonElement)jsonArray);
        }
    }

    private static class TagValue
    implements Value {
        private final ResourceLocation value;
        private final TagKey<Item> tag;

        public TagValue(ResourceLocation value) {
            this.value = value;
            this.tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)this.value);
        }

        @Override
        public Collection<Item> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : Registry.f_122827_.m_206058_(this.tag)) {
                list.add((Item)holder.m_203334_());
            }
            return list;
        }

        @Override
        public String getValue() {
            return "#" + this.value.toString();
        }
    }

    private static class ItemValue
    implements Value {
        private final ResourceLocation value;
        @Nullable
        private final Item item;

        public ItemValue(ResourceLocation value) {
            this.value = value;
            this.item = Registry.f_122827_.m_7804_(this.value) ? (Item)Registry.f_122827_.m_7745_(this.value) : null;
        }

        @Override
        public Collection<Item> getItems() {
            if (this.item == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.item);
        }

        @Override
        public String getValue() {
            return this.value.toString();
        }
    }

    private static interface Value {
        public Collection<Item> getItems();

        public String getValue();
    }
}

