/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.api.container.v1.provider;

import com.google.gson.JsonObject;
import fuzs.easyshulkerboxes.api.container.v1.ContainerItemHelper;
import fuzs.easyshulkerboxes.api.container.v1.provider.ItemContainerProvider;
import fuzs.easyshulkerboxes.api.container.v1.provider.NestedTagItemProvider;
import fuzs.easyshulkerboxes.api.container.v1.tooltip.ContainerItemTooltip;
import net.minecraft.core.NonNullList;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SimpleItemProvider
extends NestedTagItemProvider {
    private final int inventoryWidth;
    private final int inventoryHeight;
    private boolean filterContainerItems;
    @Nullable
    private EquipmentSlot equipmentSlot;

    public SimpleItemProvider(int inventoryWidth, int inventoryHeight) {
        this(inventoryWidth, inventoryHeight, null, "Items");
    }

    public SimpleItemProvider(int inventoryWidth, int inventoryHeight, @Nullable DyeColor dyeColor, String ... nbtKey) {
        super(dyeColor, nbtKey);
        this.inventoryWidth = inventoryWidth;
        this.inventoryHeight = inventoryHeight;
    }

    public SimpleItemProvider filterContainerItems() {
        this.filterContainerItems = true;
        return this;
    }

    public SimpleItemProvider equipmentSlot(@Nullable EquipmentSlot equipmentSlot) {
        this.equipmentSlot = equipmentSlot;
        return this;
    }

    protected int getInventoryWidth() {
        return this.inventoryWidth;
    }

    protected int getInventoryHeight() {
        return this.inventoryHeight;
    }

    protected int getInventorySize() {
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    @Override
    public boolean allowsPlayerInteractions(ItemStack containerStack, Player player) {
        return super.allowsPlayerInteractions(containerStack, player) && (player.m_150110_().f_35937_ || this.equipmentSlot == null || player.m_6844_(this.equipmentSlot) == containerStack);
    }

    @Override
    public SimpleContainer getItemContainer(ItemStack containerStack, Player player, boolean allowSaving) {
        int inventorySize = this.getInventorySize();
        return ContainerItemHelper.INSTANCE.loadItemContainer(containerStack, (ItemContainerProvider)this, inventorySize, allowSaving, this.getNbtKey());
    }

    @Override
    public boolean isItemAllowedInContainer(ItemStack containerStack, ItemStack stackToAdd) {
        return super.isItemAllowedInContainer(containerStack, stackToAdd) && (!this.filterContainerItems || stackToAdd.m_41720_().m_142095_());
    }

    @Override
    public TooltipComponent createTooltipImageComponent(ItemStack containerStack, Player player, NonNullList<ItemStack> items) {
        return new ContainerItemTooltip(items, this.getInventoryWidth(), this.getInventoryHeight(), this.getBackgroundColor());
    }

    @Override
    public void toJson(JsonObject jsonObject) {
        jsonObject.addProperty("inventory_width", (Number)this.getInventoryWidth());
        jsonObject.addProperty("inventory_height", (Number)this.getInventoryHeight());
        if (this.filterContainerItems) {
            jsonObject.addProperty("filter_container_items", Boolean.valueOf(true));
        }
        if (this.equipmentSlot != null) {
            jsonObject.addProperty("equipment_slot", this.equipmentSlot.name());
        }
        super.toJson(jsonObject);
    }
}

