/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.impl.network;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import fuzs.easyshulkerboxes.impl.client.helper.ItemDecorationHelper;
import fuzs.easyshulkerboxes.impl.world.item.container.ItemContainerProviders;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import fuzs.puzzleslib.network.Message;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class S2CSyncItemContainerProvider
implements Message<S2CSyncItemContainerProvider> {
    private Map<ResourceLocation, JsonElement> providers;

    public S2CSyncItemContainerProvider() {
    }

    public S2CSyncItemContainerProvider(Map<ResourceLocation, JsonElement> providers) {
        this.providers = providers;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236831_(this.providers, FriendlyByteBuf::m_130085_, (friendlyByteBuf, jsonElement) -> {
            String json = JsonConfigFileUtil.GSON.toJson(jsonElement);
            friendlyByteBuf.m_130072_(json, 262144);
        });
    }

    public void read(FriendlyByteBuf buf) {
        Map map = buf.m_236847_(FriendlyByteBuf::m_130281_, friendlyByteBuf -> {
            String json = friendlyByteBuf.m_130136_(262144);
            return (JsonElement)JsonConfigFileUtil.GSON.fromJson(json, JsonElement.class);
        });
        this.providers = ImmutableMap.copyOf((Map)map);
    }

    public Message.MessageHandler<S2CSyncItemContainerProvider> makeHandler() {
        return new Message.MessageHandler<S2CSyncItemContainerProvider>(){

            public void handle(S2CSyncItemContainerProvider message, Player player, Object gameInstance) {
                ItemContainerProviders.INSTANCE.buildProviders(message.providers);
                ItemDecorationHelper.clearCache();
            }
        };
    }
}

